/*
 * Decompiled with CFR 0.152.
 */
package archives.tater.kitchenprojectiles.client;

import archives.tater.kitchenprojectiles.KnifeEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class KnifeEntityRenderer
extends EntityRenderer<KnifeEntity> {
    private static final float MIN_DISTANCE = 12.25f;
    private final ItemRenderer itemRenderer;
    private final float scale;
    private final boolean lit;
    public static boolean intangible = false;

    public KnifeEntityRenderer(EntityRendererProvider.Context ctx, float scale, boolean lit) {
        super(ctx);
        this.itemRenderer = ctx.getItemRenderer();
        this.scale = scale;
        this.lit = lit;
    }

    public KnifeEntityRenderer(EntityRendererProvider.Context context) {
        this(context, 1.0f, false);
    }

    protected int getBlockLightLevel(KnifeEntity entity, BlockPos pos) {
        return this.lit ? 15 : super.getBlockLightLevel((Entity)entity, pos);
    }

    public void render(KnifeEntity entity, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        if (entity.tickCount < 2 && this.entityRenderDispatcher.camera.getEntity().distanceToSqr((Entity)entity) < 12.25) {
            return;
        }
        matrices.pushPose();
        matrices.scale(0.85f * this.scale, 0.85f * this.scale, 0.85f * this.scale);
        matrices.translate(0.0f, -0.1f, 0.0f);
        matrices.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)tickDelta, (float)entity.yRotO, (float)entity.getYRot()) - 90.0f));
        matrices.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)tickDelta, (float)entity.xRotO, (float)entity.getXRot()) + 90.0f));
        matrices.translate((double)this.scale * 0.2, (double)this.scale * 0.1, 0.0);
        matrices.mulPose(Axis.ZP.rotationDegrees(-45.0f));
        matrices.mulPose(Axis.XP.rotationDegrees(180.0f));
        if (entity.isIntangible()) {
            intangible = true;
        }
        this.itemRenderer.renderStatic(entity.getStackClient(), ItemDisplayContext.NONE, light, OverlayTexture.NO_OVERLAY, matrices, vertexConsumers, entity.level(), entity.getId());
        intangible = false;
        matrices.popPose();
        super.render((Entity)entity, yaw, tickDelta, matrices, vertexConsumers, light);
    }

    @NotNull
    public ResourceLocation getTextureLocation(KnifeEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

