/*
 * Decompiled with CFR 0.152.
 */
package archives.tater.kitchenprojectiles.mixin;

import archives.tater.kitchenprojectiles.KitchenProjectilesSounds;
import archives.tater.kitchenprojectiles.KnifeEntity;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import vectorwing.farmersdelight.common.item.KnifeItem;
import vectorwing.farmersdelight.common.registry.ModBlocks;

@Mixin(value={KnifeItem.class})
public abstract class KnifeItemMixin
extends Item {
    public KnifeItemMixin(Item.Properties settings) {
        super(settings);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player user, InteractionHand hand) {
        ItemStack stack = user.getItemInHand(hand);
        if (stack.getMaxDamage() - stack.getDamageValue() <= 1 || level.getBlockState(KnifeItemMixin.getPlayerPOVHitResult((Level)level, (Player)user, (ClipContext.Fluid)ClipContext.Fluid.NONE).getBlockPos()).is((Block)ModBlocks.CUTTING_BOARD.get())) {
            return InteractionResultHolder.pass((Object)stack);
        }
        user.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)stack);
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 72000;
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity user, int remainingUseTicks) {
        if (!(user instanceof Player)) {
            return;
        }
        Player playerEntity = (Player)user;
        if (user.getTicksUsingItem() < 6) {
            return;
        }
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        stack.hurtAndBreak(1, user, LivingEntity.getSlotForHand((InteractionHand)user.getUsedItemHand()));
        int multishot = EnchantmentHelper.processProjectileCount((ServerLevel)serverLevel, (ItemStack)stack, (Entity)user, (int)1);
        float spread = EnchantmentHelper.processProjectileSpread((ServerLevel)serverLevel, (ItemStack)stack, (Entity)user, (float)0.0f);
        for (int i = 0; i < multishot; ++i) {
            ItemStack projectileStack;
            ItemStack itemStack = projectileStack = i == 0 ? stack : stack.copy();
            if (i != 0) {
                projectileStack.set(DataComponents.INTANGIBLE_PROJECTILE, (Object)Unit.INSTANCE);
            }
            KnifeEntity knifeEntity = new KnifeEntity(level, (LivingEntity)playerEntity, projectileStack);
            int spreadIndex = (2 * (i % 2) - 1) * (i + 1) / 2;
            float yaw = spread * (float)spreadIndex;
            Vec3 opposite = user.getUpVector(1.0f);
            Quaternionf quaternion = new Quaternionf().setAngleAxis((double)(yaw * ((float)Math.PI / 180)), opposite.x, opposite.y, opposite.z);
            Vec3 rotation = user.getViewVector(1.0f);
            Vector3f velocity = rotation.toVector3f().rotate((Quaternionfc)quaternion);
            knifeEntity.shoot(velocity.x, velocity.y, velocity.z, 1.5f, 1.0f);
            if (playerEntity.getAbilities().instabuild || i != 0) {
                knifeEntity.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
            level.addFreshEntity((Entity)knifeEntity);
            if (i != 0) continue;
            level.playSound(null, (Entity)knifeEntity, KitchenProjectilesSounds.throwing(stack), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (!playerEntity.getAbilities().instabuild) {
            stack.shrink(1);
        }
        playerEntity.awardStat(Stats.ITEM_USED.get((Object)this));
    }
}

