package archives.tater.kitchenprojectiles;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.item.v1.EnchantmentEvents;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1792;
import net.minecraft.class_1893;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vectorwing.farmersdelight.common.tag.ModTags;

public class KitchenProjectiles implements ModInitializer {
	public static final String MOD_ID = "kitchenprojectiles";

	// This logger is used to write text to the console and the log file.
	// It is considered best practice to use your mod id as the logger's name.
	// That way, it's clear which mod wrote info, warnings, and errors.
	public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

    public static class_2960 id(String path) {
        return class_2960.method_60655(MOD_ID, path);
    }

    public static final int MIN_USE_DURATION = 6;

    private static <T extends class_1297> class_1299<T> register(class_2960 id, class_1299.class_1300<T> type) {
        var key = class_5321.method_29179(class_7924.field_41266, id);
        return class_2378.method_39197(class_7923.field_41177, key, type.method_5905(key));
    }

	public static final class_1299<KnifeEntity> KNIFE_ENTITY = register(
			id("knife"),
			class_1299.class_1300.<KnifeEntity>method_5903(KnifeEntity::new, class_1311.field_17715)
					.method_17687(0.4f, 0.4f)
					.method_27299(4)
					.method_27300(20)
	);

	public static final class_5321<class_8110> KNIFE_DAMAGE = class_5321.method_29179(class_7924.field_42534, id("knife"));

    public static final class_6862<class_1792> LIGHT_KNIVES = class_6862.method_40092(class_7924.field_41197, id("light_knives"));

	@Override
	public void onInitialize() {
		// This code runs as soon as Minecraft is in a mod-load-ready state.
		// However, some things (like resources) may still be uninitialized.
		// Proceed with mild caution.
		KitchenProjectilesSounds.init();

        EnchantmentEvents.ALLOW_ENCHANTING.register((enchantment, target, enchantingContext) ->
            target.method_31573(ModTags.KNIFE_ENCHANTABLE) &&
                    enchantment.method_40230().map(key -> key == class_1893.field_9120 || key == class_1893.field_9108).orElse(false)
                    ? TriState.TRUE
                    : TriState.DEFAULT
        );
	}
}
