package archives.tater.kitchenprojectiles;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_2338;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_897;
import net.minecraft.class_9999;

@Environment(EnvType.CLIENT)
public class KnifeEntityRenderer extends class_897<KnifeEntity, KnifeEntityRenderer.KnifeEntityRenderState> {
    private static final float MIN_DISTANCE = 3.5f * 3.5f;
    private final class_10442 itemModelManager;
    private final float scale;
    private final boolean lit;

    public static boolean intangible = false;

    public KnifeEntityRenderer(class_5617.class_5618 ctx, float scale, boolean lit) {
        super(ctx);
        this.itemModelManager = ctx.method_65566();
        this.scale = scale;
        this.lit = lit;
    }

    public KnifeEntityRenderer(class_5617.class_5618 context) {
        this(context, 1.0f, false);
    }

    @Override
    protected int getBlockLight(KnifeEntity entity, class_2338 pos) {
        return lit ? 15 : super.method_24087(entity, pos);
    }

    @Override
    public KnifeEntityRenderState method_55269() {
        return new KnifeEntityRenderState();
    }

    @Override
    public void updateRenderState(KnifeEntity entity, KnifeEntityRenderState state, float tickProgress) {
        super.method_62354(entity, state, tickProgress);

        // see ProjectileEntityRenderer#updateRenderState
        state.field_53257 = entity.method_61414(tickProgress);
        state.field_53258 = entity.method_61415(tickProgress);
        state.field_53259 = entity.field_7574 - tickProgress;

        state.intangible = entity.isIntangible();
        itemModelManager.method_65595(state.knifeRenderState, entity.getStackClient(), class_811.field_4315, entity);
    }

    @Override
    public void render(KnifeEntityRenderState state, class_4587 matrices, class_4597 vertexConsumers, int light) {
//        if (state.age < 2 && dispatcher.camera.getFocusedEntity().squaredDistanceTo(state.pos) < MIN_DISTANCE) return;

        matrices.method_22903();
        matrices.method_22905(0.85f * scale, 0.85f * scale, 0.85f * scale);
        matrices.method_46416(0, -0.1f, 0);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(state.field_53258 - 90.0F));
        matrices.method_22907(class_7833.field_40718.rotationDegrees(state.field_53257 + 90.0F));
        matrices.method_22904(scale * 0.2, scale * 0.1, 0);
        matrices.method_22907(class_7833.field_40718.rotationDegrees(-45));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180));

        if (state.intangible)
            intangible = true;

        state.knifeRenderState.method_65604(matrices, vertexConsumers, light, class_4608.field_21444);

        intangible = false;

        matrices.method_22909();

        super.method_3936(state, matrices, vertexConsumers, light);
    }

    public static class KnifeEntityRenderState extends class_9999 {
        public boolean intangible;
        public class_10444 knifeRenderState = new class_10444();
    }
}
