/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.client.render;

import kamkeel.npcdbc.client.ClientProxy;
import kamkeel.npcdbc.client.shader.ShaderHelper;
import kamkeel.npcdbc.entity.EntityAura;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLivingBase;
import noppes.npcs.client.renderer.ImageData;
import org.lwjgl.opengl.GL11;

public class NewAura {
    public static final String AURA_DIR = "npcdbc:textures/aura/";
    public static final int FRAMES = 4;
    public static int currentFrame;

    public static void renderAura(EntityAura aura, float partialTicks) {
        float speed = ClientProxy.getTimeSinceStart() * 10.0f;
        currentFrame = (int)(speed % 4.0f);
        ImageData image = new ImageData("npcdbc:textures/aura/enhanced_aura.png");
        if (!image.imageLoaded()) {
            return;
        }
        image.bindTexture();
        int width = image.getTotalWidth();
        int height = image.getTotalHeight();
        int frameWidth = width / 4;
        int frameStartU = currentFrame * frameWidth;
        EntityLivingBase ren = Minecraft.func_71410_x().field_71451_h;
        float yaw = ren.field_70177_z;
        float pitch = ren.field_70125_A;
        int thirdPerson = Minecraft.func_71410_x().field_71474_y.field_74320_O;
        boolean client = Minecraft.func_71410_x().field_71439_g == aura.entity;
        float clientOffset = !client ? 1.62f : 0.0f;
        double interPosX = aura.field_70142_S + (aura.field_70165_t - aura.field_70142_S) * (double)partialTicks - RenderManager.field_78725_b;
        double interPosY = aura.field_70137_T + (aura.field_70163_u - aura.field_70137_T) * (double)partialTicks - RenderManager.field_78726_c;
        double interPosZ = aura.field_70136_U + (aura.field_70161_v - aura.field_70136_U) * (double)partialTicks - RenderManager.field_78723_d;
        ShaderHelper.useShader(ShaderHelper.aura, () -> {
            ShaderHelper.uniformColor("color1", 0xFFFF00, 1.0f);
            ShaderHelper.uniformColor("color2", 0x555500, 1.0f);
            ShaderHelper.uniformColor("color3", 0xAAAA00, 0.35f);
            ShaderHelper.uniformColor("color4", 0xAAAA00, 0.155f);
            ShaderHelper.uniformTexture("noiseTexture", 2, "npcdbc:textures/noise/noise.png");
            ShaderHelper.uniformTexture("cross", 3, "npcdbc:textures/aura/enhanced_aura_crosssection.png");
            ShaderHelper.uniform1f("speed", speed);
            ShaderHelper.uniform1f("pitch", pitch);
        });
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDepthFunc((int)517);
        GL11.glDepthMask((boolean)false);
        float scale = 5.0f;
        float yScale = scale + 2.0f;
        GL11.glPushMatrix();
        GL11.glTranslated((double)interPosX, (double)(interPosY + (double)clientOffset - (double)aura.entity.field_70131_O), (double)interPosZ);
        GL11.glTranslatef((float)0.0f, (float)(0.2f * yScale), (float)0.0f);
        GL11.glScalef((float)scale, (float)yScale, (float)scale);
        GL11.glRotatef((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(360.0f - pitch), (float)1.0f, (float)0.0f, (float)0.0f);
        if (pitch > 60.0f && thirdPerson == 1 || pitch < -60.0f && thirdPerson == 2) {
            scale = 60.0f / Math.abs(pitch) * 1.0f * 1.0f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glTranslatef((float)0.0f, (float)(0.015f * scale), (float)0.0f);
        }
        NewAura.renderQuad(image, frameStartU, 0, frameStartU + frameWidth, height);
        NewAura.renderQuad(image, frameStartU, 0, frameStartU + frameWidth, height);
        GL11.glTranslated((double)interPosX, (double)(interPosY + (double)clientOffset), (double)interPosZ);
        ShaderHelper.releaseShader();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)interPosX, (double)(interPosY + (double)clientOffset), (double)interPosZ);
        GL11.glTranslatef((float)0.0f, (float)-1.6f, (float)0.0f);
        GL11.glScalef((float)scale, (float)(scale + 3.0f), (float)scale);
        ImageData cross = new ImageData("npcdbc:textures/aura/enhanced_aura_crosssection.png");
        if (!cross.imageLoaded()) {
            return;
        }
        cross.bindTexture();
        width = cross.getTotalWidth();
        height = cross.getTotalHeight();
        frameWidth = width / 4;
        frameStartU = currentFrame * frameWidth;
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glDepthFunc((int)515);
        if (aura.field_70173_aa % 20 == 0) {
            // empty if block
        }
    }

    public static void renderQuad(ImageData imageData, int startU, int startV, int endU, int endV) {
        if (!imageData.imageLoaded()) {
            return;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        int totalWidth = imageData.getTotalWidth();
        int totalHeight = imageData.getTotalHeight();
        float textureXScale = 1.0f;
        float textureYScale = 1.0f;
        float u1 = (float)startU * (1.0f / (float)totalWidth);
        float v1 = (float)startV * (1.0f / (float)totalHeight);
        float u2 = (float)endU * (1.0f / (float)totalWidth);
        float v2 = (float)endV * (1.0f / (float)totalHeight);
        for (int i = 0; i < 2; ++i) {
            GL11.glPushMatrix();
            if (i == 1) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (totalWidth > totalHeight) {
                textureYScale = (float)totalHeight / (float)totalWidth;
                GL11.glScalef((float)(1.0f / textureYScale / 2.0f), (float)(1.0f / textureYScale / 2.0f), (float)(1.0f / textureYScale / 2.0f));
            } else if (totalHeight > totalWidth) {
                textureXScale = (float)totalWidth / (float)totalHeight;
                GL11.glScalef((float)(1.0f / textureXScale / 2.0f), (float)(1.0f / textureXScale / 2.0f), (float)(1.0f / textureXScale / 2.0f));
            }
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)(textureXScale * -(u2 - u1) / 2.0f), (double)(textureYScale * (v2 - v1) / 2.0f), 0.0, (double)u1, (double)v1);
            tessellator.func_78374_a((double)(textureXScale * (u2 - u1) / 2.0f), (double)(textureYScale * (v2 - v1) / 2.0f), 0.0, (double)u2, (double)v1);
            tessellator.func_78374_a((double)(textureXScale * (u2 - u1) / 2.0f), (double)(textureYScale * -(v2 - v1) / 2.0f), 0.0, (double)u2, (double)v2);
            tessellator.func_78374_a((double)(textureXScale * -(u2 - u1) / 2.0f), (double)(textureYScale * -(v2 - v1) / 2.0f), 0.0, (double)u1, (double)v2);
            tessellator.func_78381_a();
            GL11.glPopMatrix();
        }
    }
}

