/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.config;

import JinRyuu.JRMCore.JRMCoreH;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import kamkeel.npcdbc.client.ClientCache;
import net.minecraftforge.common.config.Configuration;
import noppes.npcs.util.ValueUtil;
import org.apache.logging.log4j.Level;

public class ConfigDBCEffects {
    public static Configuration config;
    public static final String REGEN = "Regen";
    public static int HealthRegenPercent;
    public static int KiRegenPercent;
    public static int StaminaRegenPercent;
    public static final String NAMEK_REGEN = "Namekian_Regen";
    public static int NamekRegenPercent;
    public static final String FRUITOFMIGHT = "Fruit_of_Might";
    public static double FOM_Strength;
    public static double FOM_Dex;
    public static double FOM_Will;
    public static int FOM_EffectLength;
    public static double FOM_KiDrain;
    public static boolean FOM_Aura;
    public static final String CHOCOLATED = "Chocolated";
    public static double CHOC_Str;
    public static double CHOC_Dex;
    public static double CHOC_Wil;
    public static int CHOC_EffectLength;
    public static boolean CHOC_AffectFusion;
    public static final String ZENKAI = "Zenkai";
    public static double ZenkaiSaiyanStr;
    public static double ZenkaiSaiyanDex;
    public static double ZenkaiSaiyanWil;
    public static int ZenkaiSaiyanLength;
    public static double ZenkaiHALFStr;
    public static double ZenkaiHALFDex;
    public static double ZenkaiHALFWil;
    public static int ZenkaiHALFLength;
    public static final String Meditation = "Meditation";
    public static int MeditationSpiBoostPercent;
    public static final String Potara = "Potara";
    public static double TierOneMulti;
    public static double TierTwoMulti;
    public static double TierThreeMulti;
    public static final String OVERPOWER = "OVERPOWER";
    public static int OVERPOWER_AMOUNT;
    public static final String EXHAUST = "EXHAUST";
    public static int EXHAUST_TIME;
    public static boolean EXHAUST_ZENKAI;
    public static int EXHAUST_ZENKAI_TIME;
    public static boolean EXHAUST_OVERPOWER;
    public static int EXHAUST_OVERPOWER_TIME;
    public static boolean EXHAUST_HUMANSPIRIT;
    public static int EXHAUST_HUMANSPIRIT_TIME;
    public static boolean EXHAUST_COLDBLOODED;
    public static int EXHAUST_COLDBLOODED_TIME;
    public static final String DIVINE = "DIVINE";
    public static final String DIVINE_RACES = "DIVINE RACES";
    private static float divineMulti;
    private static final HashMap<Integer, HashMap<String, Boolean>> divineApplicableForms;
    public static final String HumanSpirit = "HUMAN SPIRIT";
    public static double HumanSpiritConBoostPercent;
    public static double HumanSpiritDexBoostPercent;
    public static int HumanSpiritLength;
    public static final String Bloated = "BLOATED";
    public static boolean AUTO_BLOATED;
    public static int BLOATED_THRESHOLD;
    public static int DECREASE_TIME;
    public static int MAX_THRESHOLD_EXCEED;
    public static int BLOATED_TIME;

    public static float getDivineMulti() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            return divineMulti;
        }
        return ClientCache.divineMulti;
    }

    public static HashMap<Integer, HashMap<String, Boolean>> getDivineApplicableForms() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            return divineApplicableForms;
        }
        return ClientCache.divineApplicableForms;
    }

    public static boolean canDivineBeApplied(int race, String formName) {
        HashMap<Integer, HashMap<String, Boolean>> raceMap = ConfigDBCEffects.getDivineApplicableForms();
        HashMap<String, Boolean> formMap = raceMap.get(race);
        if (formMap == null || formMap.isEmpty()) {
            return false;
        }
        if (race >= JRMCoreH.trans.length) {
            return false;
        }
        return formMap.getOrDefault(formName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(File configFile) {
        config = new Configuration(configFile);
        try {
            config.load();
            HealthRegenPercent = config.get(REGEN, "Health Regen", 5, "Amount of Percent to restore per Level of Regen").getInt(5);
            KiRegenPercent = config.get(REGEN, "Ki Regen", 5, "Amount of Percent to restore per Level of Regen").getInt(5);
            StaminaRegenPercent = config.get(REGEN, "Stamina Regen", 5, "Amount of Percent to restore per Level of Regen").getInt(5);
            NamekRegenPercent = config.get(NAMEK_REGEN, "Namek Regen", 3, "Namekian Regen is removed once the player reaches the specified amount in Gameplay Config.\nThis value is percent health restored per second.").getInt(3);
            FOM_Strength = config.get(FRUITOFMIGHT, "Strength Multi", 1.2, "Amount added to Strength Multi [EX: Form is 1.5x and FOM is x0.5. Total is: x2.0]").getDouble(1.2);
            FOM_Dex = config.get(FRUITOFMIGHT, "Dex Multi", 0.5, "Amount added to Dex Multi").getDouble(0.5);
            FOM_Will = config.get(FRUITOFMIGHT, "Will Multi", 0.5, "Amount added to Will Multi").getDouble(0.5);
            FOM_EffectLength = config.get(FRUITOFMIGHT, "Effect Time", 90, "Amount of time in seconds the Fruit of Might Effect is applied for").getInt(90);
            FOM_KiDrain = config.get(FRUITOFMIGHT, "Effect Drain", -0.8, "Ki Drain Percent per Second").getDouble(-0.8);
            FOM_Aura = config.get(FRUITOFMIGHT, "Aura Override", true, "Enables Fruit of Might Aura disabling current Aura").getBoolean(true);
            config.addCustomCategoryComment(ZENKAI, "Zenkai will occur when a Saiyan or Half Saiyan dies. This can be disabled in\nthe DBC Gameplay Config. If the Zenaki effect is given to a none Saiyan. It will\nutilitze the Half Saiyan Config values. All multis are ADDED multis.");
            ZenkaiSaiyanStr = config.get(ZENKAI, "Saiyan Strength Multi", (double)1.2f, "Amount added to Strength Multi").getDouble(1.0);
            ZenkaiSaiyanDex = config.get(ZENKAI, "Saiyan Dex Multi", (double)1.2f, "Amount added to Dex Multi").getDouble(1.0);
            ZenkaiSaiyanWil = config.get(ZENKAI, "Saiyan Will Multi", (double)1.2f, "Amount added to Will Multi").getDouble(1.0);
            ZenkaiSaiyanLength = config.get(ZENKAI, "Saiyan Zenkai Length", 360, "Time of Zenkai in Seconds").getInt(360);
            ZenkaiHALFStr = config.get(ZENKAI, "Half Saiyan Strength Multi", (double)1.2f, "Amount added to Strength Multi").getDouble(1.0);
            ZenkaiHALFDex = config.get(ZENKAI, "Half Saiyan Dex Multi", (double)1.2f, "Amount added to Dex Multi").getDouble(1.0);
            ZenkaiHALFWil = config.get(ZENKAI, "Half Saiyan Will Multi", (double)1.2f, "Amount added to Will Multi").getDouble(1.0);
            ZenkaiHALFLength = config.get(ZENKAI, "Half Saiyan Zenkai Length", 180, "Time of Zenkai in Seconds").getInt(180);
            config.addCustomCategoryComment(CHOCOLATED, "Chocolated will occur when [WORK IN PROGRESS]");
            CHOC_Str = config.get(CHOCOLATED, "Chocolated Strength Multi", -0.2, "debuff amount to Strength multi").getDouble(1.0);
            CHOC_Dex = config.get(CHOCOLATED, "Chocolated Dex Multi", -0.2, "debuff amount to Dex multi").getDouble(1.0);
            CHOC_Wil = config.get(CHOCOLATED, "Chocolated Will Multi", -0.2, "debuff amount to Will multi").getDouble(1.0);
            CHOC_EffectLength = config.get(CHOCOLATED, "Chocolated Effect Length", 90, "Amount of time in seconds the Chocolated Effect is applied for").getInt(90);
            CHOC_AffectFusion = config.get(CHOCOLATED, "Chocolated Affect Fusion", false, "whether fusions will be affected by chocolated or not").getBoolean(false);
            config.addCustomCategoryComment(Meditation, "Meditation Spirit Bonus is always added AFTER all other calculations");
            MeditationSpiBoostPercent = config.get(Meditation, "Meditation Boost", 20, "Amount of percent to multiply Base Spirit Stats by").getInt(20);
            config.addCustomCategoryComment(Potara, "If the Potara Status Effect Multi is set to 0 or below, then the Status Effect will not be applied\nThis mutli is added (not multiplied) to [Str, Dex, Wil]");
            TierOneMulti = config.get(Potara, "Tier 1 Multi", 0.5).getDouble(0.5);
            TierTwoMulti = config.get(Potara, "Tier 2 Multi", (double)0.7f).getDouble((double)0.7f);
            TierThreeMulti = config.get(Potara, "Tier 3 Multi", 1.0).getDouble(1.0);
            OVERPOWER_AMOUNT = config.get(OVERPOWER, "Overpower Amount", 25, "Overpower allows a player to increase their release above their natural limit. Potential Unlock Level \nis included in this calculation. So if their limit is 50 percent then their new limit is 50 + Overpower Amount.The range of accepted values are [0 to 25].").getInt(25);
            OVERPOWER_AMOUNT = ValueUtil.clamp((int)OVERPOWER_AMOUNT, (int)0, (int)25);
            config.addCustomCategoryComment(EXHAUST, "Exhausted prevents specific effects from being applied to the player.\nSimilar to Pain or NoFuse, it acts as a Cooldown");
            EXHAUST_TIME = config.get(EXHAUST, "0. Exhaust Time", 15, "Amount of Time in Minutes for Exhaust [Default Apply]").getInt(15);
            EXHAUST_TIME = Math.max(EXHAUST_TIME, 0);
            EXHAUST_ZENKAI = config.get(EXHAUST, "1. Exhaust Zenkai", true, "Allows Zenkai to cause Exhaustion").getBoolean(true);
            EXHAUST_ZENKAI_TIME = config.get(EXHAUST, "1. Exhaust Zenkai Time", 15, "Amount of Time in Minutes for Exhaust after Zenkai").getInt(15);
            EXHAUST_ZENKAI_TIME = Math.max(EXHAUST_ZENKAI_TIME, 0);
            EXHAUST_OVERPOWER = config.get(EXHAUST, "2. Exhaust Overpower", true, "Allows Overpower to cause Exhaustion").getBoolean(true);
            EXHAUST_OVERPOWER_TIME = config.get(EXHAUST, "2. Exhaust Zenkai Time", 15, "Amount of Time in Minutes for Exhaust after Overpower").getInt(15);
            EXHAUST_OVERPOWER_TIME = Math.max(EXHAUST_OVERPOWER_TIME, 0);
            EXHAUST_HUMANSPIRIT = config.get(EXHAUST, "3. Exhaust Human Spirit", true, "Allows Human Spirit to cause Exhaustion").getBoolean(true);
            EXHAUST_HUMANSPIRIT_TIME = config.get(EXHAUST, "3. Exhaust Human Spirit Time", 15, "Amount of Time in Minutes for Exhaust after Human Spirit").getInt(15);
            EXHAUST_HUMANSPIRIT_TIME = Math.max(EXHAUST_HUMANSPIRIT_TIME, 0);
            EXHAUST_COLDBLOODED = config.get(EXHAUST, "4. Exhaust Cold Blooded", true, "Allows Cold Blooded to cause Exhaustion").getBoolean(true);
            EXHAUST_COLDBLOODED_TIME = config.get(EXHAUST, "4. Exhaust Cold Blooded Time", 15, "Amount of Time in Minutes for Exhaust").getInt(15);
            EXHAUST_COLDBLOODED_TIME = Math.max(EXHAUST_COLDBLOODED_TIME, 0);
            config.addCustomCategoryComment(Bloated, "Settings related to the Bloated status effect.\nThis effect is applied when players consume too many Senzus.\n\nExample Config:\nBLOATED_EFFECT {\n  BLOATED_THRESHOLD: 20\n  DECREASE_TIME: 5\n  MAX_THRESHOLD_EXCEED: 5\n  BLOATED_TIME: 300\n}\n\n--- Configuration Options ---\n\nBLOATED_THRESHOLD: Maximum number of Senzus a player can safely consume within a specific time window.\n  - Strict Configuration: Set to a lower value (e.g., 10) for fewer Senzus before penalties.\n  - Lenient Configuration: Set to a higher value (e.g., 30) for more Senzus without penalty.\n  Example: Setting to 20 allows up to 20 Senzus without penalty.\n\nDECREASE_TIME: Time interval (in ticks) for the consumption count to decrease.\n  - Strict Configuration: Set to a smaller value (e.g., 3) for quicker reduction of the count.\n  - Lenient Configuration: Set to a larger value (e.g., 10) for slower decay of the count.\n  Example: Setting to 5 means the count is reduced every 5 ticks (0.25 seconds).\n\nMAX_THRESHOLD_EXCEED: Maximum Senzus above the BLOATED_THRESHOLD before triggering the 'Bloated' effect.\n  - Strict Configuration: Set to a lower value (e.g., 2) for quicker triggering of the effect.\n  - Lenient Configuration: Set to a higher value (e.g., 10) for more excess consumption allowed.\n  Example: Setting to 5 means consuming 5 more Senzus leads to 'Bloated'.\n\nBLOATED_TIME: Duration (in seconds) for which the 'Bloated' effect lasts.\n  - Strict Configuration: Set to a lower value (e.g., 10) for shorter effect duration.\n  - Lenient Configuration: Set to a higher value (e.g., 60) for prolonged penalties.\n  Example: Setting to 300 means the effect lasts for 5 minutes (300 seconds).");
            AUTO_BLOATED = config.get(Bloated, "Automatic Bloated", true, "Allow the bloated status effect to be automatically given using the threshold mechanic").getBoolean(true);
            BLOATED_THRESHOLD = config.get(Bloated, "Bloated Threshold", 5, "Maximum number of Senzus a player can safely consume within a specific time window.\nExample: Setting to 20 means a player can consume up to 20 Senzus without penalty.").getInt(20);
            DECREASE_TIME = config.get(Bloated, "Decrease Time", 100, "Time interval (in ticks) at which the player's consumption count is decreased.\nExample: Setting to 100 means that every 100 ticks (5 seconds), the count is reduced by 1.").getInt(100);
            MAX_THRESHOLD_EXCEED = config.get(Bloated, "Max Threshold", 3, "Maximum amount of Senzus a player can consume above the BLOATED THRESHOLD\nbefore triggering the 'Bloated' effect.\nExample: Setting to 3 means consuming 3 more Senzus leads to 'Bloated'.").getInt(10);
            BLOATED_TIME = config.get(Bloated, "Bloated Time", 300, "Duration (in seconds) for which the 'Bloated' effect will be applied automatically.\nExample: Setting to 300 means the effect lasts for 5 minutes (300 seconds).").getInt(300);
            config.addCustomCategoryComment(DIVINE, "Forms can now benefit from an additional multi\n\nDivine is applied in a similar manner as Majin and Legendary\n\nFormula:\n formMulti = ( multi x racialBoost ) x masteryMultiModifier\n result = baseStat x [(formMulti x kaiokenMulti) + (formMulti x majin) + (formMulti x legendary) + (formMulti x divine)\n\nWHERE:\n - racialBoost is the multi gained from Arcosian PowerPoints or Majin Absorption\n - kaiokenMulti is the multi gained from kaioken. If you're not in kaioken, the multi is 1.0");
            divineMulti = (float)config.get(DIVINE, "Divine status effect multi", 1.0, "Put the boost in multiplier form. 1.0 is no boost, 1.15 = 15% boost").getDouble(1.0);
            config.addCustomCategoryComment(HumanSpirit, "Human Spirit is a boost in Dex and Con. It can be auto triggered from within the Gameplay Config.");
            HumanSpiritConBoostPercent = config.get(HumanSpirit, "Con Boost Percent", 20, "Additional percent boost to Constitution provided by Human Spirit.").getDouble(20.0);
            HumanSpiritDexBoostPercent = config.get(HumanSpirit, "Dex Boost Percent", 20, "Additional percent boost to Dexterity provided by Human Spirit.").getDouble(20.0);
            HumanSpiritLength = config.get(HumanSpirit, "Effect Length", 360, "Duration of the Human Spirit effect in seconds.").getInt(360);
            String[][] defaultDivineRaces = new String[][]{{"God"}, {"SSGod", "SSB", "SSGodR", "SSBE"}, {"SSGod", "SSB", "SSGodR", "SSBE"}, {"God"}, {"Ultimate", "God"}, {"Pure", "God"}};
            for (int i = 0; i < JRMCoreH.Races.length; ++i) {
                String[] formNames;
                HashMap<String, Boolean> formsAffected = new HashMap<String, Boolean>();
                ArrayList<String> result = new ArrayList<String>(JRMCoreH.trans[i].length + JRMCoreH.transNonRacial.length - 1);
                Collections.addAll(result, JRMCoreH.trans[i]);
                for (int x = 1; x < JRMCoreH.transNonRacial.length; ++x) {
                    result.add(JRMCoreH.transNonRacial[x]);
                }
                String[] legalValues = result.toArray(new String[0]);
                StringBuilder legalValuesComment = new StringBuilder();
                for (int y = 0; y < legalValues.length; ++y) {
                    if (y != 0) {
                        legalValuesComment.append(",");
                    }
                    legalValuesComment.append(legalValues[y]);
                }
                for (String name : formNames = config.getStringList(JRMCoreH.Races[i] + " - Divine affected forms", DIVINE_RACES, defaultDivineRaces[i], "Forms affected by divine multi.\nLegal values: " + legalValuesComment + "\n", legalValues)) {
                    formsAffected.put(name, true);
                }
                divineApplicableForms.put(i, formsAffected);
            }
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"DBC Addon has had a problem loading its status effect configuration", (Object[])new Object[0]);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    static {
        HealthRegenPercent = 5;
        KiRegenPercent = 5;
        StaminaRegenPercent = 5;
        NamekRegenPercent = 3;
        FOM_Strength = 1.2;
        FOM_Dex = 0.5;
        FOM_Will = 0.5;
        FOM_EffectLength = 90;
        FOM_KiDrain = -0.8;
        FOM_Aura = true;
        CHOC_Str = -0.2;
        CHOC_Dex = -0.2;
        CHOC_Wil = -0.2;
        CHOC_EffectLength = 90;
        CHOC_AffectFusion = false;
        ZenkaiSaiyanStr = 1.0;
        ZenkaiSaiyanDex = 1.0;
        ZenkaiSaiyanWil = 1.0;
        ZenkaiSaiyanLength = 360;
        ZenkaiHALFStr = 1.0;
        ZenkaiHALFDex = 1.0;
        ZenkaiHALFWil = 1.0;
        ZenkaiHALFLength = 180;
        MeditationSpiBoostPercent = 20;
        TierOneMulti = 0.5;
        TierTwoMulti = 0.7;
        TierThreeMulti = 1.0;
        OVERPOWER_AMOUNT = 25;
        EXHAUST_TIME = 15;
        EXHAUST_ZENKAI = true;
        EXHAUST_ZENKAI_TIME = 15;
        EXHAUST_OVERPOWER = true;
        EXHAUST_OVERPOWER_TIME = 15;
        EXHAUST_HUMANSPIRIT = true;
        EXHAUST_HUMANSPIRIT_TIME = 15;
        EXHAUST_COLDBLOODED = true;
        EXHAUST_COLDBLOODED_TIME = 15;
        divineMulti = 1.0f;
        divineApplicableForms = new HashMap();
        HumanSpiritConBoostPercent = 20.0;
        HumanSpiritDexBoostPercent = 20.0;
        HumanSpiritLength = 360;
        AUTO_BLOATED = true;
        BLOATED_THRESHOLD = 5;
        DECREASE_TIME = 100;
        MAX_THRESHOLD_EXCEED = 5;
        BLOATED_TIME = 300;
    }
}

