/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data.form;

import kamkeel.npcdbc.api.form.IAdvancedFormStat;
import kamkeel.npcdbc.api.form.IFormAdvanced;
import kamkeel.npcdbc.data.form.Form;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class FormAdvanced
implements IFormAdvanced {
    private final Form parent;
    private static final int NUM_STATS = 12;
    public static final String[] STAT_NAMES = new String[]{"Melee", "Defense", "Body", "Stamina", "EnergyPower", "EnergyPool", "MaxSkills", "Speed", "RegenRateBody", "RegenRateStamina", "RegenRateEnergy", "FlySpeed"};
    private final AdvancedFormStat[] formStats;

    public FormAdvanced(Form parent) {
        this.parent = parent;
        this.formStats = new AdvancedFormStat[12];
        for (int i = 0; i < 12; ++i) {
            this.formStats[i] = new AdvancedFormStat();
        }
    }

    @Override
    public AdvancedFormStat getStat(int id) {
        if (id < 0 || id >= 12) {
            return null;
        }
        return this.formStats[id];
    }

    @Override
    public void setStatEnabled(int id, boolean enabled) {
        if (id == 6) {
            return;
        }
        AdvancedFormStat stat = this.getStat(id);
        if (stat != null) {
            stat.setEnabled(enabled);
        }
    }

    @Override
    public boolean isStatEnabled(int id) {
        if (id == 6) {
            return false;
        }
        AdvancedFormStat stat = this.getStat(id);
        return stat != null && stat.isEnabled();
    }

    @Override
    public void setStatBonus(int id, int bonus) {
        if (id == 6) {
            return;
        }
        AdvancedFormStat stat = this.getStat(id);
        if (stat != null) {
            stat.setBonus(bonus);
        }
    }

    @Override
    public int getStatBonus(int id) {
        if (id == 6) {
            return 0;
        }
        AdvancedFormStat stat = this.getStat(id);
        return stat != null ? stat.getBonus() : 0;
    }

    @Override
    public void setStatMulti(int id, float multiplier) {
        if (id == 6) {
            return;
        }
        AdvancedFormStat stat = this.getStat(id);
        if (stat != null) {
            stat.setMultiplier(multiplier);
        }
    }

    @Override
    public float getStatMulti(int id) {
        if (id == 6) {
            return 1.0f;
        }
        AdvancedFormStat stat = this.getStat(id);
        return stat != null ? stat.getMultiplier() : 1.0f;
    }

    @Override
    public IFormAdvanced save() {
        if (this.parent != null) {
            this.parent.save();
        }
        return this;
    }

    public void readFromNBT(NBTTagCompound compound) {
        NBTTagCompound tag = compound.func_74775_l("formAdvanced");
        for (int i = 0; i < 12; ++i) {
            NBTTagCompound statTag;
            if (i == 6 || !tag.func_74764_b(STAT_NAMES[i]) || !(statTag = tag.func_74775_l(STAT_NAMES[i])).func_74767_n("enabled")) continue;
            this.formStats[i].setEnabled(true);
            this.formStats[i].setBonus(statTag.func_74764_b("bonus") ? statTag.func_74762_e("bonus") : 0);
            this.formStats[i].setMultiplier(statTag.func_74764_b("multiplier") ? statTag.func_74760_g("multiplier") : 1.0f);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        NBTTagCompound tag = new NBTTagCompound();
        for (int i = 0; i < 12; ++i) {
            if (i == 6 || !this.formStats[i].isEnabled()) continue;
            NBTTagCompound statTag = new NBTTagCompound();
            statTag.func_74757_a("enabled", true);
            statTag.func_74768_a("bonus", this.formStats[i].getBonus());
            statTag.func_74776_a("multiplier", this.formStats[i].getMultiplier());
            tag.func_74782_a(STAT_NAMES[i], (NBTBase)statTag);
        }
        compound.func_74782_a("formAdvanced", (NBTBase)tag);
        return compound;
    }

    public static class AdvancedFormStat
    implements IAdvancedFormStat {
        private boolean enabled = false;
        private int bonus = 0;
        private float multiplier = 1.0f;

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public int getBonus() {
            return this.bonus;
        }

        @Override
        public void setBonus(int bonus) {
            this.bonus = bonus;
        }

        @Override
        public float getMultiplier() {
            return this.multiplier;
        }

        @Override
        public void setMultiplier(float multiplier) {
            this.multiplier = multiplier;
        }
    }
}

