/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.network.packets.player;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import kamkeel.npcdbc.constants.enums.EnumNBTType;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.network.AbstractPacket;
import kamkeel.npcdbc.network.DBCPacketHandler;
import kamkeel.npcdbc.network.PacketChannel;
import kamkeel.npcdbc.network.packets.EnumPacketPlayer;
import kamkeel.npcs.util.ByteBufUtils;
import net.minecraft.entity.player.EntityPlayer;
import noppes.npcs.NoppesUtilServer;

public final class DBCSetValPacket
extends AbstractPacket {
    public static final String packetName = "NPC|SetValue";
    private EnumNBTType type;
    private EntityPlayer player;
    private String tag;
    private Object value;

    public DBCSetValPacket(EntityPlayer player, EnumNBTType type, String tag, Object value) {
        this.player = player;
        this.type = type;
        this.tag = tag;
        this.value = value;
    }

    public DBCSetValPacket() {
    }

    @Override
    public Enum getType() {
        return EnumPacketPlayer.SetVal;
    }

    @Override
    public PacketChannel getChannel() {
        return DBCPacketHandler.PLAYER_PACKETS;
    }

    @Override
    public void sendData(ByteBuf out) throws IOException {
        ByteBufUtils.writeUTF8String((ByteBuf)out, (String)this.player.func_70005_c_());
        out.writeInt(this.type.ordinal());
        ByteBufUtils.writeUTF8String((ByteBuf)out, (String)this.tag);
        DBCData dbcData = DBCData.get(this.player);
        switch (this.type) {
            case STRING: {
                ByteBufUtils.writeUTF8String((ByteBuf)out, (String)((String)this.value));
                dbcData.getRawCompound().func_74778_a(this.tag, (String)this.value);
                break;
            }
            case BYTE: {
                out.writeByte((int)((Byte)this.value).byteValue());
                dbcData.getRawCompound().func_74774_a(this.tag, ((Byte)this.value).byteValue());
                break;
            }
            case INT: {
                out.writeInt(((Integer)this.value).intValue());
                dbcData.getRawCompound().func_74768_a(this.tag, ((Integer)this.value).intValue());
                break;
            }
            case FLOAT: {
                out.writeFloat(((Float)this.value).floatValue());
                dbcData.getRawCompound().func_74776_a(this.tag, ((Float)this.value).floatValue());
                break;
            }
            case DOUBLE: {
                out.writeDouble(((Double)this.value).doubleValue());
                dbcData.getRawCompound().func_74780_a(this.tag, ((Double)this.value).doubleValue());
                break;
            }
            case BOOLEAN: {
                out.writeBoolean(((Boolean)this.value).booleanValue());
                dbcData.getRawCompound().func_74757_a(this.tag, ((Boolean)this.value).booleanValue());
            }
        }
    }

    @Override
    public void receiveData(ByteBuf in, EntityPlayer player) throws IOException {
        String playerName = ByteBufUtils.readUTF8String((ByteBuf)in);
        EntityPlayer sendingPlayer = NoppesUtilServer.getPlayerByName((String)playerName);
        if (sendingPlayer == null) {
            return;
        }
        int enumOrdinal = in.readInt();
        EnumNBTType nbtType = EnumNBTType.values()[enumOrdinal];
        String tag = ByteBufUtils.readUTF8String((ByteBuf)in);
        if (tag == null || tag.isEmpty()) {
            return;
        }
        DBCData dbcData = DBCData.get(sendingPlayer);
        switch (nbtType) {
            case STRING: {
                String newString = ByteBufUtils.readUTF8String((ByteBuf)in);
                dbcData.getRawCompound().func_74778_a(tag, newString);
                break;
            }
            case BYTE: {
                byte byteValue = in.readByte();
                dbcData.getRawCompound().func_74774_a(tag, byteValue);
                break;
            }
            case INT: {
                int intValue = in.readInt();
                dbcData.getRawCompound().func_74768_a(tag, intValue);
                break;
            }
            case FLOAT: {
                float floatValue = in.readFloat();
                dbcData.getRawCompound().func_74776_a(tag, floatValue);
                break;
            }
            case DOUBLE: {
                double doubleValue = in.readDouble();
                dbcData.getRawCompound().func_74780_a(tag, doubleValue);
                break;
            }
            case BOOLEAN: {
                boolean boolValue = in.readBoolean();
                dbcData.getRawCompound().func_74757_a(tag, boolValue);
            }
        }
    }
}

