/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.network.packets.request.form;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import kamkeel.npcdbc.controllers.FormController;
import kamkeel.npcdbc.data.form.Form;
import kamkeel.npcdbc.network.AbstractPacket;
import kamkeel.npcdbc.network.DBCAddonPermissions;
import kamkeel.npcdbc.network.DBCPacketHandler;
import kamkeel.npcdbc.network.NetworkUtility;
import kamkeel.npcdbc.network.PacketChannel;
import kamkeel.npcdbc.network.packets.EnumPacketRequest;
import kamkeel.npcs.network.packets.data.large.GuiDataPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.CustomNpcsPermissions;

public class DBCRemoveForm
extends AbstractPacket {
    public static final String packetName = "NPC|RemForm";
    private int formID;

    public DBCRemoveForm(int formID) {
        this.formID = formID;
    }

    public DBCRemoveForm() {
    }

    @Override
    public Enum getType() {
        return EnumPacketRequest.FormRemove;
    }

    @Override
    public PacketChannel getChannel() {
        return DBCPacketHandler.REQUEST_PACKETS;
    }

    @Override
    public void sendData(ByteBuf out) throws IOException {
        out.writeInt(this.formID);
    }

    @Override
    public void receiveData(ByteBuf in, EntityPlayer player) throws IOException {
        if (!CustomNpcsPermissions.hasPermission((EntityPlayer)player, (CustomNpcsPermissions.Permission)DBCAddonPermissions.GLOBAL_DBCFORM)) {
            return;
        }
        int formID = in.readInt();
        FormController.getInstance().delete(formID);
        NetworkUtility.sendCustomFormDataAll((EntityPlayerMP)player);
        NBTTagCompound compound = new Form().writeToNBT();
        GuiDataPacket.sendGuiData((EntityPlayerMP)((EntityPlayerMP)player), (NBTTagCompound)compound);
    }
}

