/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTHelper {
    public static <T> NBTTagList nbtIntegerObjectMap(Map<Integer, T> map, Function<T, NBTTagCompound> toNBT) {
        return NBTHelper.nbtIntegerObjectMap(map, toNBT, (ignored, ignored2) -> true);
    }

    public static <T> NBTTagList nbtIntegerObjectMap(Map<Integer, T> map, Function<T, NBTTagCompound> toNBT, KeepConditionCallback<Integer, T> keepCondition) {
        NBTTagList nbttaglist = new NBTTagList();
        if (map != null) {
            for (Map.Entry<Integer, T> entry : map.entrySet()) {
                T value = entry.getValue();
                if (value == null || !keepCondition.check(entry.getKey(), value)) continue;
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74768_a("Slot", entry.getKey().intValue());
                nbttagcompound.func_74782_a("Content", (NBTBase)toNBT.apply(value));
                nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            }
        }
        return nbttaglist;
    }

    public static <T> HashMap<Integer, T> javaIntegerObjectMap(NBTTagList list, Function<NBTTagCompound, T> fromNBT, KeepConditionCallback<Integer, T> keepCondition) {
        HashMap<Integer, T> map = new HashMap<Integer, T>();
        if (list != null && list.func_150303_d() == 10) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                int slot = compound.func_74762_e("Slot");
                NBTTagCompound contentCompound = compound.func_74775_l("Content");
                T newColor = fromNBT.apply(contentCompound);
                if (!keepCondition.check(slot, newColor)) continue;
                map.put(slot, newColor);
            }
        }
        return map;
    }

    public static <T> HashMap<Integer, T> javaIntegerObjectMap(NBTTagList list, Function<NBTTagCompound, T> fromNBT) {
        return NBTHelper.javaIntegerObjectMap(list, fromNBT, (ignore1, ignore2) -> true);
    }

    @FunctionalInterface
    public static interface KeepConditionCallback<Param1, Param2> {
        public boolean check(Param1 var1, Param2 var2);
    }
}

