/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadsignsmod.trafficlight.client;

import de.sarocesch.sarosroadsignsmod.trafficlight.blockentity.NewTrafficLightBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TrafficLightConfigMenu
extends AbstractContainerMenu {
    public final BlockPos pos;
    public final Level world;
    public final Player player;
    private NewTrafficLightBlockEntity blockEntity;
    private static MenuType<TrafficLightConfigMenu> menuType;

    public static void setMenuType(MenuType<TrafficLightConfigMenu> type) {
        menuType = type;
    }

    private static MenuType<TrafficLightConfigMenu> getMenuType() {
        if (menuType == null) {
            throw new IllegalStateException("MenuType not set for TrafficLightConfigMenu");
        }
        return menuType;
    }

    public TrafficLightConfigMenu(int id, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(id, playerInventory, extraData.readBlockPos());
    }

    public TrafficLightConfigMenu(int id, Inventory playerInventory, BlockPos pos) {
        super(TrafficLightConfigMenu.getMenuType(), id);
        this.pos = pos;
        this.player = playerInventory.player;
        this.world = playerInventory.player.level();
        BlockEntity be = this.world.getBlockEntity(pos);
        if (be instanceof NewTrafficLightBlockEntity) {
            this.blockEntity = (NewTrafficLightBlockEntity)be;
        }
    }

    public boolean stillValid(Player player) {
        return this.world.getBlockEntity(this.pos) instanceof NewTrafficLightBlockEntity && player.distanceToSqr((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5) <= 64.0;
    }

    public NewTrafficLightBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }
}

