/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadsignsmod.trafficlight.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.sarocesch.sarosroadsignsmod.block.entity.TrafficLightControlerBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class TrafficLightOutlineRenderer {
    public static void onRenderLevelStage_DISABLED() {
    }

    private static List<BlockPos> getConnectedTrafficLights(BlockEntity controllerBE) {
        ArrayList<BlockPos> lights = new ArrayList<BlockPos>();
        if (!(controllerBE instanceof TrafficLightControlerBlockEntity)) {
            return lights;
        }
        TrafficLightControlerBlockEntity controller = (TrafficLightControlerBlockEntity)controllerBE;
        CompoundTag nbt = controller.getPersistentData();
        for (String key : nbt.getAllKeys()) {
            String value;
            if (!key.startsWith("NewTrafficLight_") || (value = nbt.getString(key)).isEmpty()) continue;
            try {
                String[] coords = value.split(",");
                if (coords.length != 3) continue;
                int x = Integer.parseInt(coords[0]);
                int y = Integer.parseInt(coords[1]);
                int z = Integer.parseInt(coords[2]);
                lights.add(new BlockPos(x, y, z));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return lights;
    }

    private static void renderBlockOutline(PoseStack poseStack, MultiBufferSource bufferSource, BlockPos pos, Vec3 cameraPos, float r, float g, float b, float a) {
        poseStack.pushPose();
        poseStack.translate((double)pos.getX() - cameraPos.x, (double)pos.getY() - cameraPos.y, (double)pos.getZ() - cameraPos.z);
        AABB aabb = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).inflate(0.002);
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.lines());
        Matrix4f matrix = poseStack.last().pose();
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)consumer, (AABB)aabb, (float)r, (float)g, (float)b, (float)a);
        poseStack.popPose();
    }

    private static void renderConnectionLine(PoseStack poseStack, MultiBufferSource bufferSource, BlockPos from, BlockPos to, Vec3 cameraPos, float r, float g, float b, float a) {
        poseStack.pushPose();
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.lines());
        Matrix4f matrix = poseStack.last().pose();
        Vec3 fromCenter = Vec3.atCenterOf((Vec3i)from).subtract(cameraPos);
        Vec3 toCenter = Vec3.atCenterOf((Vec3i)to).subtract(cameraPos);
        float offset = 0.05f;
        TrafficLightOutlineRenderer.drawLine(consumer, matrix, fromCenter, toCenter, r, g, b, a);
        TrafficLightOutlineRenderer.drawLine(consumer, matrix, fromCenter.add((double)offset, 0.0, 0.0), toCenter.add((double)offset, 0.0, 0.0), r, g, b, a * 0.7f);
        TrafficLightOutlineRenderer.drawLine(consumer, matrix, fromCenter.add((double)(-offset), 0.0, 0.0), toCenter.add((double)(-offset), 0.0, 0.0), r, g, b, a * 0.7f);
        TrafficLightOutlineRenderer.drawLine(consumer, matrix, fromCenter.add(0.0, (double)offset, 0.0), toCenter.add(0.0, (double)offset, 0.0), r, g, b, a * 0.7f);
        TrafficLightOutlineRenderer.drawLine(consumer, matrix, fromCenter.add(0.0, (double)(-offset), 0.0), toCenter.add(0.0, (double)(-offset), 0.0), r, g, b, a * 0.7f);
        TrafficLightOutlineRenderer.drawLine(consumer, matrix, fromCenter.add(0.0, 0.0, (double)offset), toCenter.add(0.0, 0.0, (double)offset), r, g, b, a * 0.7f);
        TrafficLightOutlineRenderer.drawLine(consumer, matrix, fromCenter.add(0.0, 0.0, (double)(-offset)), toCenter.add(0.0, 0.0, (double)(-offset)), r, g, b, a * 0.7f);
        poseStack.popPose();
    }

    private static void drawLine(VertexConsumer consumer, Matrix4f matrix, Vec3 from, Vec3 to, float r, float g, float b, float a) {
        consumer.addVertex(matrix, (float)from.x, (float)from.y, (float)from.z).setColor(r, g, b, a).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(matrix, (float)to.x, (float)to.y, (float)to.z).setColor(r, g, b, a).setNormal(0.0f, 1.0f, 0.0f);
    }
}

