/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadsignsmod.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.sarocesch.sarosroadsignsmod.SarosRoadSignsModMod;
import de.sarocesch.sarosroadsignsmod.block.CustomSignBlock;
import de.sarocesch.sarosroadsignsmod.block.CustomSignShapeBlock;
import de.sarocesch.sarosroadsignsmod.block.EckenBlock;
import de.sarocesch.sarosroadsignsmod.block.Schild4EckBlock;
import de.sarocesch.sarosroadsignsmod.block.SchildppBlock;
import de.sarocesch.sarosroadsignsmod.block.SchlidBlankBlock;
import de.sarocesch.sarosroadsignsmod.block.VorFahrtBlock;
import de.sarocesch.sarosroadsignsmod.block.entity.CustomSignBlockEntity;
import de.sarocesch.sarosroadsignsmod.client.render.CustomSignRenderState;
import de.sarocesch.sarosroadsignsmod.client.util.DynamicTextureUtil;
import de.sarocesch.sarosroadsignsmod.init.SarosRoadSignsModModBlocks;
import de.sarocesch.sarosroadsignsmod.packs.PackDefinition;
import de.sarocesch.sarosroadsignsmod.packs.PackManager;
import de.sarocesch.sarosroadsignsmod.packs.SignDefinition;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class CustomSignRenderer
implements BlockEntityRenderer<CustomSignBlockEntity, CustomSignRenderState> {
    private static void dbg(String msg) {
        if (PackManager.isDebugEnabled()) {
            SarosRoadSignsModMod.LOGGER.info("[SRS][Renderer] " + msg);
        }
    }

    public CustomSignRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public CustomSignRenderState createRenderState() {
        CustomSignRenderer.dbg("createRenderState() called");
        return new CustomSignRenderState();
    }

    public boolean shouldRender(CustomSignBlockEntity be, Vec3 cameraPos) {
        boolean result = super.shouldRender((BlockEntity)be, cameraPos);
        CustomSignRenderer.dbg("shouldRender() called, result=" + result);
        return result;
    }

    public void extractRenderState(CustomSignBlockEntity be, CustomSignRenderState state, float partialTick, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        BlockEntityRenderState.extractBase((BlockEntity)be, (BlockEntityRenderState)state, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        state.packId = be.getPackId();
        state.signId = be.getSignId();
        state.facing = (Direction)be.getBlockState().getValue(CustomSignBlock.FACING);
        state.text = be.getText();
        state.textColor = be.getTextColor();
        state.packedLight = LevelRenderer.getLightColor((BlockAndTintGetter)be.getLevel(), (BlockPos)be.getBlockPos());
        CustomSignRenderer.dbg("extractRenderState called: packId=" + state.packId + ", signId=" + state.signId + ", facing=" + String.valueOf(state.facing));
    }

    public void submit(CustomSignRenderState state, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState camera) {
        String rel;
        CustomSignRenderer.dbg("submit() called: packId=" + state.packId + ", signId=" + state.signId);
        CustomSignRenderer.dbg("SubmitNodeCollector type: " + submitNodeCollector.getClass().getName());
        String packId = state.packId;
        String signId = state.signId;
        if (packId == null || signId == null) {
            CustomSignRenderer.dbg("Missing pack/sign in render state");
            return;
        }
        PackDefinition pack = PackManager.getPacks().stream().filter(p -> packId.equals(p.id)).findFirst().orElse(null);
        if (pack == null) {
            CustomSignRenderer.dbg("Pack not found: " + packId);
            return;
        }
        SignDefinition sign = pack.signs.stream().filter(s -> signId.equals(s.id)).findFirst().orElse(null);
        if (sign == null) {
            CustomSignRenderer.dbg("Sign not found: " + signId);
            return;
        }
        File base = pack.folder != null ? pack.folder : new File(PackManager.getPacksRoot(), packId);
        File tex = new File(base, rel = sign.texture.replace('\\', '/'));
        if (!(tex.exists() && tex.isFile() && tex.canRead())) {
            SarosRoadSignsModMod.LOGGER.warn("[SRS][Renderer] Texture not available: {} (exists={}, isFile={}, canRead={})", (Object)tex.getAbsolutePath(), (Object)tex.exists(), (Object)tex.isFile(), (Object)tex.canRead());
            return;
        }
        ResourceLocation rl = DynamicTextureUtil.getTexture(tex);
        poseStack.pushPose();
        Direction facing = state.facing;
        BlockState modelState = switch (sign.shape) {
            case SignDefinition.Shape.ROUND -> SchlidBlankBlock.FACING != null ? (BlockState)((Block)SarosRoadSignsModModBlocks.SCHLID_BLANK.get()).defaultBlockState().setValue(SchlidBlankBlock.FACING, (Comparable)facing) : ((Block)SarosRoadSignsModModBlocks.SCHLID_BLANK.get()).defaultBlockState();
            case SignDefinition.Shape.TRIANGLE -> EckenBlock.FACING != null ? (BlockState)((Block)SarosRoadSignsModModBlocks.ECKEN.get()).defaultBlockState().setValue(EckenBlock.FACING, (Comparable)facing) : ((Block)SarosRoadSignsModModBlocks.ECKEN.get()).defaultBlockState();
            case SignDefinition.Shape.RECTANGLE -> Schild4EckBlock.FACING != null ? (BlockState)((Block)SarosRoadSignsModModBlocks.SCHILD_4_ECK.get()).defaultBlockState().setValue(Schild4EckBlock.FACING, (Comparable)facing) : ((Block)SarosRoadSignsModModBlocks.SCHILD_4_ECK.get()).defaultBlockState();
            case SignDefinition.Shape.CUSTOM -> CustomSignShapeBlock.FACING != null ? (BlockState)((Block)SarosRoadSignsModModBlocks.CUSTOM_SIGN_SHAPE.get()).defaultBlockState().setValue(CustomSignShapeBlock.FACING, (Comparable)facing) : ((Block)SarosRoadSignsModModBlocks.CUSTOM_SIGN_SHAPE.get()).defaultBlockState();
            case SignDefinition.Shape.DIAMOND -> VorFahrtBlock.FACING != null ? (BlockState)((Block)SarosRoadSignsModModBlocks.VOR_FAHRT.get()).defaultBlockState().setValue(VorFahrtBlock.FACING, (Comparable)facing) : ((Block)SarosRoadSignsModModBlocks.VOR_FAHRT.get()).defaultBlockState();
            default -> SchildppBlock.FACING != null ? (BlockState)((Block)SarosRoadSignsModModBlocks.SCHILDPP.get()).defaultBlockState().setValue(SchildppBlock.FACING, (Comparable)facing) : ((Block)SarosRoadSignsModModBlocks.SCHILDPP.get()).defaultBlockState();
        };
        CustomSignRenderer.dbg("Calling submitBlock with modelState: " + String.valueOf(modelState));
        submitNodeCollector.submitBlock(poseStack, modelState, state.packedLight, OverlayTexture.NO_OVERLAY, 0);
        CustomSignRenderer.dbg("submitBlock completed");
        poseStack.popPose();
        poseStack.pushPose();
        float yRot = state.facing.toYRot();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-yRot));
        float dz = 0.0624f;
        float dy = 0.0f;
        switch (sign.shape) {
            case ROUND: {
                dz = 0.074f;
                dy = 0.0f;
                break;
            }
            case TRIANGLE: {
                dz = 0.074f;
                dy = 0.1f;
                break;
            }
            case DIAMOND: {
                dz = 0.068f;
                dy = 0.0f;
                break;
            }
            case OTHER: {
                dz = 0.069f;
                dy = 0.0f;
                break;
            }
            case CUSTOM: {
                dz = 0.072399996f;
                dy = 0.0f;
                break;
            }
            default: {
                dz = 0.072399996f;
                dy = 0.0f;
            }
        }
        poseStack.translate(0.0, (double)dy, (double)dz);
        float w = 1.0f;
        float h = 1.0f;
        switch (sign.shape) {
            case ROUND: {
                w = 1.0f;
                h = 1.0f;
                break;
            }
            case TRIANGLE: {
                w = 1.0f;
                h = 1.25f;
                break;
            }
            case DIAMOND: {
                h = 0.96f;
                w = 0.96f;
                break;
            }
            case OTHER: {
                h = 1.0f;
                w = 1.0f;
                break;
            }
            case CUSTOM: {
                w = 1.0f;
                h = 1.0f;
                break;
            }
        }
        float hx = w * 0.5f;
        float hy = h * 0.5f;
        ResourceLocation finalRl = rl;
        int finalPackedLight = state.packedLight;
        CustomSignRenderer.dbg("Calling submitCustomGeometry with texture: " + String.valueOf(finalRl) + ", size: " + w + "x" + h);
        submitNodeCollector.submitCustomGeometry(poseStack, RenderType.entityCutout((ResourceLocation)finalRl), (pose, vertexConsumer) -> {
            Matrix4f mat = pose.pose();
            CustomSignRenderer.dbg("CustomGeometry lambda called, vertexConsumer type: " + vertexConsumer.getClass().getName());
            vertexConsumer.addVertex(mat, -hx, -hy, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(finalPackedLight).setNormal(0.0f, 0.0f, 1.0f);
            vertexConsumer.addVertex(mat, hx, -hy, 0.0f).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(finalPackedLight).setNormal(0.0f, 0.0f, 1.0f);
            vertexConsumer.addVertex(mat, hx, hy, 0.0f).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(finalPackedLight).setNormal(0.0f, 0.0f, 1.0f);
            vertexConsumer.addVertex(mat, -hx, hy, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(finalPackedLight).setNormal(0.0f, 0.0f, 1.0f);
            CustomSignRenderer.dbg("CustomGeometry: Added 4 vertices");
        });
        CustomSignRenderer.dbg("submitCustomGeometry completed");
        if (sign.text_enabled || Boolean.TRUE.equals(pack.text_enabled)) {
            String text = state.text;
            CustomSignRenderer.dbg("Text enabled, text: " + text);
            if (text != null && !text.isEmpty()) {
                String vAlign;
                int maxLines;
                poseStack.pushPose();
                poseStack.translate(0.0f, 0.0f, 0.01f);
                float baseScale = switch (sign.shape) {
                    case SignDefinition.Shape.RECTANGLE -> 0.0085f;
                    case SignDefinition.Shape.TRIANGLE -> 0.0075f;
                    case SignDefinition.Shape.DIAMOND -> 0.0075f;
                    default -> 0.008f;
                };
                float sizeFactor = sign.text_size <= 0.0f ? 1.0f : sign.text_size;
                float scale = baseScale * sizeFactor;
                poseStack.scale(scale, -scale, scale);
                int maxPxWidth = (int)(hx * 2.0f / scale) - 4;
                Font font = Minecraft.getInstance().font;
                List<String> lines = new ArrayList<String>();
                for (String word : text.split(" ")) {
                    String current;
                    String candidate;
                    if (lines.isEmpty()) {
                        lines.add("");
                    }
                    String string = candidate = (current = (String)lines.get(lines.size() - 1)).isEmpty() ? word : current + " " + word;
                    if (font.width(candidate) <= maxPxWidth) {
                        lines.set(lines.size() - 1, candidate);
                        continue;
                    }
                    lines.add(word);
                }
                switch (sign.shape) {
                    case RECTANGLE: {
                        int n = 3;
                        break;
                    }
                    case TRIANGLE: {
                        int n = 2;
                        break;
                    }
                    default: {
                        int n = maxLines = 2;
                    }
                }
                if (lines.size() > maxLines) {
                    lines = lines.subList(0, maxLines);
                }
                int lineHeight = 10;
                int blockHeight = lines.size() * lineHeight;
                int baseWidthPx = (int)(hx * 2.0f / scale);
                int yStart = switch (vAlign = sign.text_v_align == null ? "CENTER" : sign.text_v_align.toUpperCase()) {
                    case "TOP" -> -baseWidthPx / 2 + 2;
                    case "BOTTOM" -> baseWidthPx / 2 - blockHeight - 2;
                    default -> -blockHeight / 2;
                };
                yStart += (int)(-sign.text_offset_y / scale);
                MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
                for (int i = 0; i < lines.size(); ++i) {
                    String hAlign;
                    String ln = (String)lines.get(i);
                    int wpx = font.width(ln);
                    float xStart = switch (hAlign = sign.text_h_align == null ? "CENTER" : sign.text_h_align.toUpperCase()) {
                        case "LEFT" -> (float)(-baseWidthPx) / 2.0f + 2.0f;
                        case "RIGHT" -> (float)baseWidthPx / 2.0f - (float)wpx - 2.0f;
                        default -> (float)(-wpx) / 2.0f;
                    };
                    int col = state.textColor;
                    CustomSignRenderer.dbg("Rendering text line " + i + ": '" + ln + "' at (" + (xStart += -sign.text_offset_x / scale) + ", " + (yStart + i * lineHeight) + "), color=" + Integer.toHexString(col));
                    font.drawInBatch(ln, xStart, (float)(yStart + i * lineHeight), col, false, poseStack.last().pose(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, state.packedLight);
                    CustomSignRenderer.dbg("Text rendering completed for line " + i);
                }
                bufferSource.endBatch();
                CustomSignRenderer.dbg("Buffer flushed");
                poseStack.popPose();
            }
        }
        poseStack.popPose();
    }

    public boolean shouldRenderOffScreen() {
        CustomSignRenderer.dbg("shouldRenderOffScreen() called, returning true");
        return true;
    }

    public int getViewDistance() {
        int result = super.getViewDistance();
        CustomSignRenderer.dbg("getViewDistance() called, result=" + result);
        return result;
    }
}

