/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadsignsmod.trafficlight.network;

import de.sarocesch.sarosroadsignsmod.trafficlight.blockentity.NewTrafficLightBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class TrafficLightConfigMessage {
    private final BlockPos pos;
    private final int redMax;
    private final int yellowMin;
    private final int yellowMax;
    private final int greenMin;
    private final int blinkMin;
    private final int blinkMax;
    private final int blinkRate;

    public TrafficLightConfigMessage(BlockPos pos, int redMax, int yellowMin, int yellowMax, int greenMin, int blinkMin, int blinkMax, int blinkRate) {
        this.pos = pos;
        this.redMax = redMax;
        this.yellowMin = yellowMin;
        this.yellowMax = yellowMax;
        this.greenMin = greenMin;
        this.blinkMin = blinkMin;
        this.blinkMax = blinkMax;
        this.blinkRate = blinkRate;
    }

    public static void encode(TrafficLightConfigMessage msg, FriendlyByteBuf buf) {
        buf.writeBlockPos(msg.pos);
        buf.writeInt(msg.redMax);
        buf.writeInt(msg.yellowMin);
        buf.writeInt(msg.yellowMax);
        buf.writeInt(msg.greenMin);
        buf.writeInt(msg.blinkMin);
        buf.writeInt(msg.blinkMax);
        buf.writeInt(msg.blinkRate);
    }

    public static TrafficLightConfigMessage decode(FriendlyByteBuf buf) {
        return new TrafficLightConfigMessage(buf.readBlockPos(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void handle(TrafficLightConfigMessage msg, CustomPayloadEvent.Context ctx) {
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        ServerLevel world = player.level();
        if (!world.hasChunkAt(msg.pos)) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(msg.pos);
        if (blockEntity instanceof NewTrafficLightBlockEntity) {
            NewTrafficLightBlockEntity trafficLightBE = (NewTrafficLightBlockEntity)blockEntity;
            if (msg.redMax < 0 || msg.redMax > 15 || msg.yellowMin < 0 || msg.yellowMin > 15 || msg.yellowMax < 0 || msg.yellowMax > 15 || msg.greenMin < 0 || msg.greenMin > 15 || msg.blinkMin < -1 || msg.blinkMin > 15 || msg.blinkMax < -1 || msg.blinkMax > 15 || msg.blinkRate < 1) {
                return;
            }
            trafficLightBE.setRedMax(msg.redMax);
            trafficLightBE.setYellowMin(msg.yellowMin);
            trafficLightBE.setYellowMax(msg.yellowMax);
            trafficLightBE.setGreenMin(msg.greenMin);
            trafficLightBE.setBlinkMin(msg.blinkMin);
            trafficLightBE.setBlinkMax(msg.blinkMax);
            trafficLightBE.setBlinkRate(msg.blinkRate);
            trafficLightBE.updateStateFromRedstone();
        }
    }
}

