/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadsignsmod.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.sarocesch.sarosroadsignsmod.SarosRoadSignsModMod;
import de.sarocesch.sarosroadsignsmod.block.CustomSignBlock;
import de.sarocesch.sarosroadsignsmod.block.CustomSignShapeBlock;
import de.sarocesch.sarosroadsignsmod.block.EckenBlock;
import de.sarocesch.sarosroadsignsmod.block.Schild4EckBlock;
import de.sarocesch.sarosroadsignsmod.block.SchildppBlock;
import de.sarocesch.sarosroadsignsmod.block.SchlidBlankBlock;
import de.sarocesch.sarosroadsignsmod.block.VorFahrtBlock;
import de.sarocesch.sarosroadsignsmod.block.entity.CustomSignBlockEntity;
import de.sarocesch.sarosroadsignsmod.client.util.DynamicTextureUtil;
import de.sarocesch.sarosroadsignsmod.init.SarosRoadSignsModModBlocks;
import de.sarocesch.sarosroadsignsmod.packs.PackDefinition;
import de.sarocesch.sarosroadsignsmod.packs.PackManager;
import de.sarocesch.sarosroadsignsmod.packs.SignDefinition;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class CustomSignRenderer
implements BlockEntityRenderer<CustomSignBlockEntity> {
    private static void dbg(String msg) {
        if (PackManager.isDebugEnabled()) {
            SarosRoadSignsModMod.LOGGER.info("[SRS][Renderer] " + msg);
        }
    }

    public CustomSignRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(CustomSignBlockEntity be, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        String rel;
        if (be == null) {
            return;
        }
        String packId = be.getPackId();
        String signId = be.getSignId();
        if (packId == null || signId == null) {
            CustomSignRenderer.dbg("Missing pack/sign on BE");
            return;
        }
        PackDefinition pack = PackManager.getPacks().stream().filter(p -> packId.equals(p.id)).findFirst().orElse(null);
        if (pack == null) {
            CustomSignRenderer.dbg("Pack not found: " + packId);
            return;
        }
        SignDefinition sign = pack.signs.stream().filter(s -> signId.equals(s.id)).findFirst().orElse(null);
        if (sign == null) {
            CustomSignRenderer.dbg("Sign not found: " + signId);
            return;
        }
        File base = pack.folder != null ? pack.folder : new File(PackManager.getPacksRoot(), packId);
        File tex = new File(base, rel = sign.texture.replace('\\', '/'));
        if (!(tex.exists() && tex.isFile() && tex.canRead())) {
            SarosRoadSignsModMod.LOGGER.warn("[SRS][Renderer] Texture not available: {} (exists={}, isFile={}, canRead={})", (Object)tex.getAbsolutePath(), (Object)tex.exists(), (Object)tex.isFile(), (Object)tex.canRead());
            return;
        }
        ResourceLocation rl = DynamicTextureUtil.getTexture(tex);
        if (rl == null) {
            CustomSignRenderer.dbg("Unable to obtain ResourceLocation for texture: " + tex.getAbsolutePath());
            return;
        }
        poseStack.m_85836_();
        try {
            Direction facing = (Direction)be.m_58900_().m_61143_((Property)CustomSignBlock.FACING);
            BlockState modelState = switch (sign.shape) {
                case SignDefinition.Shape.ROUND -> SchlidBlankBlock.FACING != null ? (BlockState)((Block)SarosRoadSignsModModBlocks.SCHLID_BLANK.get()).m_49966_().m_61124_((Property)SchlidBlankBlock.FACING, (Comparable)facing) : ((Block)SarosRoadSignsModModBlocks.SCHLID_BLANK.get()).m_49966_();
                case SignDefinition.Shape.TRIANGLE -> EckenBlock.FACING != null ? (BlockState)((Block)SarosRoadSignsModModBlocks.ECKEN.get()).m_49966_().m_61124_((Property)EckenBlock.FACING, (Comparable)facing) : ((Block)SarosRoadSignsModModBlocks.ECKEN.get()).m_49966_();
                case SignDefinition.Shape.RECTANGLE -> Schild4EckBlock.FACING != null ? (BlockState)((Block)SarosRoadSignsModModBlocks.SCHILD_4_ECK.get()).m_49966_().m_61124_((Property)Schild4EckBlock.FACING, (Comparable)facing) : ((Block)SarosRoadSignsModModBlocks.SCHILD_4_ECK.get()).m_49966_();
                case SignDefinition.Shape.CUSTOM -> CustomSignShapeBlock.FACING != null ? (BlockState)((Block)SarosRoadSignsModModBlocks.CUSTOM_SIGN_SHAPE.get()).m_49966_().m_61124_((Property)CustomSignShapeBlock.FACING, (Comparable)facing) : ((Block)SarosRoadSignsModModBlocks.CUSTOM_SIGN_SHAPE.get()).m_49966_();
                case SignDefinition.Shape.DIAMOND -> VorFahrtBlock.FACING != null ? (BlockState)((Block)SarosRoadSignsModModBlocks.VOR_FAHRT.get()).m_49966_().m_61124_((Property)VorFahrtBlock.FACING, (Comparable)facing) : ((Block)SarosRoadSignsModModBlocks.VOR_FAHRT.get()).m_49966_();
                default -> SchildppBlock.FACING != null ? (BlockState)((Block)SarosRoadSignsModModBlocks.SCHILDPP.get()).m_49966_().m_61124_((Property)SchildppBlock.FACING, (Comparable)facing) : ((Block)SarosRoadSignsModModBlocks.SCHILDPP.get()).m_49966_();
            };
            BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
            poseStack.m_85836_();
            dispatcher.m_110912_(modelState, poseStack, bufferSource, packedLight, packedOverlay);
            poseStack.m_85849_();
        }
        catch (Throwable t) {
            SarosRoadSignsModMod.LOGGER.warn("[SRS][Renderer] Exception while rendering base model", t);
        }
        finally {
            poseStack.m_85849_();
        }
        try {
            if (bufferSource instanceof MultiBufferSource.BufferSource) {
                ((MultiBufferSource.BufferSource)bufferSource).m_109911_();
            }
        }
        catch (Throwable t) {
            CustomSignRenderer.dbg("Failed to endBatch(): " + t.getMessage());
        }
        poseStack.m_85836_();
        try {
            String text;
            float yRot = ((Direction)be.m_58900_().m_61143_((Property)CustomSignBlock.FACING)).m_122435_();
            poseStack.m_85837_(0.5, 0.5, 0.5);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-yRot));
            float dz = 0.0725f;
            float dy = 0.0f;
            switch (sign.shape) {
                case ROUND: {
                    dz = 0.084f;
                    dy = 0.0f;
                    break;
                }
                case TRIANGLE: {
                    dz = 0.084f;
                    dy = 0.1f;
                    break;
                }
                case DIAMOND: {
                    dz = 0.078f;
                    dy = 0.0f;
                    break;
                }
                case OTHER: {
                    dz = 0.078999996f;
                    dy = 0.0f;
                    break;
                }
                case CUSTOM: {
                    dz = 0.082499996f;
                    dy = 0.0f;
                    break;
                }
                default: {
                    dz = 0.082499996f;
                    dy = 0.0f;
                }
            }
            poseStack.m_85837_(0.0, (double)dy, (double)dz);
            float w = 1.0f;
            float h = 1.0f;
            switch (sign.shape) {
                case ROUND: {
                    w = 1.0f;
                    h = 1.0f;
                    break;
                }
                case TRIANGLE: {
                    w = 1.0f;
                    h = 1.25f;
                    break;
                }
                case DIAMOND: {
                    h = 0.96f;
                    w = 0.96f;
                    break;
                }
                case OTHER: {
                    h = 1.0f;
                    w = 1.0f;
                    break;
                }
                case CUSTOM: {
                    w = 1.0f;
                    h = 1.0f;
                    break;
                }
            }
            float hx = w * 0.5f;
            float hy = h * 0.5f;
            VertexConsumer vFront = bufferSource.m_6299_(RenderType.m_110470_((ResourceLocation)rl));
            Matrix4f mat = poseStack.m_85850_().m_252922_();
            Matrix3f nrm = poseStack.m_85850_().m_252943_();
            vFront.m_252986_(mat, -hx, -hy, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(nrm, 0.0f, 0.0f, 1.0f).m_5752_();
            vFront.m_252986_(mat, hx, -hy, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(nrm, 0.0f, 0.0f, 1.0f).m_5752_();
            vFront.m_252986_(mat, hx, hy, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(nrm, 0.0f, 0.0f, 1.0f).m_5752_();
            vFront.m_252986_(mat, -hx, hy, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(nrm, 0.0f, 0.0f, 1.0f).m_5752_();
            if ((sign.text_enabled || Boolean.TRUE.equals(pack.text_enabled)) && (text = be.getText()) != null && !text.isEmpty()) {
                String vAlign;
                int maxLines;
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.0, (double)5.0E-4f);
                float baseScale = switch (sign.shape) {
                    case SignDefinition.Shape.RECTANGLE -> 0.0085f;
                    case SignDefinition.Shape.TRIANGLE -> 0.0075f;
                    case SignDefinition.Shape.DIAMOND -> 0.0075f;
                    default -> 0.008f;
                };
                float sizeFactor = sign.text_size <= 0.0f ? 1.0f : sign.text_size;
                float scale = baseScale * sizeFactor;
                poseStack.m_85841_(scale, -scale, scale);
                int maxPxWidth = Math.max(1, (int)(hx * 2.0f / scale) - 4);
                Font font = Minecraft.m_91087_().f_91062_;
                List<String> lines = new ArrayList<String>();
                for (String word : text.split(" ")) {
                    String current;
                    String candidate;
                    if (lines.isEmpty()) {
                        lines.add("");
                    }
                    String string = candidate = (current = (String)lines.get(lines.size() - 1)).isEmpty() ? word : current + " " + word;
                    if (font.m_92895_(candidate) <= maxPxWidth) {
                        lines.set(lines.size() - 1, candidate);
                        continue;
                    }
                    lines.add(word);
                }
                switch (sign.shape) {
                    case RECTANGLE: {
                        int n = 3;
                        break;
                    }
                    case TRIANGLE: {
                        int n = 2;
                        break;
                    }
                    default: {
                        int n = maxLines = 2;
                    }
                }
                if (lines.size() > maxLines) {
                    lines = lines.subList(0, maxLines);
                }
                int lineHeight = 10;
                int blockHeight = lines.size() * lineHeight;
                int baseWidthPx = (int)(hx * 2.0f / scale);
                int yStart = switch (vAlign = sign.text_v_align == null ? "CENTER" : sign.text_v_align.toUpperCase()) {
                    case "TOP" -> -baseWidthPx / 2 + 2;
                    case "BOTTOM" -> baseWidthPx / 2 - blockHeight - 2;
                    default -> -blockHeight / 2;
                };
                yStart += (int)(-sign.text_offset_y / scale);
                for (int i = 0; i < lines.size(); ++i) {
                    String hAlign;
                    String ln = (String)lines.get(i);
                    int wpx = font.m_92895_(ln);
                    float xStart = switch (hAlign = sign.text_h_align == null ? "CENTER" : sign.text_h_align.toUpperCase()) {
                        case "LEFT" -> (float)(-baseWidthPx) / 2.0f + 2.0f;
                        case "RIGHT" -> (float)baseWidthPx / 2.0f - (float)wpx - 2.0f;
                        default -> (float)(-wpx) / 2.0f;
                    };
                    int col = be.getTextColor();
                    font.m_271703_(ln, xStart += -sign.text_offset_x / scale, (float)(yStart + i * lineHeight), col, false, poseStack.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
                }
                poseStack.m_85849_();
            }
        }
        catch (Throwable t) {
            SarosRoadSignsModMod.LOGGER.warn("[SRS][Renderer] Exception while rendering overlay/text", t);
        }
        finally {
            poseStack.m_85849_();
        }
    }

    public boolean shouldRenderOffScreen(CustomSignBlockEntity be) {
        return true;
    }
}

