/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadsignsmod.packs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import de.sarocesch.sarosroadsignsmod.SarosRoadSignsModMod;
import de.sarocesch.sarosroadsignsmod.packs.PackDefinition;
import de.sarocesch.sarosroadsignsmod.packs.SignDefinition;
import de.sarocesch.sarosroadsignsmod.util.ConfigUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.fml.loading.FMLPaths;

public class PackManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final List<PackDefinition> PACKS = new ArrayList<PackDefinition>();
    private static final List<PackDefinition> SERVER_AUTHORIZED = new ArrayList<PackDefinition>();

    public static boolean isDebugEnabled() {
        return ConfigUtil.isDebugEnabled();
    }

    public static File getPacksRoot() {
        return new File(FMLPaths.GAMEDIR.get().toFile(), "saros_road_signs_mod/packs");
    }

    public static void ensureExamplePack() {
        if (!ConfigUtil.shouldGenerateExamplePack()) {
            return;
        }
        File root = PackManager.getPacksRoot();
        File example = new File(root, "example_pack");
        File manifest = new File(example, "pack.json");
        if (manifest.exists()) {
            return;
        }
        try {
            example.mkdirs();
            PackManager.copyTemplate("/pack_templates/example_pack", example);
        }
        catch (IOException e) {
            File manifest2 = new File(example, "pack.json");
            if (!manifest2.exists()) {
                PackDefinition def = new PackDefinition();
                def.id = "example";
                def.name = "Example Pack";
                def.version = "1.0.0";
                def.author = "";
                try (FileWriter fw = new FileWriter(manifest2);){
                    GSON.toJson((Object)def, (Appendable)fw);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            SarosRoadSignsModMod.LOGGER.warn("Failed to create example pack: {}", (Object)e.toString());
        }
    }

    public static void scan() {
        PACKS.clear();
        File root = PackManager.getPacksRoot();
        if (!root.exists() && !root.mkdirs()) {
            SarosRoadSignsModMod.LOGGER.warn("Could not create packs directory at {}", (Object)root.getAbsolutePath());
            return;
        }
        File[] dirs = root.listFiles(File::isDirectory);
        if (dirs == null) {
            return;
        }
        for (File dir : dirs) {
            File manifest = new File(dir, "pack.json");
            if (!manifest.isFile()) continue;
            try (FileReader fr = new FileReader(manifest);){
                PackDefinition def = (PackDefinition)GSON.fromJson((Reader)fr, PackDefinition.class);
                if (def == null || def.id == null) continue;
                def.folder = dir;
                PACKS.add(def);
                if (!PackManager.isDebugEnabled()) continue;
                SarosRoadSignsModMod.LOGGER.info("[SRS] Loaded pack {} with {} signs from {}", (Object)def.id, (Object)(def.signs == null ? 0 : def.signs.size()), (Object)dir.getAbsolutePath());
            }
            catch (JsonParseException | IOException e) {
                if (!PackManager.isDebugEnabled()) continue;
                SarosRoadSignsModMod.LOGGER.warn("[SRS] Failed to parse pack {}: {}", (Object)dir.getName(), (Object)e.toString());
            }
        }
    }

    public static List<PackDefinition> getPacks() {
        return Collections.unmodifiableList(PACKS);
    }

    public static void updateServerAuthorizedPacks(List<PackDefinition> packs) {
        SERVER_AUTHORIZED.clear();
        SERVER_AUTHORIZED.addAll(packs);
    }

    private static void copyTemplate(String resourcePath, File targetDir) throws IOException {
        PackDefinition def;
        block49: {
            String json;
            InputStream jsonIn = PackManager.class.getResourceAsStream(resourcePath + "/pack.json");
            if (jsonIn == null) {
                throw new FileNotFoundException("Resource not found: " + resourcePath + "/pack.json");
            }
            try (InputStream in = jsonIn;){
                json = new String(in.readAllBytes(), StandardCharsets.UTF_8);
            }
            targetDir.mkdirs();
            try (FileOutputStream out = new FileOutputStream(new File(targetDir, "pack.json"));){
                out.write(json.getBytes(StandardCharsets.UTF_8));
            }
            def = null;
            try {
                def = (PackDefinition)GSON.fromJson(json, PackDefinition.class);
            }
            catch (Exception e) {
                if (!PackManager.isDebugEnabled()) break block49;
                SarosRoadSignsModMod.LOGGER.warn("[SRS] Failed to parse template pack.json: {}", (Object)e.toString());
            }
        }
        if (def != null && def.signs != null) {
            for (SignDefinition sign : def.signs) {
                if (sign == null || sign.texture == null || sign.texture.isEmpty()) continue;
                String relPath = sign.texture.startsWith("/") ? sign.texture.substring(1) : sign.texture;
                File outFile = new File(targetDir, relPath);
                File parent = outFile.getParentFile();
                if (parent != null) {
                    parent.mkdirs();
                }
                InputStream texIn = PackManager.class.getResourceAsStream(resourcePath + "/" + relPath);
                try {
                    String fileName;
                    if (texIn != null) {
                        FileOutputStream out = new FileOutputStream(outFile);
                        try {
                            texIn.transferTo(out);
                            continue;
                        }
                        finally {
                            out.close();
                            continue;
                        }
                    }
                    String fallback = switch (fileName = new File(relPath).getName()) {
                        case "danger.png", "diamond_sample.png" -> "/assets/saros_road_signs_mod/textures/block/triangle0.png";
                        default -> "/assets/saros_road_signs_mod/textures/block/circle0.png";
                    };
                    try (InputStream fbIn = PackManager.class.getResourceAsStream(fallback);){
                        if (fbIn != null) {
                            FileOutputStream out = new FileOutputStream(outFile);
                            try {
                                fbIn.transferTo(out);
                                continue;
                            }
                            finally {
                                out.close();
                                continue;
                            }
                        }
                        if (!PackManager.isDebugEnabled()) continue;
                        SarosRoadSignsModMod.LOGGER.warn("[SRS] Missing template texture and no fallback found for {}", (Object)relPath);
                    }
                }
                finally {
                    if (texIn == null) continue;
                    texIn.close();
                }
            }
        }
    }

    public static List<PackDefinition> getServerAuthorizedPacksOrLocalIfNone() {
        if (!SERVER_AUTHORIZED.isEmpty()) {
            return Collections.unmodifiableList(SERVER_AUTHORIZED);
        }
        return PackManager.getPacks();
    }

    public static void reload() {
        PACKS.clear();
        PackManager.scan();
    }
}

