/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadsignsmod.block;

import de.sarocesch.sarosroadsignsmod.init.SarosRoadSignsModModBlocks;
import de.sarocesch.sarosroadsignsmod.procedures.Open4EckProcedure;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SchildRechtspBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final Property<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public SchildRechtspBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(1.0f, 10.0f).noOcclusion().randomTicks().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            case Direction.NORTH -> Shapes.or((VoxelShape)SchildRechtspBlock.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.175, (double)9.0), (VoxelShape[])new VoxelShape[]{SchildRechtspBlock.box((double)6.0, (double)7.0, (double)7.0, (double)10.0, (double)10.0, (double)8.0), SchildRechtspBlock.box((double)2.0, (double)0.0, (double)6.85, (double)14.0, (double)16.0, (double)7.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)SchildRechtspBlock.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.175, (double)9.0), (VoxelShape[])new VoxelShape[]{SchildRechtspBlock.box((double)8.0, (double)7.0, (double)6.0, (double)9.0, (double)10.0, (double)10.0), SchildRechtspBlock.box((double)9.0, (double)0.0, (double)2.0, (double)9.15, (double)16.0, (double)14.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)SchildRechtspBlock.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.175, (double)9.0), (VoxelShape[])new VoxelShape[]{SchildRechtspBlock.box((double)7.0, (double)7.0, (double)6.0, (double)8.0, (double)10.0, (double)10.0), SchildRechtspBlock.box((double)6.85, (double)0.0, (double)2.0, (double)7.0, (double)16.0, (double)14.0)});
            default -> Shapes.or((VoxelShape)SchildRechtspBlock.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.175, (double)9.0), (VoxelShape[])new VoxelShape[]{SchildRechtspBlock.box((double)6.0, (double)7.0, (double)8.0, (double)10.0, (double)10.0, (double)9.0), SchildRechtspBlock.box((double)2.0, (double)0.0, (double)9.0, (double)14.0, (double)16.0, (double)9.15)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List dropsOriginal = super.getDrops(state, builder);
        if (!dropsOriginal.isEmpty()) {
            return dropsOriginal;
        }
        return Collections.singletonList(new ItemStack((ItemLike)SarosRoadSignsModModBlocks.SCHLID_BLANK.get()));
    }

    protected InteractionResult useWithoutItem(BlockState blockstate, Level world, BlockPos pos, Player entity, BlockHitResult hit) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        double hitX = hit.getLocation().x;
        double hitY = hit.getLocation().y;
        double hitZ = hit.getLocation().z;
        Direction direction = hit.getDirection();
        Open4EckProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        return InteractionResult.SUCCESS;
    }
}

