/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadsignsmod.network;

import de.sarocesch.sarosroadsignsmod.block.entity.CustomSignBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class UpdateSignTextMessage {
    public final BlockPos pos;
    public final String text;
    public final int color;

    public UpdateSignTextMessage(BlockPos pos, String text, int color) {
        this.pos = pos;
        this.text = text == null ? "" : text;
        this.color = color;
    }

    public static void encode(UpdateSignTextMessage m, FriendlyByteBuf buf) {
        buf.writeBlockPos(m.pos);
        buf.writeUtf(m.text);
        buf.writeInt(m.color);
    }

    public static UpdateSignTextMessage decode(FriendlyByteBuf buf) {
        BlockPos p = buf.readBlockPos();
        String t = buf.readUtf();
        int c = buf.readInt();
        return new UpdateSignTextMessage(p, t, c);
    }

    public static void handle(UpdateSignTextMessage msg, CustomPayloadEvent.Context ctx) {
        ServerPlayer sp = ctx.getSender();
        if (sp == null) {
            return;
        }
        BlockEntity blockEntity = sp.level().getBlockEntity(msg.pos);
        if (blockEntity instanceof CustomSignBlockEntity) {
            CustomSignBlockEntity be = (CustomSignBlockEntity)blockEntity;
            be.setTextAndColor(msg.text, msg.color);
        }
    }
}

