/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadsignsmod.trafficlight.client;

import com.mojang.blaze3d.systems.RenderSystem;
import de.sarocesch.sarosroadsignsmod.SarosRoadSignsModMod;
import de.sarocesch.sarosroadsignsmod.client.gui.components.ModernButton;
import de.sarocesch.sarosroadsignsmod.trafficlight.blockentity.NewTrafficLightBlockEntity;
import de.sarocesch.sarosroadsignsmod.trafficlight.client.TrafficLightConfigMenu;
import de.sarocesch.sarosroadsignsmod.trafficlight.network.TrafficLightConfigMessage;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.PacketDistributor;

public class TrafficLightConfigScreen
extends AbstractContainerScreen<TrafficLightConfigMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "textures/gui/container/generic_54.png");
    private EditBox redMaxField;
    private EditBox yellowMinField;
    private EditBox yellowMaxField;
    private EditBox greenMinField;
    private EditBox blinkMinField;
    private EditBox blinkMaxField;
    private EditBox blinkRateField;
    private Button saveButton;
    private Button cancelButton;

    public TrafficLightConfigScreen(TrafficLightConfigMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 245;
    }

    protected void init() {
        super.init();
        int centerX = (this.width - this.imageWidth) / 2;
        int centerY = (this.height - this.imageHeight) / 2;
        NewTrafficLightBlockEntity be = ((TrafficLightConfigMenu)this.menu).getBlockEntity();
        if (be == null) {
            return;
        }
        int yOffset = centerY + 20;
        this.redMaxField = new EditBox(this.font, centerX + 100, yOffset, 50, 20, (Component)Component.literal((String)"Red Max"));
        this.redMaxField.setValue(String.valueOf(be.getRedMax()));
        this.redMaxField.setMaxLength(2);
        this.addRenderableWidget((GuiEventListener)this.redMaxField);
        this.yellowMinField = new EditBox(this.font, centerX + 100, yOffset += 25, 50, 20, (Component)Component.literal((String)"Yellow Min"));
        this.yellowMinField.setValue(String.valueOf(be.getYellowMin()));
        this.yellowMinField.setMaxLength(2);
        this.addRenderableWidget((GuiEventListener)this.yellowMinField);
        this.yellowMaxField = new EditBox(this.font, centerX + 100, yOffset += 25, 50, 20, (Component)Component.literal((String)"Yellow Max"));
        this.yellowMaxField.setValue(String.valueOf(be.getYellowMax()));
        this.yellowMaxField.setMaxLength(2);
        this.addRenderableWidget((GuiEventListener)this.yellowMaxField);
        this.greenMinField = new EditBox(this.font, centerX + 100, yOffset += 25, 50, 20, (Component)Component.literal((String)"Green Min"));
        this.greenMinField.setValue(String.valueOf(be.getGreenMin()));
        this.greenMinField.setMaxLength(2);
        this.addRenderableWidget((GuiEventListener)this.greenMinField);
        this.blinkMinField = new EditBox(this.font, centerX + 100, yOffset += 25, 50, 20, (Component)Component.literal((String)"Blink Min"));
        this.blinkMinField.setValue(String.valueOf(be.getBlinkMin()));
        this.blinkMinField.setMaxLength(2);
        this.addRenderableWidget((GuiEventListener)this.blinkMinField);
        this.blinkMaxField = new EditBox(this.font, centerX + 100, yOffset += 25, 50, 20, (Component)Component.literal((String)"Blink Max"));
        this.blinkMaxField.setValue(String.valueOf(be.getBlinkMax()));
        this.blinkMaxField.setMaxLength(2);
        this.addRenderableWidget((GuiEventListener)this.blinkMaxField);
        this.blinkRateField = new EditBox(this.font, centerX + 100, yOffset += 25, 50, 20, (Component)Component.literal((String)"Blink Rate"));
        this.blinkRateField.setValue(String.valueOf(be.getBlinkRate()));
        this.blinkRateField.setMaxLength(3);
        this.addRenderableWidget((GuiEventListener)this.blinkRateField);
        this.saveButton = new ModernButton(centerX + 20, yOffset += 30, 60, 20, (Component)Component.literal((String)"Save"), btn -> this.onSave(), -13796106, -12677889, -1);
        this.addRenderableWidget((GuiEventListener)this.saveButton);
        this.cancelButton = new ModernButton(centerX + 90, yOffset, 60, 20, (Component)Component.literal((String)"Cancel"), btn -> this.onClose(), -13796106, -12677889, -1);
        this.addRenderableWidget((GuiEventListener)this.cancelButton);
    }

    private void onSave() {
        try {
            int redMax = Integer.parseInt(this.redMaxField.getValue());
            int yellowMin = Integer.parseInt(this.yellowMinField.getValue());
            int yellowMax = Integer.parseInt(this.yellowMaxField.getValue());
            int greenMin = Integer.parseInt(this.greenMinField.getValue());
            int blinkMin = Integer.parseInt(this.blinkMinField.getValue());
            int blinkMax = Integer.parseInt(this.blinkMaxField.getValue());
            int blinkRate = Integer.parseInt(this.blinkRateField.getValue());
            if (redMax < 0 || redMax > 15 || yellowMin < 0 || yellowMin > 15 || yellowMax < 0 || yellowMax > 15 || greenMin < 0 || greenMin > 15 || blinkMin < -1 || blinkMin > 15 || blinkMax < -1 || blinkMax > 15 || blinkRate < 1) {
                return;
            }
            SarosRoadSignsModMod.PACKET_HANDLER.send((Object)new TrafficLightConfigMessage(((TrafficLightConfigMenu)this.menu).pos, redMax, yellowMin, yellowMax, greenMin, blinkMin, blinkMax, blinkRate), PacketDistributor.SERVER.noArg());
            this.onClose();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.fill(x, y, x + this.imageWidth, y + this.imageHeight, -1072689136);
        guiGraphics.fill(x + 1, y + 1, x + this.imageWidth - 1, y + this.imageHeight - 1, -14013910);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, 8, 6, 0xFFFFFF, false);
        int yOffset = 20;
        guiGraphics.drawString(this.font, "Red Max (0-15):", 10, yOffset + 5, 0xFFFFFF, false);
        guiGraphics.drawString(this.font, "Yellow Min:", 10, (yOffset += 25) + 5, 0xFFFFFF, false);
        guiGraphics.drawString(this.font, "Yellow Max:", 10, (yOffset += 25) + 5, 0xFFFFFF, false);
        guiGraphics.drawString(this.font, "Green Min:", 10, (yOffset += 25) + 5, 0xFFFFFF, false);
        guiGraphics.drawString(this.font, "Blink Min (-1=off):", 10, (yOffset += 25) + 5, 0xFFFFFF, false);
        guiGraphics.drawString(this.font, "Blink Max (-1=off):", 10, (yOffset += 25) + 5, 0xFFFFFF, false);
        guiGraphics.drawString(this.font, "Blink Rate (ticks):", 10, (yOffset += 25) + 5, 0xFFFFFF, false);
        guiGraphics.drawString(this.font, "Configure redstone signal thresholds", 8, this.imageHeight - 30, 0xAAAAAA, false);
        guiGraphics.drawString(this.font, "Set blink to -1 to disable", 8, this.imageHeight - 20, 0xAAAAAA, false);
        guiGraphics.drawString(this.font, "Blink rate: 10 ticks = 0.5 sec", 8, this.imageHeight - 10, 0xAAAAAA, false);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.fill(0, 0, this.width, this.height, -1072689136);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

