/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadsignsmod.trafficlight.client;

import de.sarocesch.sarosroadsignsmod.block.entity.TrafficLightControlerBlockEntity;
import de.sarocesch.sarosroadsignsmod.trafficlight.TrafficLightRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TrafficLightControllerMenu
extends AbstractContainerMenu {
    private final BlockPos controllerPos;
    private final Level level;

    public TrafficLightControllerMenu(int containerId, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(containerId, playerInventory, extraData.readBlockPos());
    }

    public TrafficLightControllerMenu(int containerId, Inventory playerInventory, BlockPos controllerPos) {
        super((MenuType)TrafficLightRegistry.TRAFFIC_LIGHT_CONTROLLER_MENU.get(), containerId);
        this.controllerPos = controllerPos;
        this.level = playerInventory.player.level();
    }

    public boolean stillValid(Player player) {
        return player.distanceToSqr((double)this.controllerPos.getX() + 0.5, (double)this.controllerPos.getY() + 0.5, (double)this.controllerPos.getZ() + 0.5) <= 64.0;
    }

    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    public Level getLevel() {
        return this.level;
    }

    public TrafficLightControlerBlockEntity getBlockEntity() {
        BlockEntity blockEntity;
        if (this.level != null && (blockEntity = this.level.getBlockEntity(this.controllerPos)) instanceof TrafficLightControlerBlockEntity) {
            TrafficLightControlerBlockEntity be = (TrafficLightControlerBlockEntity)blockEntity;
            return be;
        }
        return null;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }
}

