/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadsignsmod.network;

import de.sarocesch.sarosroadsignsmod.SarosRoadSignsModMod;
import de.sarocesch.sarosroadsignsmod.server.SelectedSignServerState;
import de.sarocesch.sarosroadsignsmod.util.ConfigUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class SelectSignMessage {
    public final String packId;
    public final String signId;

    public SelectSignMessage(String packId, String signId) {
        this.packId = packId;
        this.signId = signId;
    }

    public static void encode(SelectSignMessage msg, FriendlyByteBuf buf) {
        buf.writeUtf(msg.packId == null ? "" : msg.packId);
        buf.writeUtf(msg.signId == null ? "" : msg.signId);
    }

    public static SelectSignMessage decode(FriendlyByteBuf buf) {
        String p = buf.readUtf();
        String s = buf.readUtf();
        return new SelectSignMessage(p, s);
    }

    public static void handle(SelectSignMessage msg, CustomPayloadEvent.Context ctx) {
        ServerPlayer sender = ctx.getSender();
        if (sender != null) {
            SelectedSignServerState.set(sender.getUUID(), msg.packId, msg.signId);
            if (ConfigUtil.isDebugEnabled()) {
                SarosRoadSignsModMod.LOGGER.info("[SRS] {} selected {}/{}", (Object)sender.getGameProfile().getName(), (Object)msg.packId, (Object)msg.signId);
            }
        }
    }
}

