/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadsignsmod.client.gui;

import de.sarocesch.sarosroadsignsmod.client.gui.components.ModernButton;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ColorPickerScreen
extends Screen {
    private final Screen parent;
    private final ColorCallback callback;
    private int selectedColor;
    private final List<ColorTile> tiles = new ArrayList<ColorTile>();

    public ColorPickerScreen(Screen parent, int initialArgb, ColorCallback cb) {
        super((Component)Component.literal((String)"Pick Color"));
        this.parent = parent;
        this.callback = cb;
        this.selectedColor = initialArgb;
    }

    private static int lighten(int col, float amt) {
        int r = col >> 16 & 0xFF;
        int g = col >> 8 & 0xFF;
        int b = col & 0xFF;
        r = (int)((float)r + (float)(255 - r) * amt);
        g = (int)((float)g + (float)(255 - g) * amt);
        b = (int)((float)b + (float)(255 - b) * amt);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    protected void init() {
        this.tiles.clear();
        int[] palette = new int[]{-16777216, -1, -5636096, -16733696, -16777046, -22016, -5635926, -16733526, -11184811, -5592406, -43691, -11141291, -11184641, -171, -43521, -11141121};
        int cols = 8;
        int tile = 18;
        int pad = 6;
        int gridW = cols * tile + (cols - 1) * pad;
        int startX = this.width / 2 - gridW / 2;
        int startY = this.height / 2 - 40;
        for (int i = 0; i < palette.length; ++i) {
            int row = i / cols;
            int col = i % cols;
            int x = startX + col * (tile + pad);
            int y = startY + row * (tile + pad);
            int color = palette[i];
            ColorTile t = new ColorTile(x, y, tile, color, b -> {
                this.selectedColor = color;
            });
            this.addRenderableWidget((GuiEventListener)t);
            this.tiles.add(t);
        }
        int centerX = this.width / 2;
        this.addRenderableWidget((GuiEventListener)new ModernButton(centerX - 100, startY + 2 * (tile + pad) + 16, 90, 20, (Component)Component.literal((String)"Set Color"), btn -> {
            if (this.callback != null) {
                this.callback.onColorPicked(this.selectedColor);
            }
            Minecraft.getInstance().setScreen(this.parent);
        }, -13796106, -12677889, -1));
        this.addRenderableWidget((GuiEventListener)new ModernButton(centerX + 10, startY + 2 * (tile + pad) + 16, 90, 20, (Component)Component.literal((String)"Cancel"), btn -> Minecraft.getInstance().setScreen(this.parent), -9671572, -7829368, -1));
    }

    public void renderBackground(GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
        gg.fill(0, 0, this.width, this.height, -1072689136);
    }

    public void render(GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(gg, mouseX, mouseY, partialTicks);
        super.render(gg, mouseX, mouseY, partialTicks);
        int centerX = this.width / 2;
        gg.drawCenteredString(this.font, this.title, centerX, this.height / 2 - 72, -1);
        int preview = this.selectedColor;
        int previewX = centerX - 40;
        int previewY = this.height / 2 - 96;
        gg.fill(previewX, previewY, previewX + 80, previewY + 20, preview);
        gg.fill(previewX - 1, previewY - 1, previewX + 81, previewY + 21, -16777216);
        gg.drawCenteredString(this.font, (Component)Component.literal((String)String.format("#%06X", preview & 0xFFFFFF)), centerX, previewY - 12, -1);
        for (ColorTile t : this.tiles) {
            if (t.color != this.selectedColor) continue;
            gg.fill(t.getX() - 2, t.getY() - 2, t.getX() + t.getWidth() + 2, t.getY() + t.getHeight() + 2, -1);
            gg.fill(t.getX() - 1, t.getY() - 1, t.getX() + t.getWidth() + 1, t.getY() + t.getHeight() + 1, -16777216);
            break;
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public static interface ColorCallback {
        public void onColorPicked(int var1);
    }

    private static class ColorTile
    extends ModernButton {
        final int color;

        ColorTile(int x, int y, int size, int color, Button.OnPress press) {
            super(x, y, size, size, (Component)Component.literal((String)""), press, color, ColorPickerScreen.lighten(color, 0.15f), -1);
            this.color = color;
        }
    }
}

