/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadsignsmod.network;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import de.sarocesch.sarosroadsignsmod.SarosRoadSignsModMod;
import de.sarocesch.sarosroadsignsmod.packs.PackDefinition;
import de.sarocesch.sarosroadsignsmod.packs.PackManager;
import de.sarocesch.sarosroadsignsmod.util.ConfigUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class PackSyncMessage {
    private static final Gson GSON = new Gson();
    private static final Type LIST_TYPE = new TypeToken<List<PackDefinition>>(){}.getType();
    private final String json;

    public PackSyncMessage(String json) {
        this.json = json;
    }

    public static void encode(PackSyncMessage msg, FriendlyByteBuf buf) {
        buf.writeUtf(msg.json);
    }

    public static PackSyncMessage decode(FriendlyByteBuf buf) {
        return new PackSyncMessage(buf.readUtf());
    }

    public static void handle(PackSyncMessage msg, CustomPayloadEvent.Context ctx) {
        try {
            ArrayList list = (ArrayList)GSON.fromJson(msg.json, LIST_TYPE);
            if (list == null) {
                list = new ArrayList();
            }
            PackManager.updateServerAuthorizedPacks(list);
            if (ConfigUtil.isDebugEnabled()) {
                SarosRoadSignsModMod.LOGGER.info("[SRS] Received pack sync: {} packs", (Object)list.size());
            }
        }
        catch (Exception e) {
            SarosRoadSignsModMod.LOGGER.warn("[SRS] Failed to handle pack sync: {}", (Object)e.toString());
        }
    }
}

