/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadsignsmod.trafficlight.blockentity;

import de.sarocesch.sarosroadsignsmod.trafficlight.block.NewTrafficLightBlock;
import de.sarocesch.sarosroadsignsmod.trafficlight.block.TrafficLightState;
import de.sarocesch.sarosroadsignsmod.trafficlight.client.TrafficLightConfigMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class NewTrafficLightBlockEntity
extends BlockEntity
implements MenuProvider {
    private int redMax = 0;
    private int yellowMin = 1;
    private int yellowMax = 14;
    private int greenMin = 15;
    private int blinkMin = -1;
    private int blinkMax = -1;
    private int blinkRate = 10;
    private boolean blinkOn = true;
    private long lastBlinkTime = 0L;
    private static BlockEntityType<?> blockEntityType;

    public NewTrafficLightBlockEntity(BlockPos pos, BlockState state) {
        super(NewTrafficLightBlockEntity.getBlockEntityType(), pos, state);
    }

    public static void setBlockEntityType(BlockEntityType<?> type) {
        blockEntityType = type;
    }

    private static BlockEntityType<?> getBlockEntityType() {
        if (blockEntityType == null) {
            throw new IllegalStateException("BlockEntityType not set for NewTrafficLightBlockEntity");
        }
        return blockEntityType;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.redMax = tag.getInt("RedMax").orElse(0);
        this.yellowMin = tag.getInt("YellowMin").orElse(1);
        this.yellowMax = tag.getInt("YellowMax").orElse(14);
        this.greenMin = tag.getInt("GreenMin").orElse(15);
        this.blinkMin = tag.getInt("BlinkMin").orElse(-1);
        this.blinkMax = tag.getInt("BlinkMax").orElse(-1);
        this.blinkRate = tag.getInt("BlinkRate").orElse(10);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("RedMax", this.redMax);
        tag.putInt("YellowMin", this.yellowMin);
        tag.putInt("YellowMax", this.yellowMax);
        tag.putInt("GreenMin", this.greenMin);
        tag.putInt("BlinkMin", this.blinkMin);
        tag.putInt("BlinkMax", this.blinkMax);
        tag.putInt("BlinkRate", this.blinkRate);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithFullMetadata(provider);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void tick() {
        long currentTime;
        TrafficLightState currentState;
        BlockState currentBlockState;
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        if (this.level.getGameTime() % 10L == 0L) {
            this.updateStateFromRedstone();
        }
        if ((currentBlockState = this.level.getBlockState(this.worldPosition)).getBlock() instanceof NewTrafficLightBlock && ((currentState = (TrafficLightState)((Object)currentBlockState.getValue(NewTrafficLightBlock.LIGHT_STATE))) == TrafficLightState.BLINKING_ON || currentState == TrafficLightState.BLINKING_OFF) && (currentTime = this.level.getGameTime()) - this.lastBlinkTime >= (long)this.blinkRate) {
            this.blinkOn = !this.blinkOn;
            this.lastBlinkTime = currentTime;
            TrafficLightState newBlinkState = this.blinkOn ? TrafficLightState.BLINKING_ON : TrafficLightState.BLINKING_OFF;
            this.level.setBlock(this.worldPosition, (BlockState)currentBlockState.setValue(NewTrafficLightBlock.LIGHT_STATE, (Comparable)((Object)newBlinkState)), 3);
        }
    }

    public void updateStateFromRedstone() {
        TrafficLightState currentState;
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        int redstonePower = this.level.getBestNeighborSignal(this.worldPosition);
        TrafficLightState newState = this.determineStateFromPower(redstonePower);
        BlockState currentBlockState = this.level.getBlockState(this.worldPosition);
        if (currentBlockState.getBlock() instanceof NewTrafficLightBlock && (currentState = (TrafficLightState)((Object)currentBlockState.getValue(NewTrafficLightBlock.LIGHT_STATE))) != newState) {
            this.level.setBlock(this.worldPosition, (BlockState)currentBlockState.setValue(NewTrafficLightBlock.LIGHT_STATE, (Comparable)((Object)newState)), 3);
        }
    }

    private TrafficLightState determineStateFromPower(int power) {
        if (this.blinkMin >= 0 && this.blinkMax >= 0 && power >= this.blinkMin && power <= this.blinkMax) {
            return this.blinkOn ? TrafficLightState.BLINKING_ON : TrafficLightState.BLINKING_OFF;
        }
        if (power <= this.redMax) {
            return TrafficLightState.RED;
        }
        if (power >= this.yellowMin && power <= this.yellowMax) {
            return TrafficLightState.YELLOW;
        }
        if (power >= this.greenMin) {
            return TrafficLightState.GREEN;
        }
        return TrafficLightState.OFF;
    }

    public int getRedMax() {
        return this.redMax;
    }

    public void setRedMax(int redMax) {
        this.redMax = redMax;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public int getYellowMin() {
        return this.yellowMin;
    }

    public void setYellowMin(int yellowMin) {
        this.yellowMin = yellowMin;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public int getYellowMax() {
        return this.yellowMax;
    }

    public void setYellowMax(int yellowMax) {
        this.yellowMax = yellowMax;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public int getGreenMin() {
        return this.greenMin;
    }

    public void setGreenMin(int greenMin) {
        this.greenMin = greenMin;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public int getBlinkMin() {
        return this.blinkMin;
    }

    public void setBlinkMin(int blinkMin) {
        this.blinkMin = blinkMin;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public int getBlinkMax() {
        return this.blinkMax;
    }

    public void setBlinkMax(int blinkMax) {
        this.blinkMax = blinkMax;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public boolean isBlinkOn() {
        return this.blinkOn;
    }

    public int getBlinkRate() {
        return this.blinkRate;
    }

    public void setBlinkRate(int blinkRate) {
        this.blinkRate = blinkRate;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.saros_road_signs_mod.traffic_light_config");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new TrafficLightConfigMenu(id, inventory, this.worldPosition);
    }
}

