/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadsignsmod.block;

import com.mojang.serialization.MapCodec;
import de.sarocesch.sarosroadsignsmod.block.entity.CustomSignBlockEntity;
import de.sarocesch.sarosroadsignsmod.client.ClientHooks;
import de.sarocesch.sarosroadsignsmod.custom.CustomBlockEntities;
import de.sarocesch.sarosroadsignsmod.init.SarosRoadSignsModModBlocks;
import de.sarocesch.sarosroadsignsmod.item.PaintBrushItem;
import de.sarocesch.sarosroadsignsmod.packs.PackDefinition;
import de.sarocesch.sarosroadsignsmod.packs.PackManager;
import de.sarocesch.sarosroadsignsmod.packs.SignDefinition;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.Nullable;

public class CustomSignBlock
extends BaseEntityBlock {
    public static final MapCodec<CustomSignBlock> CODEC = CustomSignBlock.simpleCodec(p -> new CustomSignBlock());
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public CustomSignBlock() {
        super(BlockBehaviour.Properties.of().noOcclusion().strength(1.0f));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)CustomBlockEntities.CUSTOM_SIGN_BE.get()).create(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return this.rotate(state, mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.isClientSide) {
            ItemStack held = player.getItemInHand(hand);
            if (held.getItem() instanceof PaintBrushItem) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHooks.openSignSelectionScreen(pos));
                return InteractionResult.SUCCESS;
            }
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof CustomSignBlockEntity) {
                SignDefinition signDef;
                CustomSignBlockEntity be = (CustomSignBlockEntity)blockEntity;
                PackDefinition pack = PackManager.getPacks().stream().filter(p -> p.id.equals(be.getPackId())).findFirst().orElse(null);
                if (pack != null && (signDef = (SignDefinition)pack.signs.stream().filter(s -> s.id.equals(be.getSignId())).findFirst().orElse(null)) != null && signDef.text_enabled) {
                    DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHooks.openSignTextEditScreen(pos, be.getText()));
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.CONSUME;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof CustomSignBlockEntity) {
            SignDefinition def;
            PackDefinition pack;
            CustomSignBlockEntity signBe = (CustomSignBlockEntity)be;
            SignDefinition.Shape shape = SignDefinition.Shape.RECTANGLE;
            String packId = signBe.getPackId();
            String signId = signBe.getSignId();
            if (packId != null && signId != null && (pack = (PackDefinition)PackManager.getPacks().stream().filter(p -> packId.equals(p.id)).findFirst().orElse(null)) != null && (def = (SignDefinition)pack.signs.stream().filter(s -> signId.equals(s.id)).findFirst().orElse(null)) != null && def.shape != null) {
                shape = def.shape;
            }
            Direction dir = (Direction)state.getValue((Property)FACING);
            switch (shape) {
                case ROUND: {
                    return this.shapeFromBlock((Block)SarosRoadSignsModModBlocks.SCHLID_BLANK.get(), dir);
                }
                case TRIANGLE: {
                    return this.shapeFromBlock((Block)SarosRoadSignsModModBlocks.ECKEN.get(), dir);
                }
                case DIAMOND: {
                    return this.shapeFromBlock((Block)SarosRoadSignsModModBlocks.VOR_FAHRT.get(), dir);
                }
                case OTHER: 
                case CUSTOM: {
                    return this.shapeFromBlock((Block)SarosRoadSignsModModBlocks.SCHILD_TUNNEL.get(), dir);
                }
            }
            return this.shapeFromBlock((Block)SarosRoadSignsModModBlocks.SCHILD_4_ECK.get(), dir);
        }
        return CustomSignBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    }

    private VoxelShape shapeFromBlock(Block ref, Direction dir) {
        try {
            BlockState st = ref.defaultBlockState();
            if (st.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                st = (BlockState)st.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)dir);
            }
            return ref.getShape(st, null, null, CollisionContext.empty());
        }
        catch (Throwable t) {
            return CustomSignBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
        }
    }

    private VoxelShape shapeFromState(Block refBlock, Direction dir) {
        return this.shapeFromBlock(refBlock, dir);
    }

    public ItemStack getCloneItemStack(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)SarosRoadSignsModModBlocks.SCHLID_BLANK.get());
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return Collections.singletonList(new ItemStack((ItemLike)SarosRoadSignsModModBlocks.SCHLID_BLANK.get()));
    }
}

