/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadsignsmod.client.gui;

import de.sarocesch.sarosroadsignsmod.SarosRoadSignsModMod;
import de.sarocesch.sarosroadsignsmod.client.gui.SelectedSignState;
import de.sarocesch.sarosroadsignsmod.client.gui.SignTextEditScreen;
import de.sarocesch.sarosroadsignsmod.client.gui.components.ModernButton;
import de.sarocesch.sarosroadsignsmod.network.CustomSignPlaceMessage;
import de.sarocesch.sarosroadsignsmod.network.SelectSignMessage;
import de.sarocesch.sarosroadsignsmod.packs.PackDefinition;
import de.sarocesch.sarosroadsignsmod.packs.PackManager;
import de.sarocesch.sarosroadsignsmod.packs.SignDefinition;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraftforge.network.PacketDistributor;

public class CustomSignSelectionScreen
extends Screen {
    private View view = View.PACKS;
    private PackDefinition selectedPack;
    private ModernButton editTextBtn;
    private PlainTextButton backToDefaultBtn;
    private int scrollOffset = 0;
    private int originX;
    private int originY;
    private int originZ;
    private Screen parent;
    private List<PackDefinition> packs;

    public boolean isPauseScreen() {
        return false;
    }

    public CustomSignSelectionScreen(Screen parent, int x, int y, int z) {
        this(parent);
        this.originX = x;
        this.originY = y;
        this.originZ = z;
    }

    public CustomSignSelectionScreen(Screen parent) {
        super((Component)Component.literal((String)"Custom Signs"));
        this.parent = parent;
    }

    protected void init() {
        PackManager.ensureExamplePack();
        PackManager.scan();
        this.packs = PackManager.getServerAuthorizedPacksOrLocalIfNone();
        this.clearWidgets();
        this.backToDefaultBtn = new PlainTextButton(this.width - 180, 8, 170, 20, (Component)Component.translatable((String)"gui.saros_road_signs_mod.custom_pack_gui.back_to_default"), b -> {
            if (this.parent != null) {
                Minecraft.getInstance().setScreen(this.parent);
            } else {
                Minecraft.getInstance().setScreen(null);
            }
        }, Minecraft.getInstance().font);
        this.addRenderableWidget((GuiEventListener)this.backToDefaultBtn);
        int x = 14;
        int y = 34;
        if (this.view == View.PACKS) {
            int cardHeight = 28;
            for (PackDefinition p : this.packs) {
                int cardTop = y;
                int cardBottom = y + cardHeight;
                int cardLeft = x;
                int cardRight = this.width - 14;
                ModernButton card = new ModernButton(cardLeft, cardTop, cardRight - cardLeft, cardHeight, (Component)Component.literal((String)""), b -> {
                    this.selectedPack = p;
                    this.view = View.SIGNS;
                    this.scrollOffset = 0;
                    this.init();
                }, 0x44000000, 0x66888888, -1);
                card.setAlpha(0.0f);
                this.addRenderableWidget((GuiEventListener)card);
                y = cardBottom + 6;
            }
        } else if (this.view == View.SIGNS && this.selectedPack != null) {
            this.editTextBtn = new ModernButton(14, 8, 100, 20, (Component)Component.literal((String)"Edit Text"), b -> {
                if (this.editTextBtn != null && this.editTextBtn.active && SelectedSignState.hasSelection()) {
                    BlockPos bp = new BlockPos(this.originX, this.originY, this.originZ);
                    Minecraft.getInstance().setScreen((Screen)new SignTextEditScreen(this, bp, ""));
                }
            }, -13796106, -12677889, -1);
            this.addRenderableWidget((GuiEventListener)this.editTextBtn);
            int visibleTop = y;
            int visibleBottom = this.height - 8;
            int sx = x + 8;
            int sy = y - this.scrollOffset;
            int btnW = 200;
            for (SignDefinition s : this.selectedPack.signs) {
                int rowTop = sy;
                int rowBottom = sy + 20;
                if (rowBottom >= visibleTop && rowTop <= visibleBottom) {
                    String label = s.displayName == null ? s.id : s.displayName;
                    int btnX = sx + 52;
                    ModernButton btn = new ModernButton(btnX, sy, btnW, 20, (Component)Component.literal((String)label), b -> {
                        SelectedSignState.set(this.selectedPack.id, s.id);
                        if (Minecraft.getInstance().getConnection() != null) {
                            SarosRoadSignsModMod.PACKET_HANDLER.send((Object)new SelectSignMessage(this.selectedPack.id, s.id), PacketDistributor.SERVER.noArg());
                            SarosRoadSignsModMod.PACKET_HANDLER.send((Object)new CustomSignPlaceMessage(new BlockPos(this.originX, this.originY, this.originZ)), PacketDistributor.SERVER.noArg());
                        }
                    }, -12961222, -11908534, -1);
                    this.addRenderableWidget((GuiEventListener)btn);
                }
                sy += 26;
            }
            this.addRenderableWidget((GuiEventListener)new ModernButton(this.width - 90, 32, 80, 20, (Component)Component.literal((String)"< Back"), b -> {
                this.view = View.PACKS;
                this.init();
            }, -13796106, -12677889, -1));
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.view == View.SIGNS && this.selectedPack != null) {
            int listTop = 34;
            int listBottom = this.height - 8;
            int visibleHeight = Math.max(0, listBottom - listTop);
            int contentHeight = Math.max(0, this.selectedPack.signs.size() * 26);
            int maxScroll = Math.max(0, contentHeight - visibleHeight);
            this.scrollOffset -= (int)Math.round(scrollY * 20.0);
            if (this.scrollOffset < 0) {
                this.scrollOffset = 0;
            }
            if (this.scrollOffset > maxScroll) {
                this.scrollOffset = maxScroll;
            }
            this.init();
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void render(GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(gg, mouseX, mouseY, partialTicks);
        gg.fillGradient(0, 0, this.width, 30, -871296751, 0);
        if (this.view == View.PACKS) {
            gg.drawString(this.font, this.title, 12, 12, 0xFFFFFF);
        }
        int y = 34;
        int x = 14;
        if (this.view == View.PACKS && this.packs != null) {
            for (PackDefinition p : this.packs) {
                int cardTop = y;
                int cardBottom = y + 28;
                int left = x;
                int right = this.width - 14;
                boolean hover = mouseX >= left && mouseX <= right && mouseY >= cardTop && mouseY <= cardBottom;
                int topCol = hover ? 0x66888888 : 0x44000000;
                int botCol = hover ? 0x33444444 : 0x22000000;
                gg.fillGradient(left, cardTop, right, cardBottom, topCol, botCol);
                gg.drawString(this.font, (Component)Component.literal((String)p.name), x + 8, y + 8, 0xFFFFFF);
                gg.drawString(this.font, (Component)Component.literal((String)("Signs: " + p.signs.size())), right - 80, y + 8, 0xAAAAAA);
                y = cardBottom + 6;
            }
        } else if (this.view == View.SIGNS && this.selectedPack != null) {
            int sxBadge = x + 8 + 52 + 200 + 6;
            int syBadge = 34 - this.scrollOffset;
            for (SignDefinition s : this.selectedPack.signs) {
                if (s.text_enabled) {
                    gg.fill(sxBadge, syBadge + 4, sxBadge + 12, syBadge + 16, -13796106);
                    gg.drawString(this.font, (Component)Component.literal((String)"T"), sxBadge + 3, syBadge + 6, -1);
                }
                syBadge += 26;
            }
            if (this.editTextBtn != null) {
                boolean enable = false;
                String psel = SelectedSignState.getPackId();
                String ssel = SelectedSignState.getSignId();
                if (psel != null && ssel != null && this.selectedPack != null && psel.equals(this.selectedPack.id)) {
                    SignDefinition def = this.selectedPack.signs.stream().filter(sd -> ssel.equals(sd.id)).findFirst().orElse(null);
                    enable = def != null && def.text_enabled;
                }
                this.editTextBtn.active = enable;
                this.editTextBtn.visible = true;
                this.editTextBtn.setAlpha(enable ? 1.0f : 0.5f);
            }
        }
        super.render(gg, mouseX, mouseY, partialTicks);
    }

    private static enum View {
        PACKS,
        SIGNS;

    }
}

