/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadsignsmod.network;

import de.sarocesch.sarosroadsignsmod.SarosRoadSignsModMod;
import de.sarocesch.sarosroadsignsmod.block.CustomSignBlock;
import de.sarocesch.sarosroadsignsmod.block.entity.CustomSignBlockEntity;
import de.sarocesch.sarosroadsignsmod.custom.CustomBlocks;
import de.sarocesch.sarosroadsignsmod.server.SelectedSignServerState;
import de.sarocesch.sarosroadsignsmod.util.ConfigUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class CustomSignPlaceMessage {
    public final BlockPos pos;

    public CustomSignPlaceMessage(BlockPos pos) {
        this.pos = pos;
    }

    public static void encode(CustomSignPlaceMessage m, FriendlyByteBuf b) {
        b.writeBlockPos(m.pos);
    }

    public static CustomSignPlaceMessage decode(FriendlyByteBuf b) {
        return new CustomSignPlaceMessage(b.readBlockPos());
    }

    public static void handle(CustomSignPlaceMessage msg, CustomPayloadEvent.Context ctx) {
        ServerPlayer sp = ctx.getSender();
        if (sp == null) {
            return;
        }
        String pack = SelectedSignServerState.getPack(sp.getUUID());
        String sign = SelectedSignServerState.getSign(sp.getUUID());
        if (pack == null || sign == null) {
            return;
        }
        Level world = sp.level();
        if (world instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)world;
            slevel.sendBlockUpdated(msg.pos, slevel.getBlockState(msg.pos), slevel.getBlockState(msg.pos), 3);
        }
        BlockState oldState = world.getBlockState(msg.pos);
        Direction facing = Direction.NORTH;
        if (oldState != null && oldState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            facing = (Direction)oldState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        } else if (sp != null) {
            facing = sp.getDirection().getOpposite();
        }
        BlockState newState = ((Block)CustomBlocks.CUSTOM_SIGN.get()).defaultBlockState();
        if (newState.hasProperty((Property)CustomSignBlock.FACING)) {
            newState = (BlockState)newState.setValue((Property)CustomSignBlock.FACING, (Comparable)facing);
        }
        world.setBlock(msg.pos, newState, 3);
        BlockEntity blockEntity = world.getBlockEntity(msg.pos);
        if (blockEntity instanceof CustomSignBlockEntity) {
            CustomSignBlockEntity be = (CustomSignBlockEntity)blockEntity;
            be.set(pack, sign);
        }
        if (ConfigUtil.isDebugEnabled()) {
            SarosRoadSignsModMod.LOGGER.info("[SRS] Placed custom sign at {} {} {} => {}/{}", (Object)msg.pos.getX(), (Object)msg.pos.getY(), (Object)msg.pos.getZ(), (Object)pack, (Object)sign);
        }
    }
}

