/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadsignsmod.trafficlight.block;

import de.sarocesch.sarosroadsignsmod.trafficlight.block.TrafficLightState;
import de.sarocesch.sarosroadsignsmod.trafficlight.blockentity.NewTrafficLightBlockEntity;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class NewTrafficLightBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<TrafficLightState> LIGHT_STATE = EnumProperty.create((String)"light_state", TrafficLightState.class);

    public NewTrafficLightBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(1.0f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false).lightLevel(state -> switch ((TrafficLightState)((Object)((Object)state.getValue(LIGHT_STATE)))) {
            default -> throw new IncompatibleClassChangeError();
            case TrafficLightState.RED -> 10;
            case TrafficLightState.YELLOW -> 12;
            case TrafficLightState.GREEN -> 10;
            case TrafficLightState.BLINKING_ON -> 12;
            case TrafficLightState.BLINKING_OFF -> 0;
            case TrafficLightState.OFF -> 0;
        }));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(LIGHT_STATE, (Comparable)((Object)TrafficLightState.RED)));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public void appendHoverText(ItemStack itemstack, BlockGetter world, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, world, list, flag);
        list.add((Component)Component.literal((String)"\u2728 Traffic Light").withStyle(ChatFormatting.AQUA));
        list.add((Component)Component.literal((String)"Use Tuner to connect to Traffic Light Controller").withStyle(ChatFormatting.GRAY));
        list.add((Component)Component.literal((String)"Controller manages all connected lights").withStyle(ChatFormatting.GRAY));
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> Shapes.or((VoxelShape)NewTrafficLightBlock.box((double)4.2, (double)14.7, (double)4.0, (double)11.8, (double)15.2, (double)6.0), (VoxelShape[])new VoxelShape[]{NewTrafficLightBlock.box((double)11.3, (double)11.0, (double)4.0, (double)11.8, (double)14.7, (double)6.0), NewTrafficLightBlock.box((double)4.2, (double)11.0, (double)4.0, (double)4.7, (double)14.7, (double)6.0), NewTrafficLightBlock.box((double)4.2, (double)8.3, (double)4.0, (double)11.8, (double)8.8, (double)6.0), NewTrafficLightBlock.box((double)11.3, (double)4.3, (double)4.0, (double)11.8, (double)8.3, (double)6.0), NewTrafficLightBlock.box((double)4.2, (double)4.3, (double)4.0, (double)4.7, (double)8.3, (double)6.0), NewTrafficLightBlock.box((double)4.2, (double)1.7, (double)4.0, (double)11.8, (double)2.2, (double)6.0), NewTrafficLightBlock.box((double)11.3, (double)-2.3, (double)4.0, (double)11.8, (double)1.7, (double)6.0), NewTrafficLightBlock.box((double)4.2, (double)-2.3, (double)4.0, (double)4.7, (double)1.7, (double)6.0), NewTrafficLightBlock.box((double)3.3, (double)-5.0, (double)6.0, (double)12.8, (double)16.5, (double)7.0), NewTrafficLightBlock.box((double)4.75, (double)9.25, (double)5.0, (double)11.325, (double)14.75, (double)6.0), NewTrafficLightBlock.box((double)4.75, (double)3.0, (double)5.0, (double)11.325, (double)8.5, (double)6.0), NewTrafficLightBlock.box((double)4.75, (double)-3.75, (double)5.0, (double)11.325, (double)1.75, (double)6.0), NewTrafficLightBlock.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)NewTrafficLightBlock.box((double)10.0, (double)14.7, (double)4.2, (double)12.0, (double)15.2, (double)11.8), (VoxelShape[])new VoxelShape[]{NewTrafficLightBlock.box((double)10.0, (double)11.0, (double)11.3, (double)12.0, (double)14.7, (double)11.8), NewTrafficLightBlock.box((double)10.0, (double)11.0, (double)4.2, (double)12.0, (double)14.7, (double)4.7), NewTrafficLightBlock.box((double)10.0, (double)8.3, (double)4.2, (double)12.0, (double)8.8, (double)11.8), NewTrafficLightBlock.box((double)10.0, (double)4.3, (double)11.3, (double)12.0, (double)8.3, (double)11.8), NewTrafficLightBlock.box((double)10.0, (double)4.3, (double)4.2, (double)12.0, (double)8.3, (double)4.7), NewTrafficLightBlock.box((double)10.0, (double)1.7, (double)4.2, (double)12.0, (double)2.2, (double)11.8), NewTrafficLightBlock.box((double)10.0, (double)-2.3, (double)11.3, (double)12.0, (double)1.7, (double)11.8), NewTrafficLightBlock.box((double)10.0, (double)-2.3, (double)4.2, (double)12.0, (double)1.7, (double)4.7), NewTrafficLightBlock.box((double)9.0, (double)-5.0, (double)3.3, (double)10.0, (double)16.5, (double)12.8), NewTrafficLightBlock.box((double)10.0, (double)9.25, (double)4.75, (double)11.0, (double)14.75, (double)11.325), NewTrafficLightBlock.box((double)10.0, (double)3.0, (double)4.75, (double)11.0, (double)8.5, (double)11.325), NewTrafficLightBlock.box((double)10.0, (double)-3.75, (double)4.75, (double)11.0, (double)1.75, (double)11.325), NewTrafficLightBlock.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)NewTrafficLightBlock.box((double)4.0, (double)14.7, (double)4.2, (double)6.0, (double)15.2, (double)11.8), (VoxelShape[])new VoxelShape[]{NewTrafficLightBlock.box((double)4.0, (double)11.0, (double)4.2, (double)6.0, (double)14.7, (double)4.7), NewTrafficLightBlock.box((double)4.0, (double)11.0, (double)11.3, (double)6.0, (double)14.7, (double)11.8), NewTrafficLightBlock.box((double)4.0, (double)8.3, (double)4.2, (double)6.0, (double)8.8, (double)11.8), NewTrafficLightBlock.box((double)4.0, (double)4.3, (double)4.2, (double)6.0, (double)8.3, (double)4.7), NewTrafficLightBlock.box((double)4.0, (double)4.3, (double)11.3, (double)6.0, (double)8.3, (double)11.8), NewTrafficLightBlock.box((double)4.0, (double)1.7, (double)4.2, (double)6.0, (double)2.2, (double)11.8), NewTrafficLightBlock.box((double)4.0, (double)-2.3, (double)4.2, (double)6.0, (double)1.7, (double)4.7), NewTrafficLightBlock.box((double)4.0, (double)-2.3, (double)11.3, (double)6.0, (double)1.7, (double)11.8), NewTrafficLightBlock.box((double)6.0, (double)-5.0, (double)3.2, (double)7.0, (double)16.5, (double)12.7), NewTrafficLightBlock.box((double)5.0, (double)9.25, (double)4.675, (double)6.0, (double)14.75, (double)11.25), NewTrafficLightBlock.box((double)5.0, (double)3.0, (double)4.675, (double)6.0, (double)8.5, (double)11.25), NewTrafficLightBlock.box((double)5.0, (double)-3.75, (double)4.675, (double)6.0, (double)1.75, (double)11.25), NewTrafficLightBlock.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0)});
            default -> Shapes.or((VoxelShape)NewTrafficLightBlock.box((double)4.2, (double)14.7, (double)10.0, (double)11.8, (double)15.2, (double)12.0), (VoxelShape[])new VoxelShape[]{NewTrafficLightBlock.box((double)4.2, (double)11.0, (double)10.0, (double)4.7, (double)14.7, (double)12.0), NewTrafficLightBlock.box((double)11.3, (double)11.0, (double)10.0, (double)11.8, (double)14.7, (double)12.0), NewTrafficLightBlock.box((double)4.2, (double)8.3, (double)10.0, (double)11.8, (double)8.8, (double)12.0), NewTrafficLightBlock.box((double)4.2, (double)4.3, (double)10.0, (double)4.7, (double)8.3, (double)12.0), NewTrafficLightBlock.box((double)11.3, (double)4.3, (double)10.0, (double)11.8, (double)8.3, (double)12.0), NewTrafficLightBlock.box((double)4.2, (double)1.7, (double)10.0, (double)11.8, (double)2.2, (double)12.0), NewTrafficLightBlock.box((double)4.2, (double)-2.3, (double)10.0, (double)4.7, (double)1.7, (double)12.0), NewTrafficLightBlock.box((double)11.3, (double)-2.3, (double)10.0, (double)11.8, (double)1.7, (double)12.0), NewTrafficLightBlock.box((double)3.2, (double)-5.0, (double)9.0, (double)12.7, (double)16.5, (double)10.0), NewTrafficLightBlock.box((double)4.675, (double)9.25, (double)10.0, (double)11.25, (double)14.75, (double)11.0), NewTrafficLightBlock.box((double)4.675, (double)3.0, (double)10.0, (double)11.25, (double)8.5, (double)11.0), NewTrafficLightBlock.box((double)4.675, (double)-3.75, (double)10.0, (double)11.25, (double)1.75, (double)11.0), NewTrafficLightBlock.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LIGHT_STATE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue(LIGHT_STATE, (Comparable)((Object)TrafficLightState.RED));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List dropsOriginal = super.getDrops(state, builder);
        if (!dropsOriginal.isEmpty()) {
            return dropsOriginal;
        }
        return Collections.singletonList(new ItemStack((ItemLike)this, 1));
    }

    public void setLightState(Level world, BlockPos pos, TrafficLightState newState) {
        BlockState currentState = world.getBlockState(pos);
        if (currentState.getBlock() == this) {
            BlockState newBlockState = (BlockState)currentState.setValue(LIGHT_STATE, (Comparable)((Object)newState));
            world.setBlock(pos, newBlockState, 3);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new NewTrafficLightBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide() ? null : (lvl, pos, st, be) -> {
            if (be instanceof NewTrafficLightBlockEntity) {
                NewTrafficLightBlockEntity trafficLightBE = (NewTrafficLightBlockEntity)be;
                trafficLightBE.tick();
            }
        };
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }
}

