/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadsignsmod.trafficlight.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.sarocesch.sarosroadsignsmod.init.SarosRoadSignsModModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(modid="saros_road_signs_mod", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class TrafficLightOutlineRenderer {
    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        boolean holdingTuner;
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        boolean bl = holdingTuner = mainHand.getItem() == SarosRoadSignsModModItems.TUNER.get() || offHand.getItem() == SarosRoadSignsModModItems.TUNER.get();
        if (!holdingTuner) {
            return;
        }
        ItemStack tuner = mainHand.getItem() == SarosRoadSignsModModItems.TUNER.get() ? mainHand : offHand;
        CompoundTag tunerTag = tuner.getOrCreateTag();
        if (!tunerTag.contains("ControllerX")) {
            return;
        }
        int controllerX = tunerTag.getInt("ControllerX");
        int controllerY = tunerTag.getInt("ControllerY");
        int controllerZ = tunerTag.getInt("ControllerZ");
        BlockPos controllerPos = new BlockPos(controllerX, controllerY, controllerZ);
        Level level = player.level();
        BlockEntity controllerBE = level.getBlockEntity(controllerPos);
        if (controllerBE == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        Vec3 cameraPos = event.getCamera().getPosition();
        TrafficLightOutlineRenderer.renderBlockOutline(poseStack, (MultiBufferSource)bufferSource, controllerPos, cameraPos, 0.0f, 1.0f, 1.0f, 1.0f);
        List<BlockPos> connectedLights = TrafficLightOutlineRenderer.getConnectedTrafficLights(controllerBE);
        for (BlockPos lightPos : connectedLights) {
            TrafficLightOutlineRenderer.renderBlockOutline(poseStack, (MultiBufferSource)bufferSource, lightPos, cameraPos, 0.0f, 1.0f, 0.0f, 1.0f);
            TrafficLightOutlineRenderer.renderConnectionLine(poseStack, (MultiBufferSource)bufferSource, controllerPos, lightPos, cameraPos, 0.0f, 1.0f, 0.5f, 0.8f);
        }
        bufferSource.endBatch();
    }

    private static List<BlockPos> getConnectedTrafficLights(BlockEntity controllerBE) {
        ArrayList<BlockPos> lights = new ArrayList<BlockPos>();
        CompoundTag nbt = controllerBE.getPersistentData();
        for (String key : nbt.getAllKeys()) {
            String value;
            if (!key.startsWith("NewTrafficLight_") || (value = nbt.getString(key)).isEmpty()) continue;
            try {
                String[] coords = value.split(",");
                if (coords.length != 3) continue;
                int x = Integer.parseInt(coords[0]);
                int y = Integer.parseInt(coords[1]);
                int z = Integer.parseInt(coords[2]);
                lights.add(new BlockPos(x, y, z));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return lights;
    }

    private static void renderBlockOutline(PoseStack poseStack, MultiBufferSource bufferSource, BlockPos pos, Vec3 cameraPos, float r, float g, float b, float a) {
        poseStack.pushPose();
        poseStack.translate((double)pos.getX() - cameraPos.x, (double)pos.getY() - cameraPos.y, (double)pos.getZ() - cameraPos.z);
        AABB aabb = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).inflate(0.002);
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.lines());
        Matrix4f matrix = poseStack.last().pose();
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)consumer, (AABB)aabb, (float)r, (float)g, (float)b, (float)a);
        poseStack.popPose();
    }

    private static void renderConnectionLine(PoseStack poseStack, MultiBufferSource bufferSource, BlockPos from, BlockPos to, Vec3 cameraPos, float r, float g, float b, float a) {
        poseStack.pushPose();
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.lines());
        Matrix4f matrix = poseStack.last().pose();
        Vec3 fromCenter = Vec3.atCenterOf((Vec3i)from).subtract(cameraPos);
        Vec3 toCenter = Vec3.atCenterOf((Vec3i)to).subtract(cameraPos);
        float offset = 0.05f;
        TrafficLightOutlineRenderer.drawLine(consumer, matrix, fromCenter, toCenter, r, g, b, a);
        TrafficLightOutlineRenderer.drawLine(consumer, matrix, fromCenter.add((double)offset, 0.0, 0.0), toCenter.add((double)offset, 0.0, 0.0), r, g, b, a * 0.7f);
        TrafficLightOutlineRenderer.drawLine(consumer, matrix, fromCenter.add((double)(-offset), 0.0, 0.0), toCenter.add((double)(-offset), 0.0, 0.0), r, g, b, a * 0.7f);
        TrafficLightOutlineRenderer.drawLine(consumer, matrix, fromCenter.add(0.0, (double)offset, 0.0), toCenter.add(0.0, (double)offset, 0.0), r, g, b, a * 0.7f);
        TrafficLightOutlineRenderer.drawLine(consumer, matrix, fromCenter.add(0.0, (double)(-offset), 0.0), toCenter.add(0.0, (double)(-offset), 0.0), r, g, b, a * 0.7f);
        TrafficLightOutlineRenderer.drawLine(consumer, matrix, fromCenter.add(0.0, 0.0, (double)offset), toCenter.add(0.0, 0.0, (double)offset), r, g, b, a * 0.7f);
        TrafficLightOutlineRenderer.drawLine(consumer, matrix, fromCenter.add(0.0, 0.0, (double)(-offset)), toCenter.add(0.0, 0.0, (double)(-offset)), r, g, b, a * 0.7f);
        poseStack.popPose();
    }

    private static void drawLine(VertexConsumer consumer, Matrix4f matrix, Vec3 from, Vec3 to, float r, float g, float b, float a) {
        consumer.vertex(matrix, (float)from.x, (float)from.y, (float)from.z).color(r, g, b, a).normal(0.0f, 1.0f, 0.0f).endVertex();
        consumer.vertex(matrix, (float)to.x, (float)to.y, (float)to.z).color(r, g, b, a).normal(0.0f, 1.0f, 0.0f).endVertex();
    }
}

