/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadsignsmod.block.entity;

import de.sarocesch.sarosroadsignsmod.custom.CustomBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CustomSignBlockEntity
extends BlockEntity {
    private String packId;
    private String signId;
    private String text = "";
    private int textColor = -16777216;

    public CustomSignBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CustomBlockEntities.CUSTOM_SIGN_BE.get(), pos, state);
    }

    public String getPackId() {
        return this.packId;
    }

    public String getSignId() {
        return this.signId;
    }

    public String getText() {
        return this.text;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void set(String pack, String sign) {
        this.packId = pack;
        this.signId = sign;
        this.setChanged();
        this.notifyClients();
    }

    public void setText(String text) {
        this.text = text == null ? "" : text;
        this.setChanged();
        this.notifyClients();
    }

    public void setTextAndColor(String text, int color) {
        this.text = text == null ? "" : text;
        this.textColor = color;
        this.setChanged();
        this.notifyClients();
    }

    private void notifyClients() {
        if (this.level != null && !this.level.isClientSide) {
            BlockState state = this.getBlockState();
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.packId = tag.getString("pack");
        this.signId = tag.getString("sign");
        this.text = tag.contains("text") ? tag.getString("text") : "";
        this.textColor = tag.contains("textColor") ? tag.getInt("textColor") : -16777216;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putString("pack", this.packId == null ? "" : this.packId);
        tag.putString("sign", this.signId == null ? "" : this.signId);
        tag.putString("text", this.text == null ? "" : this.text);
        tag.putInt("textColor", this.textColor);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        this.loadAdditional(tag, provider);
    }
}

