/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadsignsmod.trafficlight.client;

import com.mojang.blaze3d.systems.RenderSystem;
import de.sarocesch.sarosroadsignsmod.block.entity.TrafficLightControlerBlockEntity;
import de.sarocesch.sarosroadsignsmod.trafficlight.client.TrafficLightControllerMenu;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class TrafficLightControllerScreen
extends AbstractContainerScreen<TrafficLightControllerMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"saros_road_signs_mod", (String)"textures/gui/traffic_light_controller.png");
    private List<ConnectedLight> connectedLights = new ArrayList<ConnectedLight>();
    private int scrollOffset = 0;

    public TrafficLightControllerScreen(TrafficLightControllerMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    protected void init() {
        super.init();
        this.loadConnectedLights();
        if (this.connectedLights.size() > 5) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u25b2"), btn -> this.scrollUp()).bounds(this.leftPos + 160, this.topPos + 20, 12, 12).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u25bc"), btn -> this.scrollDown()).bounds(this.leftPos + 160, this.topPos + 140, 12, 12).build());
        }
        this.updateLightButtons();
    }

    private void loadConnectedLights() {
        this.connectedLights.clear();
        TrafficLightControlerBlockEntity be = ((TrafficLightControllerMenu)this.menu).getBlockEntity();
        if (be == null) {
            return;
        }
        CompoundTag nbt = be.getPersistentData();
        for (String key : nbt.getAllKeys()) {
            String value;
            if (!key.startsWith("NewTrafficLight_") || (value = nbt.getString(key)).isEmpty()) continue;
            try {
                String[] coords = value.split(",");
                if (coords.length != 3) continue;
                int x = Integer.parseInt(coords[0]);
                int y = Integer.parseInt(coords[1]);
                int z = Integer.parseInt(coords[2]);
                boolean reversed = key.endsWith("_reversed");
                this.connectedLights.add(new ConnectedLight(x, y, z, reversed));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private void updateLightButtons() {
        int index;
        this.children().removeIf(widget -> widget instanceof Button && ((Button)widget).getMessage().getString().contains("Light"));
        int visibleCount = Math.min(5, this.connectedLights.size() - this.scrollOffset);
        for (int i = 0; i < visibleCount && (index = this.scrollOffset + i) < this.connectedLights.size(); ++i) {
            ConnectedLight light = this.connectedLights.get(index);
            int yPos = this.topPos + 20 + i * 24;
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)("Light " + (index + 1) + ": " + light.x + "," + light.y + "," + light.z)), btn -> this.selectLight(index)).bounds(this.leftPos + 10, yPos, 140, 20).build());
        }
    }

    private void scrollUp() {
        if (this.scrollOffset > 0) {
            --this.scrollOffset;
            this.updateLightButtons();
        }
    }

    private void scrollDown() {
        if (this.scrollOffset < this.connectedLights.size() - 5) {
            ++this.scrollOffset;
            this.updateLightButtons();
        }
    }

    private void selectLight(int index) {
        ConnectedLight light = this.connectedLights.get(index);
        if (this.minecraft != null && this.minecraft.player != null) {
            this.minecraft.player.displayClientMessage((Component)Component.literal((String)("Selected light at " + light.x + "," + light.y + "," + light.z)), false);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.fill(this.leftPos, this.topPos, this.leftPos + this.imageWidth, this.topPos + this.imageHeight, -13948117);
        guiGraphics.fill(this.leftPos, this.topPos, this.leftPos + this.imageWidth, this.topPos + 16, -15066598);
        RenderSystem.disableBlend();
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, 8, 6, 0xFFFFFF, false);
        guiGraphics.drawString(this.font, (Component)Component.literal((String)("Connected Lights: " + this.connectedLights.size())), 8, this.imageHeight - 96 + 2, 0xAAAAAA, false);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.fill(0, 0, this.width, this.height, -1072689136);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private static class ConnectedLight {
        final int x;
        final int y;
        final int z;
        final boolean reversed;

        ConnectedLight(int x, int y, int z, boolean reversed) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.reversed = reversed;
        }
    }
}

