/*
 * Decompiled with CFR 0.152.
 */
package com.github.tltbl.advnpcs.listeners;

import com.github.tltbl.advnpcs.AdvNPCs;
import com.github.tltbl.advnpcs.npc.NPC;
import com.github.tltbl.advnpcs.util.NMSHelper;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class NPCListener
implements Listener {
    private final AdvNPCs plugin;

    public NPCListener(AdvNPCs plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        for (NPC npc : this.plugin.getNpcManager().getNpcs().values()) {
            this.plugin.getNpcManager().removeNPC(npc.getUuid());
            this.plugin.getNpcManager().spawnNPC(npc);
        }
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (event.getRightClicked() instanceof Player) {
            Player clicked = (Player)event.getRightClicked();
            for (NPC npc : this.plugin.getNpcManager().getNpcs().values()) {
                if (npc.getServerPlayer() == null || !NMSHelper.getEntityPlayer(npc.getServerPlayer()).equals(clicked) || !npc.getTrigger().equals("right_click")) continue;
                this.handleInteraction(npc, event.getPlayer());
            }
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getEntity() instanceof Player && event.getDamager() instanceof Player) {
            Player clicked = (Player)event.getEntity();
            Player damager = (Player)event.getDamager();
            for (NPC npc : this.plugin.getNpcManager().getNpcs().values()) {
                if (npc.getServerPlayer() == null || !NMSHelper.getEntityPlayer(npc.getServerPlayer()).equals(clicked) || !npc.getTrigger().equals("left_click")) continue;
                this.handleInteraction(npc, damager);
            }
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        for (NPC npc : this.plugin.getNpcManager().getNpcs().values()) {
            if (npc.isLookAtPlayer() && npc.getServerPlayer() != null && npc.getLocation().getWorld().equals((Object)player.getWorld()) && npc.getLocation().distance(player.getLocation()) < 10.0) {
                Object serverPlayer = npc.getServerPlayer();
                try {
                    Location loc = (Location)NMSHelper.getEntityPlayer(serverPlayer).getClass().getMethod("getLocation", new Class[0]).invoke(NMSHelper.getEntityPlayer(serverPlayer), new Object[0]);
                    loc.setDirection(player.getLocation().subtract(loc).toVector());
                    byte yaw = (byte)(loc.getYaw() * 256.0f / 360.0f);
                    byte pitch = (byte)(loc.getPitch() * 256.0f / 360.0f);
                    Object headPacket = NMSHelper.getClientboundRotateHeadPacket(serverPlayer, yaw);
                    Object teleportPacket = NMSHelper.getClientboundTeleportEntityPacket(serverPlayer);
                    for (Player p : Bukkit.getOnlinePlayers()) {
                        Object playerConnection = NMSHelper.getPlayerConnectionFromCraftPlayer(NMSHelper.getCraftPlayerHandle(p));
                        NMSHelper.sendPacketToPlayerConnection(playerConnection, headPacket);
                        NMSHelper.sendPacketToPlayerConnection(playerConnection, teleportPacket);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!npc.getTrigger().equals("proximity") || npc.getServerPlayer() == null || !npc.getLocation().getWorld().equals((Object)player.getWorld()) || !(npc.getLocation().distance(player.getLocation()) < 5.0)) continue;
            this.handleInteraction(npc, player);
        }
    }

    private void handleInteraction(NPC npc, Player player) {
        for (String text : npc.getText()) {
            player.sendMessage(text);
        }
        for (String command : npc.getCommands()) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replace("%player%", player.getName()));
        }
    }
}

