/*
 * Decompiled with CFR 0.152.
 */
package com.github.tltbl.advnpcs.npc;

import com.github.tltbl.advnpcs.skins.Skin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class NPC
implements ConfigurationSerializable {
    private final UUID uuid;
    private String name;
    private Location location;
    private EntityType entityType;
    private Skin skin;
    private String skinUsername;
    private UUID owner;
    private ItemStack[] armor = new ItemStack[4];
    private ItemStack mainHand;
    private boolean lookAtPlayer;
    private List<Location> path = new ArrayList<Location>();
    private UUID following;
    private UUID guardTarget;
    private int range = 10;
    private List<String> text = new ArrayList<String>();
    private List<String> commands = new ArrayList<String>();
    private String trigger = "right_click";
    private boolean gravity = true;
    private boolean sitting;
    private transient Object serverPlayer;

    public NPC(UUID uuid, String name, Location location, EntityType entityType) {
        this.uuid = uuid;
        this.name = name;
        this.location = location;
        this.entityType = entityType;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public Skin getSkin() {
        return this.skin;
    }

    public void setSkin(Skin skin) {
        this.skin = skin;
    }

    public String getSkinUsername() {
        return this.skinUsername;
    }

    public void setSkinUsername(String skinUsername) {
        this.skinUsername = skinUsername;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public ItemStack[] getArmor() {
        return this.armor;
    }

    public void setArmor(ItemStack[] armor) {
        this.armor = armor;
    }

    public ItemStack getMainHand() {
        return this.mainHand;
    }

    public void setMainHand(ItemStack mainHand) {
        this.mainHand = mainHand;
    }

    public boolean isLookAtPlayer() {
        return this.lookAtPlayer;
    }

    public void setLookAtPlayer(boolean lookAtPlayer) {
        this.lookAtPlayer = lookAtPlayer;
    }

    public List<Location> getPath() {
        return this.path;
    }

    public void setPath(List<Location> path) {
        this.path = path;
    }

    public UUID getFollowing() {
        return this.following;
    }

    public void setFollowing(UUID following) {
        this.following = following;
    }

    public UUID getGuardTarget() {
        return this.guardTarget;
    }

    public void setGuardTarget(UUID guardTarget) {
        this.guardTarget = guardTarget;
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int range) {
        this.range = range;
    }

    public List<String> getText() {
        return this.text;
    }

    public void setText(List<String> text) {
        this.text = text;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public void setCommands(List<String> commands) {
        this.commands = commands;
    }

    public String getTrigger() {
        return this.trigger;
    }

    public void setTrigger(String trigger) {
        this.trigger = trigger;
    }

    public boolean hasGravity() {
        return this.gravity;
    }

    public void setGravity(boolean gravity) {
        this.gravity = gravity;
    }

    public boolean isSitting() {
        return this.sitting;
    }

    public void setSitting(boolean sitting) {
        this.sitting = sitting;
    }

    public Object getServerPlayer() {
        return this.serverPlayer;
    }

    public void setServerPlayer(Object serverPlayer) {
        this.serverPlayer = serverPlayer;
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("uuid", this.uuid.toString());
        data.put("name", this.name);
        data.put("location", this.location);
        data.put("entityType", this.entityType.name());
        if (this.skin != null) {
            data.put("skin.value", this.skin.getValue());
            data.put("skin.signature", this.skin.getSignature());
        }
        if (this.skinUsername != null) {
            data.put("skin.username", this.skinUsername);
        }
        if (this.owner != null) {
            data.put("owner", this.owner.toString());
        }
        data.put("armor", this.armor);
        data.put("mainHand", this.mainHand);
        data.put("lookAtPlayer", this.lookAtPlayer);
        data.put("path", this.path);
        data.put("sitting", this.sitting);
        data.put("gravity", this.gravity);
        data.put("text", this.text);
        data.put("commands", this.commands);
        data.put("trigger", this.trigger);
        if (this.guardTarget != null) {
            data.put("guardTarget", this.guardTarget.toString());
        }
        data.put("range", this.range);
        if (this.following != null) {
            data.put("following", this.following.toString());
        }
        return data;
    }

    public static NPC deserialize(Map<String, Object> data) {
        UUID uuid = UUID.fromString((String)data.get("uuid"));
        String name = (String)data.get("name");
        Location location = (Location)data.get("location");
        EntityType entityType = EntityType.valueOf((String)((String)data.get("entityType")));
        NPC npc = new NPC(uuid, name, location, entityType);
        if (data.containsKey("skin.value")) {
            String value = (String)data.get("skin.value");
            String signature = (String)data.get("skin.signature");
            npc.setSkin(new Skin(value, signature));
        }
        if (data.containsKey("skin.username")) {
            npc.setSkinUsername((String)data.get("skin.username"));
        }
        if (data.containsKey("owner")) {
            npc.setOwner(UUID.fromString((String)data.get("owner")));
        }
        if (data.containsKey("armor")) {
            npc.setArmor(((List)data.get("armor")).toArray(new ItemStack[0]));
        }
        if (data.containsKey("mainHand")) {
            npc.setMainHand((ItemStack)data.get("mainHand"));
        }
        if (data.containsKey("lookAtPlayer")) {
            npc.setLookAtPlayer((Boolean)data.get("lookAtPlayer"));
        }
        if (data.containsKey("path")) {
            npc.setPath((List)data.get("path"));
        }
        if (data.containsKey("following")) {
            npc.setFollowing(UUID.fromString((String)data.get("following")));
        }
        if (data.containsKey("sitting")) {
            npc.setSitting((Boolean)data.get("sitting"));
        }
        if (data.containsKey("gravity")) {
            npc.setGravity((Boolean)data.get("gravity"));
        }
        if (data.containsKey("text")) {
            npc.setText((List)data.get("text"));
        }
        if (data.containsKey("commands")) {
            npc.setCommands((List)data.get("commands"));
        }
        if (data.containsKey("trigger")) {
            npc.setTrigger((String)data.get("trigger"));
        }
        if (data.containsKey("guardTarget")) {
            npc.setGuardTarget(UUID.fromString((String)data.get("guardTarget")));
        }
        if (data.containsKey("range")) {
            npc.setRange((Integer)data.get("range"));
        }
        return npc;
    }
}

