/*
 * Decompiled with CFR 0.152.
 */
package com.github.tltbl.advnpcs.npc;

import com.github.tltbl.advnpcs.AdvNPCs;
import com.github.tltbl.advnpcs.npc.NPC;
import com.github.tltbl.advnpcs.npc.NPCSpawner;
import com.github.tltbl.advnpcs.util.NMSHelper;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class NPCManager {
    private final AdvNPCs plugin;
    private final Map<UUID, NPC> npcMap = new HashMap<UUID, NPC>();
    private File npcFile;
    private FileConfiguration npcConfig;

    public NPCManager(AdvNPCs plugin) {
        this.plugin = plugin;
        this.npcFile = new File(plugin.getDataFolder(), "npcs.yml");
        this.npcConfig = YamlConfiguration.loadConfiguration((File)this.npcFile);
    }

    public NPC createNPC(Player player, String name) {
        UUID npcId = UUID.randomUUID();
        Location location = player.getLocation();
        NPC npc = new NPC(npcId, name, location, EntityType.PLAYER);
        this.spawnNPC(npc);
        this.npcMap.put(npcId, npc);
        return npc;
    }

    public void spawnNPC(NPC npc) {
        Object serverPlayer = NPCSpawner.spawn(npc);
        npc.setServerPlayer(serverPlayer);
    }

    public void removeNPC(UUID npcId) {
        NPC npc = this.npcMap.get(npcId);
        if (npc != null && npc.getServerPlayer() != null) {
            Object serverPlayer = npc.getServerPlayer();
            for (Player player : Bukkit.getOnlinePlayers()) {
                Object playerConnection = NMSHelper.getPlayerConnectionFromCraftPlayer(NMSHelper.getCraftPlayerHandle(player));
                NMSHelper.sendPacketToPlayerConnection(playerConnection, NMSHelper.getClientboundPlayerInfoRemovePacket(Collections.singletonList((UUID)NMSHelper.getEntityUUID(serverPlayer))));
                NMSHelper.sendPacketToPlayerConnection(playerConnection, NMSHelper.getClientboundRemoveEntitiesPacket((Integer)NMSHelper.getEntityId(serverPlayer)));
            }
        }
    }

    public void despawnNPC(UUID npcId) {
        NPC npc = this.npcMap.get(npcId);
        if (npc != null && npc.getServerPlayer() != null) {
            Object serverPlayer = npc.getServerPlayer();
            for (Player player : Bukkit.getOnlinePlayers()) {
                Object playerConnection = NMSHelper.getPlayerConnectionFromCraftPlayer(NMSHelper.getCraftPlayerHandle(player));
                NMSHelper.sendPacketToPlayerConnection(playerConnection, NMSHelper.getClientboundPlayerInfoRemovePacket(Collections.singletonList((UUID)NMSHelper.getEntityUUID(serverPlayer))));
                NMSHelper.sendPacketToPlayerConnection(playerConnection, NMSHelper.getClientboundRemoveEntitiesPacket((Integer)NMSHelper.getEntityId(serverPlayer)));
            }
            npc.setServerPlayer(null);
        }
    }

    public void respawnNPC(UUID npcId) {
        NPC npc = this.npcMap.get(npcId);
        if (npc != null) {
            if (npc.getServerPlayer() != null) {
                this.despawnNPC(npcId);
            }
            this.spawnNPC(npc);
        }
    }

    public void updateGravity(NPC npc) {
        Object serverPlayer = npc.getServerPlayer();
        if (serverPlayer == null) {
            return;
        }
        NMSHelper.setNoGravity(serverPlayer, !npc.hasGravity());
    }

    public void updatePose(NPC npc) {
        Object serverPlayer = npc.getServerPlayer();
        if (serverPlayer == null) {
            return;
        }
        Object pose = npc.isSitting() ? NMSHelper.getEnumPose("SITTING") : NMSHelper.getEnumPose("STANDING");
        NMSHelper.setPose(serverPlayer, pose);
    }

    public void deleteNPC(UUID npcId) {
        this.removeNPC(npcId);
        this.npcMap.remove(npcId);
    }

    public NPC getNPC(UUID npcId) {
        return this.npcMap.get(npcId);
    }

    public Map<UUID, NPC> getNpcs() {
        return this.npcMap;
    }

    public void loadNPCs() {
        if (!this.npcFile.exists()) {
            return;
        }
        this.npcConfig.getKeys(false).forEach(key -> {
            NPC npc = (NPC)this.npcConfig.get(key);
            if (npc != null) {
                this.npcMap.put(npc.getUuid(), npc);
                this.spawnNPC(npc);
            }
        });
    }

    public void saveNPCs() {
        this.npcConfig.getKeys(false).forEach(key -> this.npcConfig.set(key, null));
        this.npcMap.forEach((uuid, npc) -> this.npcConfig.set(uuid.toString(), npc));
        try {
            this.npcConfig.save(this.npcFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

