/*
 * Decompiled with CFR 0.152.
 */
package com.github.tltbl.advnpcs;

import com.github.tltbl.advnpcs.commands.CommandManager;
import com.github.tltbl.advnpcs.listeners.NPCListener;
import com.github.tltbl.advnpcs.npc.NPC;
import com.github.tltbl.advnpcs.npc.NPCManager;
import com.github.tltbl.advnpcs.pathfinding.PathManager;
import com.github.tltbl.advnpcs.skins.Skin;
import com.github.tltbl.advnpcs.skins.SkinManager;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.plugin.java.JavaPlugin;

public class AdvNPCs
extends JavaPlugin {
    private NPCManager npcManager;
    private SkinManager skinManager;
    private PathManager pathManager;

    public void onEnable() {
        ConfigurationSerialization.registerClass(NPC.class);
        ConfigurationSerialization.registerClass(Skin.class);
        this.npcManager = new NPCManager(this);
        this.skinManager = new SkinManager(this);
        this.pathManager = new PathManager(this);
        this.npcManager.loadNPCs();
        this.skinManager.loadSkins();
        new NPCListener(this);
        CommandManager commandManager = new CommandManager(this);
        this.getCommand("npc").setExecutor((CommandExecutor)commandManager);
        this.getCommand("npc").setTabCompleter((TabCompleter)commandManager);
        this.getLogger().info("AdvNPCs has been enabled!");
    }

    public void onDisable() {
        if (this.npcManager != null) {
            this.npcManager.saveNPCs();
        }
        if (this.skinManager != null) {
            this.skinManager.saveSkins();
        }
        this.getLogger().info("AdvNPCs has been disabled!");
    }

    public NPCManager getNpcManager() {
        return this.npcManager;
    }

    public SkinManager getSkinManager() {
        return this.skinManager;
    }

    public PathManager getPathManager() {
        return this.pathManager;
    }
}

