/*
 * Decompiled with CFR 0.152.
 */
package com.github.tltbl.advnpcs.commands;

import com.github.tltbl.advnpcs.AdvNPCs;
import com.github.tltbl.advnpcs.gui.NPCEquipGUI;
import com.github.tltbl.advnpcs.npc.NPC;
import com.github.tltbl.advnpcs.skins.Skin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class CommandManager
implements CommandExecutor,
TabCompleter {
    private final AdvNPCs plugin;
    private final Map<UUID, UUID> selectedNpc = new HashMap<UUID, UUID>();

    public CommandManager(AdvNPCs plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.sendHelpMessage(player);
            return true;
        }
        String subCommand = args[0].toLowerCase();
        if (subCommand.equals("create")) {
            if (args.length < 2) {
                player.sendMessage("Usage: /npc create <name>");
                return true;
            }
            String name = args[1];
            this.plugin.getNpcManager().createNPC(player, name);
            player.sendMessage("NPC created with name: " + name);
        } else if (subCommand.equals("select")) {
            NPC nearestNpc = null;
            double nearestDistance = Double.MAX_VALUE;
            for (NPC npc : this.plugin.getNpcManager().getNpcs().values()) {
                double distance;
                if (!npc.getLocation().getWorld().equals((Object)player.getWorld()) || !((distance = npc.getLocation().distance(player.getLocation())) < nearestDistance)) continue;
                nearestDistance = distance;
                nearestNpc = npc;
            }
            if (nearestNpc != null) {
                this.selectedNpc.put(player.getUniqueId(), nearestNpc.getUuid());
                player.sendMessage("Selected NPC: " + nearestNpc.getName());
            } else {
                player.sendMessage("No NPCs found.");
            }
        } else if (subCommand.equals("skin")) {
            if (args.length < 2) {
                player.sendMessage("Usage: /npc skin <player>");
                return true;
            }
            UUID npcId = this.selectedNpc.get(player.getUniqueId());
            if (npcId == null) {
                player.sendMessage("You must select an NPC first.");
                return true;
            }
            NPC npc = this.plugin.getNpcManager().getNPC(npcId);
            if (npc == null) {
                player.sendMessage("The selected NPC no longer exists.");
                return true;
            }
            String skinName = args[1];
            this.plugin.getSkinManager().getSkin(skinName, skin -> {
                if (skin == null) {
                    player.sendMessage("Could not fetch skin for " + skinName);
                    return;
                }
                npc.setSkin((Skin)skin);
                this.plugin.getNpcManager().removeNPC(npc.getUuid());
                this.plugin.getNpcManager().spawnNPC(npc);
                player.sendMessage("Skin updated for " + npc.getName());
            });
        } else if (subCommand.equals("remove")) {
            UUID npcId = this.selectedNpc.get(player.getUniqueId());
            if (npcId == null) {
                player.sendMessage("You must select an NPC first.");
                return true;
            }
            NPC npc = this.plugin.getNpcManager().getNPC(npcId);
            if (npc == null) {
                player.sendMessage("The selected NPC no longer exists.");
                return true;
            }
            this.plugin.getNpcManager().deleteNPC(npcId);
            this.selectedNpc.remove(player.getUniqueId());
            player.sendMessage("NPC removed.");
        } else if (subCommand.equals("name")) {
            if (args.length < 2) {
                player.sendMessage("Usage: /npc name <name>");
                return true;
            }
            UUID npcId = this.selectedNpc.get(player.getUniqueId());
            if (npcId == null) {
                player.sendMessage("You must select an NPC first.");
                return true;
            }
            NPC npc = this.plugin.getNpcManager().getNPC(npcId);
            if (npc == null) {
                player.sendMessage("The selected NPC no longer exists.");
                return true;
            }
            String newName = args[1];
            npc.setName(newName);
            this.plugin.getNpcManager().removeNPC(npc.getUuid());
            this.plugin.getNpcManager().spawnNPC(npc);
            player.sendMessage("NPC name updated to: " + newName);
        } else if (subCommand.equals("equip")) {
            UUID npcId = this.selectedNpc.get(player.getUniqueId());
            if (npcId == null) {
                player.sendMessage("You must select an NPC first.");
                return true;
            }
            NPC npc = this.plugin.getNpcManager().getNPC(npcId);
            if (npc == null) {
                player.sendMessage("The selected NPC no longer exists.");
                return true;
            }
            NPCEquipGUI gui = new NPCEquipGUI(this.plugin, npc);
            gui.open(player);
        } else if (subCommand.equals("look")) {
            UUID npcId = this.selectedNpc.get(player.getUniqueId());
            if (npcId == null) {
                player.sendMessage("You must select an NPC first.");
                return true;
            }
            NPC npc = this.plugin.getNpcManager().getNPC(npcId);
            if (npc == null) {
                player.sendMessage("The selected NPC no longer exists.");
                return true;
            }
            npc.setLookAtPlayer(!npc.isLookAtPlayer());
            player.sendMessage("NPC look at player toggled to: " + npc.isLookAtPlayer());
        } else if (subCommand.equals("path")) {
            if (args.length < 2) {
                player.sendMessage("Usage: /npc path <add|start|stop|clear>");
                return true;
            }
            UUID npcId = this.selectedNpc.get(player.getUniqueId());
            if (npcId == null) {
                player.sendMessage("You must select an NPC first.");
                return true;
            }
            NPC npc = this.plugin.getNpcManager().getNPC(npcId);
            if (npc == null) {
                player.sendMessage("The selected NPC no longer exists.");
                return true;
            }
            String pathCommand = args[1].toLowerCase();
            if (pathCommand.equals("add")) {
                npc.getPath().add(player.getLocation());
                player.sendMessage("Added location to path.");
            } else if (pathCommand.equals("start")) {
                this.plugin.getPathManager().startPath(npc);
                player.sendMessage("NPC started path.");
            } else if (pathCommand.equals("stop")) {
                this.plugin.getPathManager().stopPath(npc);
                player.sendMessage("NPC stopped path.");
            } else if (pathCommand.equals("clear")) {
                npc.getPath().clear();
                player.sendMessage("NPC path cleared.");
            }
        } else if (subCommand.equals("debug")) {
            player.sendMessage("Debug command not yet implemented.");
        } else if (subCommand.equals("reload")) {
            this.plugin.reloadConfig();
            this.plugin.getNpcManager().loadNPCs();
            this.plugin.getSkinManager().loadSkins();
            player.sendMessage("Plugin reloaded.");
        } else if (subCommand.equals("save")) {
            this.plugin.getNpcManager().saveNPCs();
            this.plugin.getSkinManager().saveSkins();
            player.sendMessage("NPCs and skins saved.");
        } else if (subCommand.equals("info")) {
            this.handleInfoCommand(player, args);
        } else if (subCommand.equals("list")) {
            this.handleListCommand(player, args);
        } else if (subCommand.equals("guard")) {
            this.handleGuardCommand(player, args);
        } else if (subCommand.equals("range")) {
            this.handleRangeCommand(player, args);
        } else if (subCommand.equals("text")) {
            this.handleTextCommand(player, args);
        } else if (subCommand.equals("cmd")) {
            this.handleCmdCommand(player, args);
        } else if (subCommand.equals("trigger")) {
            this.handleTriggerCommand(player, args);
        } else if (subCommand.equals("gravity")) {
            UUID npcId = this.selectedNpc.get(player.getUniqueId());
            if (npcId == null) {
                player.sendMessage("You must select an NPC first.");
                return true;
            }
            NPC npc = this.plugin.getNpcManager().getNPC(npcId);
            if (npc == null) {
                player.sendMessage("The selected NPC no longer exists.");
                return true;
            }
            npc.setGravity(true);
            this.plugin.getNpcManager().updateGravity(npc);
            player.sendMessage("NPC now has gravity.");
        } else if (subCommand.equals("fly")) {
            UUID npcId = this.selectedNpc.get(player.getUniqueId());
            if (npcId == null) {
                player.sendMessage("You must select an NPC first.");
                return true;
            }
            NPC npc = this.plugin.getNpcManager().getNPC(npcId);
            if (npc == null) {
                player.sendMessage("The selected NPC no longer exists.");
                return true;
            }
            npc.setGravity(false);
            this.plugin.getNpcManager().updateGravity(npc);
            player.sendMessage("NPC can now fly.");
        } else if (subCommand.equals("sit")) {
            UUID npcId = this.selectedNpc.get(player.getUniqueId());
            if (npcId == null) {
                player.sendMessage("You must select an NPC first.");
                return true;
            }
            NPC npc = this.plugin.getNpcManager().getNPC(npcId);
            if (npc == null) {
                player.sendMessage("The selected NPC no longer exists.");
                return true;
            }
            npc.setSitting(true);
            this.plugin.getNpcManager().updatePose(npc);
            player.sendMessage("NPC is now sitting.");
        } else if (subCommand.equals("stand")) {
            UUID npcId = this.selectedNpc.get(player.getUniqueId());
            if (npcId == null) {
                player.sendMessage("You must select an NPC first.");
                return true;
            }
            NPC npc = this.plugin.getNpcManager().getNPC(npcId);
            if (npc == null) {
                player.sendMessage("The selected NPC no longer exists.");
                return true;
            }
            npc.setSitting(false);
            this.plugin.getNpcManager().updatePose(npc);
            player.sendMessage("NPC is now standing.");
        } else if (subCommand.equals("follow")) {
            if (args.length < 2) {
                player.sendMessage("Usage: /npc follow <player|off>");
                return true;
            }
            UUID npcId = this.selectedNpc.get(player.getUniqueId());
            if (npcId == null) {
                player.sendMessage("You must select an NPC first.");
                return true;
            }
            NPC npc = this.plugin.getNpcManager().getNPC(npcId);
            if (npc == null) {
                player.sendMessage("The selected NPC no longer exists.");
                return true;
            }
            if (args[1].equalsIgnoreCase("off")) {
                npc.setFollowing(null);
                this.plugin.getPathManager().stopPath(npc);
                player.sendMessage("NPC is no longer following.");
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                player.sendMessage("Player not found.");
                return true;
            }
            npc.setFollowing(target.getUniqueId());
            this.plugin.getPathManager().startFollowing(npc, target.getUniqueId());
            player.sendMessage("NPC is now following " + target.getName());
        }
        return true;
    }

    private void sendHelpMessage(Player player) {
        player.sendMessage("--- AdvNPCs Help ---");
        player.sendMessage("/npc create <name> - Creates an NPC.");
        player.sendMessage("/npc remove - Removes the selected NPC.");
        player.sendMessage("/npc select - Selects the nearest NPC.");
        player.sendMessage("/npc skin <player> - Sets the skin of the selected NPC.");
        player.sendMessage("/npc name <name> - Sets the name of the selected NPC.");
        player.sendMessage("/npc equip - Opens the equipment GUI for the selected NPC.");
        player.sendMessage("/npc look - Toggles whether the NPC looks at players.");
        player.sendMessage("/npc path add - Adds a point to the NPC's path.");
        player.sendMessage("/npc path start - Starts the NPC's path.");
        player.sendMessage("/npc path stop - Stops the NPC's path.");
        player.sendMessage("/npc path clear - Clears the NPC's path.");
        player.sendMessage("/npc follow <player> - Makes the NPC follow a player.");
        player.sendMessage("/npc sit - Makes the selected NPC sit.");
        player.sendMessage("/npc stand - Makes the selected NPC stand.");
        player.sendMessage("/npc gravity - Enables gravity for the selected NPC.");
        player.sendMessage("/npc fly - Disables gravity for the selected NPC (allows flying).");
        player.sendMessage("/npc text add <message> - Adds a dialogue line to the selected NPC.");
        player.sendMessage("/npc text list - Lists dialogue lines of the selected NPC.");
        player.sendMessage("/npc text clear - Clears dialogue lines of the selected NPC.");
        player.sendMessage("/npc text remove <index> - Removes a specific dialogue line.");
        player.sendMessage("/npc cmdadd <command> - Adds a command to be run on interaction.");
        player.sendMessage("/npc cmdremove <index> - Removes a specific command.");
        player.sendMessage("/npc cmdclear - Clears all commands.");
        player.sendMessage("/npc trigger <type> - Sets interaction trigger (right_click, left_click, proximity).");
        player.sendMessage("/npc guard <player|off> - Makes the NPC guard a player or stops guarding.");
        player.sendMessage("/npc range <blocks> - Sets the guard/follow range.");
        player.sendMessage("/npc list [page] - Lists all NPCs.");
        player.sendMessage("/npc info - Shows detailed info about the selected NPC.");
        player.sendMessage("/npc save - Forces saving of all NPCs and skins.");
        player.sendMessage("/npc reload - Reloads the plugin configuration, NPCs, and skins.");
        player.sendMessage("/npc debug - Toggles debug messages (not yet implemented).");
    }

    private void handleInfoCommand(Player player, String[] args) {
        UUID npcId = this.selectedNpc.get(player.getUniqueId());
        if (npcId == null) {
            player.sendMessage("You must select an NPC first.");
            return;
        }
        NPC npc = this.plugin.getNpcManager().getNPC(npcId);
        if (npc == null) {
            player.sendMessage("The selected NPC no longer exists.");
            return;
        }
        player.sendMessage("--- NPC Info ---");
        player.sendMessage("ID: " + String.valueOf(npc.getUuid()));
        player.sendMessage("Name: " + npc.getName());
        player.sendMessage("Location: " + npc.getLocation().getBlockX() + ", " + npc.getLocation().getBlockY() + ", " + npc.getLocation().getBlockZ());
        player.sendMessage("Entity Type: " + npc.getEntityType().name());
        player.sendMessage("Look at Player: " + npc.isLookAtPlayer());
        player.sendMessage("Sitting: " + npc.isSitting());
        player.sendMessage("Gravity: " + npc.hasGravity());
        player.sendMessage("Following: " + (npc.getFollowing() != null ? Bukkit.getPlayer((UUID)npc.getFollowing()).getName() : "None"));
        player.sendMessage("Guard Target: " + (npc.getGuardTarget() != null ? Bukkit.getPlayer((UUID)npc.getGuardTarget()).getName() : "None"));
        player.sendMessage("Range: " + npc.getRange());
        player.sendMessage("Trigger: " + npc.getTrigger());
        player.sendMessage("Text: " + npc.getText().size() + " lines");
        player.sendMessage("Commands: " + npc.getCommands().size() + " commands");
    }

    private void handleListCommand(Player player, String[] args) {
        player.sendMessage("--- NPC List ---");
        if (this.plugin.getNpcManager().getNpcs().isEmpty()) {
            player.sendMessage("No NPCs created yet.");
            return;
        }
        int page = 1;
        if (args.length > 1) {
            try {
                page = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                player.sendMessage("Invalid page number.");
                return;
            }
        }
        ArrayList<NPC> npcs = new ArrayList<NPC>(this.plugin.getNpcManager().getNpcs().values());
        int totalPages = (int)Math.ceil((double)npcs.size() / 10.0);
        if (page < 1 || page > totalPages) {
            player.sendMessage("Invalid page number. Total pages: " + totalPages);
            return;
        }
        int start = (page - 1) * 10;
        int end = Math.min(start + 10, npcs.size());
        for (int i = start; i < end; ++i) {
            NPC npc = (NPC)npcs.get(i);
            player.sendMessage("ID: " + npc.getUuid().toString().substring(0, 8) + ", Name: " + npc.getName() + ", Location: " + npc.getLocation().getBlockX() + ", " + npc.getLocation().getBlockY() + ", " + npc.getLocation().getBlockZ());
        }
        player.sendMessage("Page " + page + " of " + totalPages);
    }

    private void handleGuardCommand(Player player, String[] args) {
        UUID npcId = this.selectedNpc.get(player.getUniqueId());
        if (npcId == null) {
            player.sendMessage("You must select an NPC first.");
            return;
        }
        NPC npc = this.plugin.getNpcManager().getNPC(npcId);
        if (npc == null) {
            player.sendMessage("The selected NPC no longer exists.");
            return;
        }
        if (args.length < 2) {
            player.sendMessage("Usage: /npc guard <player|off>");
            return;
        }
        if (args[1].equalsIgnoreCase("off")) {
            npc.setGuardTarget(null);
            player.sendMessage("NPC is no longer guarding.");
            return;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            player.sendMessage("Player not found.");
            return;
        }
        npc.setGuardTarget(target.getUniqueId());
        player.sendMessage("NPC is now guarding " + target.getName());
    }

    private void handleRangeCommand(Player player, String[] args) {
        UUID npcId = this.selectedNpc.get(player.getUniqueId());
        if (npcId == null) {
            player.sendMessage("You must select an NPC first.");
            return;
        }
        NPC npc = this.plugin.getNpcManager().getNPC(npcId);
        if (npc == null) {
            player.sendMessage("The selected NPC no longer exists.");
            return;
        }
        if (args.length < 2) {
            player.sendMessage("Usage: /npc range <blocks>");
            return;
        }
        try {
            int range = Integer.parseInt(args[1]);
            npc.setRange(range);
            player.sendMessage("NPC range set to: " + range);
        }
        catch (NumberFormatException e) {
            player.sendMessage("Invalid range.");
        }
    }

    private void handleTextCommand(Player player, String[] args) {
        block9: {
            String textCommand;
            NPC npc;
            block11: {
                block10: {
                    block8: {
                        UUID npcId = this.selectedNpc.get(player.getUniqueId());
                        if (npcId == null) {
                            player.sendMessage("You must select an NPC first.");
                            return;
                        }
                        npc = this.plugin.getNpcManager().getNPC(npcId);
                        if (npc == null) {
                            player.sendMessage("The selected NPC no longer exists.");
                            return;
                        }
                        if (args.length < 2) {
                            player.sendMessage("Usage: /npc text <add|list|clear|remove>");
                            return;
                        }
                        textCommand = args[1].toLowerCase();
                        if (!textCommand.equals("add")) break block8;
                        if (args.length < 3) {
                            player.sendMessage("Usage: /npc text add <message>");
                            return;
                        }
                        String message = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
                        npc.getText().add(message);
                        player.sendMessage("Added text to NPC.");
                        break block9;
                    }
                    if (!textCommand.equals("list")) break block10;
                    player.sendMessage("--- NPC Text ---");
                    for (int i = 0; i < npc.getText().size(); ++i) {
                        player.sendMessage(i + ": " + npc.getText().get(i));
                    }
                    break block9;
                }
                if (!textCommand.equals("clear")) break block11;
                npc.getText().clear();
                player.sendMessage("Cleared NPC text.");
                break block9;
            }
            if (!textCommand.equals("remove")) break block9;
            if (args.length < 3) {
                player.sendMessage("Usage: /npc text remove <index>");
                return;
            }
            try {
                int index = Integer.parseInt(args[2]);
                npc.getText().remove(index);
                player.sendMessage("Removed text from NPC.");
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                player.sendMessage("Invalid index.");
            }
        }
    }

    private void handleCmdCommand(Player player, String[] args) {
        UUID npcId = this.selectedNpc.get(player.getUniqueId());
        if (npcId == null) {
            player.sendMessage("You must select an NPC first.");
            return;
        }
        NPC npc = this.plugin.getNpcManager().getNPC(npcId);
        if (npc == null) {
            player.sendMessage("The selected NPC no longer exists.");
            return;
        }
        if (args.length < 2) {
            player.sendMessage("Usage: /npc cmd <add|remove|clear>");
            return;
        }
        String cmdCommand = args[1].toLowerCase();
        if (cmdCommand.equals("add")) {
            if (args.length < 3) {
                player.sendMessage("Usage: /npc cmd add <command>");
                return;
            }
            String command = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
            npc.getCommands().add(command);
            player.sendMessage("Added command to NPC.");
        } else if (cmdCommand.equals("clear")) {
            npc.getCommands().clear();
            player.sendMessage("Cleared NPC commands.");
        } else if (cmdCommand.equals("remove")) {
            if (args.length < 3) {
                player.sendMessage("Usage: /npc cmd remove <index>");
                return;
            }
            try {
                int index = Integer.parseInt(args[2]);
                npc.getCommands().remove(index);
                player.sendMessage("Removed command from NPC.");
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                player.sendMessage("Invalid index.");
            }
        }
    }

    private void handleTriggerCommand(Player player, String[] args) {
        UUID npcId = this.selectedNpc.get(player.getUniqueId());
        if (npcId == null) {
            player.sendMessage("You must select an NPC first.");
            return;
        }
        NPC npc = this.plugin.getNpcManager().getNPC(npcId);
        if (npc == null) {
            player.sendMessage("The selected NPC no longer exists.");
            return;
        }
        if (args.length < 2) {
            player.sendMessage("Usage: /npc trigger <right_click|left_click|proximity>");
            return;
        }
        String trigger = args[1].toLowerCase();
        if (trigger.equals("right_click") || trigger.equals("left_click") || trigger.equals("proximity")) {
            npc.setTrigger(trigger);
            player.sendMessage("NPC trigger set to: " + trigger);
        } else {
            player.sendMessage("Invalid trigger type.");
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> subCommands = new ArrayList<String>();
            subCommands.add("create");
            subCommands.add("select");
            subCommands.add("skin");
            subCommands.add("remove");
            subCommands.add("name");
            subCommands.add("equip");
            subCommands.add("look");
            subCommands.add("path");
            subCommands.add("follow");
            subCommands.add("sit");
            subCommands.add("stand");
            subCommands.add("gravity");
            subCommands.add("fly");
            subCommands.add("text");
            subCommands.add("cmd");
            subCommands.add("trigger");
            subCommands.add("guard");
            subCommands.add("range");
            subCommands.add("list");
            subCommands.add("info");
            subCommands.add("save");
            subCommands.add("reload");
            subCommands.add("debug");
            return subCommands;
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("path")) {
                ArrayList<String> pathCommands = new ArrayList<String>();
                pathCommands.add("add");
                pathCommands.add("start");
                pathCommands.add("stop");
                pathCommands.add("clear");
                return pathCommands;
            }
            if (args[0].equalsIgnoreCase("guard")) {
                ArrayList<String> guardCommands = new ArrayList<String>();
                guardCommands.add("off");
                Bukkit.getOnlinePlayers().forEach(p -> guardCommands.add(p.getName()));
                return guardCommands;
            }
            if (args[0].equalsIgnoreCase("text")) {
                ArrayList<String> textCommands = new ArrayList<String>();
                textCommands.add("add");
                textCommands.add("list");
                textCommands.add("clear");
                textCommands.add("remove");
                return textCommands;
            }
            if (args[0].equalsIgnoreCase("cmd")) {
                ArrayList<String> cmdCommands = new ArrayList<String>();
                cmdCommands.add("add");
                cmdCommands.add("remove");
                cmdCommands.add("clear");
                return cmdCommands;
            }
            if (args[0].equalsIgnoreCase("trigger")) {
                ArrayList<String> triggerCommands = new ArrayList<String>();
                triggerCommands.add("right_click");
                triggerCommands.add("left_click");
                triggerCommands.add("proximity");
                return triggerCommands;
            }
            if (args[0].equalsIgnoreCase("follow")) {
                ArrayList<String> followCommands = new ArrayList<String>();
                followCommands.add("off");
                Bukkit.getOnlinePlayers().forEach(p -> followCommands.add(p.getName()));
                return followCommands;
            }
        }
        return null;
    }
}

