/*
 * Decompiled with CFR 0.152.
 */
package com.github.tltbl.advnpcs.gui;

import com.github.tltbl.advnpcs.AdvNPCs;
import com.github.tltbl.advnpcs.npc.NPC;
import com.github.tltbl.advnpcs.util.NMSHelper;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class NPCEquipGUI
implements Listener {
    private final AdvNPCs plugin;
    private final NPC npc;

    public NPCEquipGUI(AdvNPCs plugin, NPC npc) {
        this.plugin = plugin;
        this.npc = npc;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void open(Player player) {
        Inventory inventory = Bukkit.createInventory(null, (int)9, (String)("Equip NPC: " + this.npc.getName()));
        inventory.setItem(0, this.npc.getMainHand());
        inventory.setItem(5, this.npc.getArmor()[3]);
        inventory.setItem(6, this.npc.getArmor()[2]);
        inventory.setItem(7, this.npc.getArmor()[1]);
        inventory.setItem(8, this.npc.getArmor()[0]);
        player.openInventory(inventory);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getView().getTitle().equals("Equip NPC: " + this.npc.getName())) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        int slot = event.getRawSlot();
        if (slot < 9) {
            event.setCancelled(true);
            ItemStack cursor = event.getCursor();
            ItemStack current = event.getCurrentItem();
            if (cursor != null && cursor.getType() != Material.AIR) {
                event.setCurrentItem(cursor.clone());
                player.setItemOnCursor(current);
                ItemStack[] armor = this.npc.getArmor();
                switch (slot) {
                    case 0: {
                        this.npc.setMainHand(cursor);
                        break;
                    }
                    case 5: {
                        armor[3] = cursor;
                        break;
                    }
                    case 6: {
                        armor[2] = cursor;
                        break;
                    }
                    case 7: {
                        armor[1] = cursor;
                        break;
                    }
                    case 8: {
                        armor[0] = cursor;
                    }
                }
                this.npc.setArmor(armor);
                this.updateEquipment(this.npc);
            }
        }
    }

    private void updateEquipment(NPC npc) {
        Object serverPlayer = npc.getServerPlayer();
        if (serverPlayer == null) {
            return;
        }
        ArrayList<Object> equipment = new ArrayList<Object>();
        equipment.add(NMSHelper.getPair(NMSHelper.getEquipmentSlot("MAINHAND"), NMSHelper.getCraftItemStackAsNMSCopy(npc.getMainHand())));
        equipment.add(NMSHelper.getPair(NMSHelper.getEquipmentSlot("HEAD"), NMSHelper.getCraftItemStackAsNMSCopy(npc.getArmor()[3])));
        equipment.add(NMSHelper.getPair(NMSHelper.getEquipmentSlot("CHEST"), NMSHelper.getCraftItemStackAsNMSCopy(npc.getArmor()[2])));
        equipment.add(NMSHelper.getPair(NMSHelper.getEquipmentSlot("LEGS"), NMSHelper.getCraftItemStackAsNMSCopy(npc.getArmor()[1])));
        equipment.add(NMSHelper.getPair(NMSHelper.getEquipmentSlot("FEET"), NMSHelper.getCraftItemStackAsNMSCopy(npc.getArmor()[0])));
        Object packet = NMSHelper.getClientboundSetEquipmentPacket((Integer)NMSHelper.getEntityId(serverPlayer), equipment);
        for (Player p : Bukkit.getOnlinePlayers()) {
            Object playerConnection = NMSHelper.getPlayerConnectionFromCraftPlayer(NMSHelper.getCraftPlayerHandle(p));
            NMSHelper.sendPacketToPlayerConnection(playerConnection, packet);
        }
    }
}

