/*
 * Decompiled with CFR 0.152.
 */
package com.github.tltbl.advnpcs.pathfinding;

import com.github.tltbl.advnpcs.AdvNPCs;
import com.github.tltbl.advnpcs.npc.NPC;
import com.github.tltbl.advnpcs.util.NMSHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PathManager {
    private final AdvNPCs plugin;
    private final Map<UUID, BukkitRunnable> tasks = new HashMap<UUID, BukkitRunnable>();

    public PathManager(AdvNPCs plugin) {
        this.plugin = plugin;
    }

    public void startPath(final NPC npc) {
        if (this.tasks.containsKey(npc.getUuid())) {
            return;
        }
        BukkitRunnable task = new BukkitRunnable(){
            private int index = 0;

            public void run() {
                if (npc.getPath() == null || npc.getPath().isEmpty()) {
                    this.cancel();
                    return;
                }
                if (this.index >= npc.getPath().size()) {
                    this.index = 0;
                }
                Location target = npc.getPath().get(this.index);
                Object serverPlayer = npc.getServerPlayer();
                if (serverPlayer == null) {
                    this.cancel();
                    return;
                }
                Object navigation = NMSHelper.getEntityNavigation(serverPlayer);
                NMSHelper.navigationMoveTo(navigation, target.getX(), target.getY(), target.getZ(), 1.0);
                try {
                    if (((Location)NMSHelper.getEntityPlayer(serverPlayer).getClass().getMethod("getLocation", new Class[0]).invoke(NMSHelper.getEntityPlayer(serverPlayer), new Object[0])).distance(target) < 1.0) {
                        ++this.index;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        task.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        this.tasks.put(npc.getUuid(), task);
    }

    public void startFollowing(final NPC npc, final UUID targetUuid) {
        if (this.tasks.containsKey(npc.getUuid())) {
            return;
        }
        BukkitRunnable task = new BukkitRunnable(){

            public void run() {
                Player target = Bukkit.getPlayer((UUID)targetUuid);
                if (npc.getFollowing() == null || target == null || !target.isOnline()) {
                    this.cancel();
                    return;
                }
                Object serverPlayer = npc.getServerPlayer();
                if (serverPlayer == null) {
                    this.cancel();
                    return;
                }
                Object navigation = NMSHelper.getEntityNavigation(serverPlayer);
                NMSHelper.navigationMoveTo(navigation, target.getLocation().getX(), target.getLocation().getY(), target.getLocation().getZ(), 1.0);
            }
        };
        task.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        this.tasks.put(npc.getUuid(), task);
    }

    public void stopPath(NPC npc) {
        if (this.tasks.containsKey(npc.getUuid())) {
            this.tasks.get(npc.getUuid()).cancel();
            this.tasks.remove(npc.getUuid());
        }
    }
}

