/*
 * Decompiled with CFR 0.152.
 */
package com.github.tltbl.advnpcs.skins;

import com.github.tltbl.advnpcs.AdvNPCs;
import com.github.tltbl.advnpcs.skins.Skin;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class SkinManager {
    private final AdvNPCs plugin;
    private final Map<String, Skin> skinCache = new HashMap<String, Skin>();
    private File skinFile;
    private FileConfiguration skinConfig;

    public SkinManager(AdvNPCs plugin) {
        this.plugin = plugin;
        this.skinFile = new File(plugin.getDataFolder(), "skins.yml");
        this.skinConfig = YamlConfiguration.loadConfiguration((File)this.skinFile);
    }

    public void getSkin(String name, Consumer<Skin> callback) {
        if (this.skinCache.containsKey(name)) {
            callback.accept(this.skinCache.get(name));
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + name);
                InputStreamReader reader = new InputStreamReader(url.openStream());
                JsonObject json = JsonParser.parseReader(reader).getAsJsonObject();
                String uuid = json.get("id").getAsString();
                URL sessionUrl = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false");
                reader = new InputStreamReader(sessionUrl.openStream());
                json = JsonParser.parseReader(reader).getAsJsonObject();
                JsonObject properties = json.get("properties").getAsJsonArray().get(0).getAsJsonObject();
                String value = properties.get("value").getAsString();
                String signature = properties.get("signature").getAsString();
                Skin skin = new Skin(value, signature);
                this.skinCache.put(name, skin);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.accept(skin));
            }
            catch (Exception e) {
                e.printStackTrace();
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.accept(null));
            }
        });
    }

    public void loadSkins() {
        if (!this.skinFile.exists()) {
            return;
        }
        this.skinConfig.getKeys(false).forEach(key -> {
            Skin skin = (Skin)this.skinConfig.get(key);
            if (skin != null) {
                this.skinCache.put((String)key, skin);
            }
        });
    }

    public void saveSkins() {
        this.skinConfig.getKeys(false).forEach(key -> this.skinConfig.set(key, null));
        this.skinCache.forEach((name, skin) -> this.skinConfig.set(name, skin));
        try {
            this.skinConfig.save(this.skinFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

