/*
 * Decompiled with CFR 0.152.
 */
package com.github.tltbl.advnpcs.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class NMSHelper {
    private static String version;

    public static Class<?> getNMSClass(String className) {
        try {
            return Class.forName("net.minecraft.server." + version + "." + className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Class<?> getCraftBukkitClass(String className) {
        try {
            return Class.forName("org.bukkit.craftbukkit." + version + "." + className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getCraftPlayer(Player player) {
        try {
            return NMSHelper.getCraftBukkitClass("entity.CraftPlayer").getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getPlayerConnection(Player player) {
        try {
            Object craftPlayer = NMSHelper.getCraftPlayer(player);
            Field playerConnectionField = craftPlayer.getClass().getField("b");
            return playerConnectionField.get(craftPlayer);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void sendPacket(Player player, Object packet) {
        try {
            Object playerConnection = NMSHelper.getPlayerConnection(player);
            Method sendPacketMethod = playerConnection.getClass().getMethod("a", NMSHelper.getNMSClass("Packet"));
            sendPacketMethod.invoke(playerConnection, packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object getServerPlayer(UUID uuid) {
        try {
            Class<?> minecraftServerClass = NMSHelper.getNMSClass("MinecraftServer");
            Method getServerMethod = minecraftServerClass.getMethod("getServer", new Class[0]);
            Object minecraftServer = getServerMethod.invoke(null, new Object[0]);
            Class<?> playerListClass = NMSHelper.getNMSClass("PlayerList");
            Method getPlayerMethod = playerListClass.getMethod("getPlayer", new Class[0]);
            Object playerList = minecraftServerClass.getMethod("getPlayerList", new Class[0]).invoke(minecraftServer, new Object[0]);
            return getPlayerMethod.invoke(playerList, uuid);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getClientboundPlayerInfoRemovePacket(List<UUID> uuids) {
        try {
            Class<?> packetClass = NMSHelper.getNMSClass("ClientboundPlayerInfoRemovePacket");
            Constructor<?> constructor = packetClass.getConstructor(List.class);
            return constructor.newInstance(uuids);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getClientboundRemoveEntitiesPacket(int entityId) {
        try {
            Class<?> packetClass = NMSHelper.getNMSClass("ClientboundRemoveEntitiesPacket");
            Constructor<?> constructor = packetClass.getConstructor(Integer.TYPE);
            return constructor.newInstance(entityId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getClientboundRotateHeadPacket(Object entity, byte yaw) {
        try {
            Class<?> packetClass = NMSHelper.getNMSClass("ClientboundRotateHeadPacket");
            Constructor<?> constructor = packetClass.getConstructor(NMSHelper.getNMSClass("Entity"), Byte.TYPE);
            return constructor.newInstance(entity, yaw);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getClientboundTeleportEntityPacket(Object entity) {
        try {
            Class<?> packetClass = NMSHelper.getNMSClass("ClientboundTeleportEntityPacket");
            Constructor<?> constructor = packetClass.getConstructor(NMSHelper.getNMSClass("Entity"));
            return constructor.newInstance(entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getMinecraftServer() {
        try {
            return NMSHelper.getCraftBukkitClass("CraftServer").getMethod("getServer", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getServerLevel(World world) {
        try {
            return NMSHelper.getCraftBukkitClass("CraftWorld").getMethod("getHandle", new Class[0]).invoke((Object)world, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getGameProfile(UUID uuid, String name) {
        try {
            Class<?> gameProfileClass = Class.forName("com.mojang.authlib.GameProfile");
            Constructor<?> constructor = gameProfileClass.getConstructor(UUID.class, String.class);
            return constructor.newInstance(uuid, name);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getProperty(String name, String value, String signature) {
        try {
            Class<?> propertyClass = Class.forName("com.mojang.authlib.properties.Property");
            Constructor<?> constructor = propertyClass.getConstructor(String.class, String.class, String.class);
            return constructor.newInstance(name, value, signature);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getServerPlayerConstructor(Object minecraftServer, Object serverLevel, Object gameProfile) {
        try {
            Class<?> serverPlayerClass = NMSHelper.getNMSClass("ServerPlayer");
            Constructor<?> constructor = serverPlayerClass.getConstructor(NMSHelper.getNMSClass("MinecraftServer"), NMSHelper.getNMSClass("ServerLevel"), Class.forName("com.mojang.authlib.GameProfile"));
            return constructor.newInstance(minecraftServer, serverLevel, gameProfile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getEntityPlayer(Object serverPlayer) {
        try {
            return serverPlayer.getClass().getMethod("getBukkitEntity", new Class[0]).invoke(serverPlayer, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setEntityPosition(Object entity, double x, double y, double z) {
        try {
            Method setPosMethod = entity.getClass().getMethod("setPos", Double.TYPE, Double.TYPE, Double.TYPE);
            setPosMethod.invoke(entity, x, y, z);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object getPlayerList(Object minecraftServer) {
        try {
            return minecraftServer.getClass().getMethod("getPlayerList", new Class[0]).invoke(minecraftServer, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getPlayerListGetPlayer(Object playerList, UUID uuid) {
        try {
            return playerList.getClass().getMethod("getPlayer", new Class[0]).invoke(playerList, uuid);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getPlayerConnectionFromPlayer(Object serverPlayer) {
        try {
            Field playerConnectionField = serverPlayer.getClass().getField("connection");
            return playerConnectionField.get(serverPlayer);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void sendPacketToPlayer(Object playerConnection, Object packet) {
        try {
            Method sendPacketMethod = playerConnection.getClass().getMethod("send", NMSHelper.getNMSClass("Packet"));
            sendPacketMethod.invoke(playerConnection, packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object getEntityNavigation(Object entity) {
        try {
            return entity.getClass().getMethod("getNavigation", new Class[0]).invoke(entity, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void navigationMoveTo(Object navigation, double x, double y, double z, double speed) {
        try {
            Method moveToMethod = navigation.getClass().getMethod("moveTo", Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
            moveToMethod.invoke(navigation, x, y, z, speed);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setNoGravity(Object entity, boolean noGravity) {
        try {
            Method setNoGravityMethod = entity.getClass().getMethod("setNoGravity", Boolean.TYPE);
            setNoGravityMethod.invoke(entity, noGravity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object getEnumPose(String poseName) {
        try {
            Class<?> enumPoseClass = NMSHelper.getNMSClass("EnumPose");
            Field poseField = enumPoseClass.getField(poseName);
            return poseField.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setPose(Object entity, Object pose) {
        try {
            Method setPoseMethod = entity.getClass().getMethod("setPose", NMSHelper.getNMSClass("EnumPose"));
            setPoseMethod.invoke(entity, pose);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object getEquipmentSlot(String slotName) {
        try {
            Class<?> equipmentSlotClass = NMSHelper.getNMSClass("EnumItemSlot");
            try {
                equipmentSlotClass = Class.forName("net.minecraft.world.entity.EquipmentSlot");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Field slotField = equipmentSlotClass.getField(slotName);
            return slotField.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getPair(Object key, Object value) {
        try {
            Class<?> pairClass = Class.forName("com.mojang.datafixers.util.Pair");
            Constructor<?> constructor = pairClass.getConstructor(Object.class, Object.class);
            return constructor.newInstance(key, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getClientboundSetEquipmentPacket(int entityId, List<Object> equipment) {
        try {
            Class<?> packetClass = NMSHelper.getNMSClass("ClientboundSetEquipmentPacket");
            Constructor<?> constructor = packetClass.getConstructor(Integer.TYPE, List.class);
            return constructor.newInstance(entityId, equipment);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getCraftItemStackAsNMSCopy(ItemStack itemStack) {
        try {
            Class<?> craftItemStackClass = NMSHelper.getCraftBukkitClass("inventory.CraftItemStack");
            Method asNMSCopyMethod = craftItemStackClass.getMethod("asNMSCopy", ItemStack.class);
            return asNMSCopyMethod.invoke(null, itemStack);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getEntityId(Object entity) {
        try {
            Method getIdMethod = entity.getClass().getMethod("getId", new Class[0]);
            return getIdMethod.invoke(entity, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getEntityUUID(Object entity) {
        try {
            Method getUUIDMethod = entity.getClass().getMethod("getUUID", new Class[0]);
            return getUUIDMethod.invoke(entity, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getPlayerConnectionFromCraftPlayer(Object craftPlayer) {
        try {
            Field playerConnectionField = craftPlayer.getClass().getField("connection");
            return playerConnectionField.get(craftPlayer);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void sendPacketToPlayerConnection(Object playerConnection, Object packet) {
        try {
            Method sendPacketMethod = playerConnection.getClass().getMethod("send", NMSHelper.getNMSClass("Packet"));
            sendPacketMethod.invoke(playerConnection, packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object getGameProfileProperties(Object gameProfile) {
        try {
            Method getPropertiesMethod = gameProfile.getClass().getMethod("getProperties", new Class[0]);
            return getPropertiesMethod.invoke(gameProfile, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void putProperty(Object propertyMap, String key, Object property) {
        try {
            Method putMethod = propertyMap.getClass().getMethod("put", Object.class, Object.class);
            putMethod.invoke(propertyMap, key, property);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object getCraftPlayerHandle(Player player) {
        try {
            return player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getCraftWorldHandle(World world) {
        try {
            return world.getClass().getMethod("getHandle", new Class[0]).invoke((Object)world, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getMinecraftServerInstance() {
        try {
            return NMSHelper.getCraftBukkitClass("CraftServer").getMethod("getServer", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getClientboundPlayerInfoUpdatePacket(Object action, Object serverPlayer) {
        try {
            Class<?> packetClass = NMSHelper.getNMSClass("ClientboundPlayerInfoUpdatePacket");
            Class<?> actionEnumClass = NMSHelper.getNMSClass("ClientboundPlayerInfoUpdatePacket$Action");
            Constructor<?> constructor = packetClass.getConstructor(actionEnumClass, NMSHelper.getNMSClass("ServerPlayer"));
            return constructor.newInstance(action, serverPlayer);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getClientboundAddPlayerPacket(Object serverPlayer) {
        try {
            Class<?> packetClass = NMSHelper.getNMSClass("ClientboundAddPlayerPacket");
            Constructor<?> constructor = packetClass.getConstructor(NMSHelper.getNMSClass("ServerPlayer"));
            return constructor.newInstance(serverPlayer);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getEnumPlayerInfoAction(String actionName) {
        try {
            Class<?> actionEnumClass = NMSHelper.getNMSClass("ClientboundPlayerInfoUpdatePacket$Action");
            Field actionField = actionEnumClass.getField(actionName);
            return actionField.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        String packageName = Bukkit.getServer().getClass().getPackage().getName();
        version = packageName.substring(packageName.lastIndexOf(46) + 1);
    }
}

