/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.blockentity;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IManagedGridNode;
import appeng.api.util.AECableType;
import appeng.me.helpers.BlockEntityNodeListener;
import appeng.me.helpers.IGridConnectedBlockEntity;
import com.the9grounds.aeadditions.LoggerKt;
import com.the9grounds.aeadditions.core.AEAConfig;
import com.the9grounds.aeadditions.menu.MEWirelessTransceiverMenu;
import com.the9grounds.aeadditions.registries.BlockEntities;
import com.the9grounds.aeadditions.registries.Blocks;
import com.the9grounds.aeadditions.util.Channel;
import com.the9grounds.aeadditions.util.ChannelHolder;
import com.the9grounds.aeadditions.util.ChannelInfo;
import com.the9grounds.aeadditions.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u00106\u001a\u000203H\u0016J\u0012\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010:H\u0016J\u0018\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0014J\b\u0010A\u001a\u00020<H\u0016J\u0012\u0010B\u001a\u00020<2\b\u0010C\u001a\u0004\u0018\u00010DH\u0016J\u000e\u0010E\u001a\u00020<2\u0006\u0010F\u001a\u00020GJ\u0018\u0010H\u001a\u00020<2\u0006\u0010F\u001a\u00020G2\b\b\u0002\u0010I\u001a\u00020JJ\u0018\u0010K\u001a\u00020<2\u0006\u0010F\u001a\u00020G2\b\b\u0002\u0010I\u001a\u00020JJ\u0006\u0010L\u001a\u00020<J\u001a\u0010M\u001a\u00020<2\b\b\u0002\u0010N\u001a\u00020J2\b\b\u0002\u0010O\u001a\u00020JJ\u0018\u0010P\u001a\u00020<2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0014J\b\u0010Q\u001a\u00020<H\u0016J\b\u0010R\u001a\u00020<H\u0016J\u0006\u0010S\u001a\u00020<J\u0014\u0010T\u001a\u0004\u0018\u00010U2\b\u00109\u001a\u0004\u0018\u00010:H\u0016J\b\u0010V\u001a\u00020<H\u0016J \u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020^H\u0016J\b\u0010_\u001a\u00020`H\u0016R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R$\u0010-\u001a\u00020,2\u0006\u0010+\u001a\u00020,@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u0011\u00102\u001a\u000203\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0011\u0010a\u001a\u00020b8F\u00a2\u0006\u0006\u001a\u0004\bc\u0010d\u00a8\u0006e"}, d2={"Lcom/the9grounds/aeadditions/blockentity/MEWirelessTransceiverBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lappeng/me/helpers/IGridConnectedBlockEntity;", "Lnet/minecraft/world/MenuProvider;", "pos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "currentChannel", "Lcom/the9grounds/aeadditions/util/Channel;", "getCurrentChannel", "()Lcom/the9grounds/aeadditions/util/Channel;", "setCurrentChannel", "(Lcom/the9grounds/aeadditions/util/Channel;)V", "channelId", "Ljava/util/UUID;", "getChannelId", "()Ljava/util/UUID;", "setChannelId", "(Ljava/util/UUID;)V", "channelConnectionType", "", "getChannelConnectionType", "()Ljava/lang/String;", "setChannelConnectionType", "(Ljava/lang/String;)V", "connection", "Lappeng/api/networking/IGridConnection;", "getConnection", "()Lappeng/api/networking/IGridConnection;", "setConnection", "(Lappeng/api/networking/IGridConnection;)V", "connections", "", "getConnections", "()Ljava/util/List;", "item", "Lnet/neoforged/neoforge/registries/DeferredItem;", "Lnet/minecraft/world/item/BlockItem;", "getItem", "()Lnet/neoforged/neoforge/registries/DeferredItem;", "value", "", "idleDraw", "getIdleDraw", "()D", "setIdleDraw", "(D)V", "_mainGridNode", "Lappeng/api/networking/IManagedGridNode;", "get_mainGridNode", "()Lappeng/api/networking/IManagedGridNode;", "getMainNode", "getCableConnectionType", "Lappeng/api/util/AECableType;", "dir", "Lnet/minecraft/core/Direction;", "loadAdditional", "", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "saveChanges", "onMainNodeStateChanged", "reason", "Lappeng/api/networking/IGridNodeListener$State;", "removedFromChannel", "channelInfo", "Lcom/the9grounds/aeadditions/util/ChannelInfo;", "broadcastToChannel", "initial", "", "subscribeToChannel", "setupLinks", "destroyConnections", "remove", "clearCurrentChannel", "saveAdditional", "onChunkUnloaded", "setRemoved", "blockPlaced", "getGridNode", "Lappeng/api/networking/IGridNode;", "onLoad", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "id", "", "inventory", "Lnet/minecraft/world/entity/player/Inventory;", "player", "Lnet/minecraft/world/entity/player/Player;", "getDisplayName", "Lnet/minecraft/network/chat/Component;", "channelHolder", "Lcom/the9grounds/aeadditions/util/ChannelHolder;", "getChannelHolder", "()Lcom/the9grounds/aeadditions/util/ChannelHolder;", "AEAdditions-1.21.1-6.0.2"})
@SourceDebugExtension(value={"SMAP\nMEWirelessTransceiverBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MEWirelessTransceiverBlockEntity.kt\ncom/the9grounds/aeadditions/blockentity/MEWirelessTransceiverBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,279:1\n1869#2,2:280\n1869#2,2:283\n1#3:282\n*S KotlinDebug\n*F\n+ 1 MEWirelessTransceiverBlockEntity.kt\ncom/the9grounds/aeadditions/blockentity/MEWirelessTransceiverBlockEntity\n*L\n72#1:280,2\n159#1:283,2\n*E\n"})
public final class MEWirelessTransceiverBlockEntity
extends BlockEntity
implements IGridConnectedBlockEntity,
MenuProvider {
    @Nullable
    private Channel currentChannel;
    @Nullable
    private UUID channelId;
    @Nullable
    private String channelConnectionType;
    @Nullable
    private IGridConnection connection;
    @NotNull
    private final List<IGridConnection> connections;
    @NotNull
    private final DeferredItem<BlockItem> item;
    private double idleDraw;
    @NotNull
    private final IManagedGridNode _mainGridNode;

    public MEWirelessTransceiverBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(BlockEntities.INSTANCE.getME_WIRELESS_TRANSCEIVER(), pos, blockState);
        this.connections = new ArrayList();
        this.item = Blocks.INSTANCE.getBLOCK_ME_WIRELESS_TRANSCEIVER().getItem();
        GridFlags[] gridFlagsArray = new GridFlags[]{GridFlags.DENSE_CAPACITY};
        IManagedGridNode iManagedGridNode = GridHelper.createManagedNode((Object)((Object)this), (IGridNodeListener)((IGridNodeListener)BlockEntityNodeListener.INSTANCE)).setInWorldNode(true).setFlags(gridFlagsArray).setVisualRepresentation((ItemLike)this.item).setTagName("wirelesstransceiver");
        Intrinsics.checkNotNullExpressionValue((Object)iManagedGridNode, (String)"setTagName(...)");
        this._mainGridNode = iManagedGridNode;
    }

    @Nullable
    public final Channel getCurrentChannel() {
        return this.currentChannel;
    }

    public final void setCurrentChannel(@Nullable Channel channel) {
        this.currentChannel = channel;
    }

    @Nullable
    public final UUID getChannelId() {
        return this.channelId;
    }

    public final void setChannelId(@Nullable UUID uUID) {
        this.channelId = uUID;
    }

    @Nullable
    public final String getChannelConnectionType() {
        return this.channelConnectionType;
    }

    public final void setChannelConnectionType(@Nullable String string) {
        this.channelConnectionType = string;
    }

    @Nullable
    public final IGridConnection getConnection() {
        return this.connection;
    }

    public final void setConnection(@Nullable IGridConnection iGridConnection) {
        this.connection = iGridConnection;
    }

    @NotNull
    public final List<IGridConnection> getConnections() {
        return this.connections;
    }

    @NotNull
    public final DeferredItem<BlockItem> getItem() {
        return this.item;
    }

    public final double getIdleDraw() {
        return this.idleDraw;
    }

    public final void setIdleDraw(double value) {
        this.idleDraw = value;
        if (this.getMainNode().isReady()) {
            this.getMainNode().setIdlePowerUsage(value);
        }
    }

    @NotNull
    public final IManagedGridNode get_mainGridNode() {
        return this._mainGridNode;
    }

    @NotNull
    public IManagedGridNode getMainNode() {
        return this._mainGridNode;
    }

    @NotNull
    public AECableType getCableConnectionType(@Nullable Direction dir) {
        return AECableType.SMART;
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        this.getMainNode().loadFromNBT(tag);
        String channelId = tag.getString("channelId");
        if (!Intrinsics.areEqual((Object)channelId, (Object)"")) {
            UUID uuid;
            this.channelId = uuid = UUID.fromString(channelId);
            this.channelConnectionType = tag.getString("transceiverType");
        }
    }

    public void saveChanges() {
    }

    public void onMainNodeStateChanged(@Nullable IGridNodeListener.State reason) {
        block2: {
            if (reason != IGridNodeListener.State.CHANNEL || this.currentChannel == null) break block2;
            Object object = ServerLifecycleHooks.getCurrentServer();
            if (object != null && (object = object.getPlayerList()) != null && (object = object.getPlayers()) != null) {
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ServerPlayer it = (ServerPlayer)element$iv;
                    boolean bl = false;
                    AbstractContainerMenu containerMenu = it.containerMenu;
                    if (!(containerMenu instanceof MEWirelessTransceiverMenu) || !Intrinsics.areEqual((Object)((Object)((MEWirelessTransceiverMenu)containerMenu).getBlockEntity()), (Object)((Object)this))) continue;
                    ((MEWirelessTransceiverMenu)containerMenu).sendTransceiverInfoToClient();
                }
            }
        }
    }

    public final void removedFromChannel(@NotNull ChannelInfo channelInfo) {
        Intrinsics.checkNotNullParameter((Object)channelInfo, (String)"channelInfo");
        MEWirelessTransceiverBlockEntity.destroyConnections$default(this, false, false, 2, null);
        this.channelId = null;
        this.channelConnectionType = null;
    }

    public final void broadcastToChannel(@NotNull ChannelInfo channelInfo, boolean initial) {
        Intrinsics.checkNotNullParameter((Object)channelInfo, (String)"channelInfo");
        Channel channel = this.getChannelHolder().findChannelForBlockEntity(this);
        if (channel != null) {
            channel.removeBlockEntity(this);
        }
        Channel channel2 = this.getChannelHolder().getOrCreateChannel(channelInfo);
        channel2.setBroadcaster(this);
        this.currentChannel = channel2;
        this.channelId = channel2.getChannelInfo().getId();
        this.channelConnectionType = "broadcast";
        channel2.checkSubscribers();
        this.setupLinks();
        if (!initial) {
            this.setChanged();
        }
    }

    public static /* synthetic */ void broadcastToChannel$default(MEWirelessTransceiverBlockEntity mEWirelessTransceiverBlockEntity, ChannelInfo channelInfo, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        mEWirelessTransceiverBlockEntity.broadcastToChannel(channelInfo, bl);
    }

    public final void subscribeToChannel(@NotNull ChannelInfo channelInfo, boolean initial) {
        boolean alreadyExists;
        Object v1;
        Channel channel;
        block5: {
            Intrinsics.checkNotNullParameter((Object)channelInfo, (String)"channelInfo");
            Channel channel2 = this.getChannelHolder().findChannelForBlockEntity(this);
            if (channel2 != null) {
                channel2.removeBlockEntity(this);
            }
            channel = this.getChannelHolder().getOrCreateChannel(channelInfo);
            Iterable iterable = channel.getSubscribers();
            for (Object t : iterable) {
                MEWirelessTransceiverBlockEntity it = (MEWirelessTransceiverBlockEntity)((Object)t);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((Object)it), (Object)((Object)this))) continue;
                v1 = t;
                break block5;
            }
            v1 = null;
        }
        boolean bl = alreadyExists = v1 != null;
        if (!alreadyExists) {
            channel.checkSubscribers();
            channel.getSubscribers().add(this);
            this.currentChannel = channel;
            this.channelId = channel.getChannelInfo().getId();
            this.channelConnectionType = "subscribe";
            Channel channel3 = this.currentChannel;
            Intrinsics.checkNotNull((Object)channel3);
            if (channel3.getBroadcaster() != null) {
                Channel channel4 = this.currentChannel;
                Intrinsics.checkNotNull((Object)channel4);
                MEWirelessTransceiverBlockEntity mEWirelessTransceiverBlockEntity = channel4.getBroadcaster();
                Intrinsics.checkNotNull((Object)((Object)mEWirelessTransceiverBlockEntity));
                mEWirelessTransceiverBlockEntity.setupLinks();
            }
            if (!initial) {
                this.setChanged();
            }
        }
    }

    public static /* synthetic */ void subscribeToChannel$default(MEWirelessTransceiverBlockEntity mEWirelessTransceiverBlockEntity, ChannelInfo channelInfo, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        mEWirelessTransceiverBlockEntity.subscribeToChannel(channelInfo, bl);
    }

    public final void setupLinks() {
        if (this.currentChannel != null) {
            Channel channel = this.currentChannel;
            Intrinsics.checkNotNull((Object)channel);
            if (Intrinsics.areEqual((Object)((Object)channel.getBroadcaster()), (Object)((Object)this))) {
                double localIdleDraw = AEAConfig.INSTANCE.getMeWirelessTransceiverBasePower();
                Channel channel2 = this.currentChannel;
                Intrinsics.checkNotNull((Object)channel2);
                for (MEWirelessTransceiverBlockEntity subscriber : channel2.getSubscribers()) {
                    Level level = this.level;
                    Intrinsics.checkNotNull((Object)level);
                    if (!level.hasChunkAt(subscriber.getBlockPos())) continue;
                    if (subscriber.connection != null) {
                        IGridConnection iGridConnection = subscriber.connection;
                        if (iGridConnection != null) {
                            iGridConnection.destroy();
                        }
                        subscriber.connection = null;
                    }
                    try {
                        IGridConnection connection;
                        subscriber.connection = connection = GridHelper.createConnection((IGridNode)this.getGridNode(null), (IGridNode)subscriber.getGridNode(null));
                        Intrinsics.checkNotNull((Object)connection);
                        this.connections.add(connection);
                        localIdleDraw += AEAConfig.INSTANCE.getMeWirelessTransceiverDistanceMultiplier() * this.getBlockPos().distSqr((Vec3i)subscriber.getBlockPos());
                    }
                    catch (Exception e) {
                        LoggerKt.getLogger().info((Object)e);
                    }
                }
                this.setIdleDraw(localIdleDraw);
            }
        }
    }

    public final void destroyConnections(boolean remove, boolean clearCurrentChannel) {
        if (this.currentChannel != null) {
            Channel channel = this.currentChannel;
            Intrinsics.checkNotNull((Object)channel);
            if (Intrinsics.areEqual((Object)((Object)channel.getBroadcaster()), (Object)((Object)this))) {
                Channel channel2 = this.currentChannel;
                Intrinsics.checkNotNull((Object)channel2);
                Iterable $this$forEach$iv = channel2.getSubscribers();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MEWirelessTransceiverBlockEntity it = (MEWirelessTransceiverBlockEntity)((Object)element$iv);
                    boolean bl = false;
                    if (it.connection == null) continue;
                    IGridConnection iGridConnection = it.connection;
                    Intrinsics.checkNotNull((Object)iGridConnection);
                    iGridConnection.destroy();
                }
                if (remove) {
                    Channel channel3 = this.currentChannel;
                    Intrinsics.checkNotNull((Object)channel3);
                    channel3.setBroadcaster(null);
                }
            } else {
                if (this.connection != null) {
                    IGridConnection iGridConnection = this.connection;
                    Intrinsics.checkNotNull((Object)iGridConnection);
                    iGridConnection.destroy();
                    this.connection = null;
                }
                if (remove) {
                    Channel channel4 = this.currentChannel;
                    Intrinsics.checkNotNull((Object)channel4);
                    channel4.getSubscribers().remove((Object)this);
                }
            }
            if (clearCurrentChannel) {
                this.currentChannel = null;
            }
        }
    }

    public static /* synthetic */ void destroyConnections$default(MEWirelessTransceiverBlockEntity mEWirelessTransceiverBlockEntity, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        mEWirelessTransceiverBlockEntity.destroyConnections(bl, bl2);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        this.getMainNode().saveToNBT(tag);
        if (this.channelId != null) {
            tag.putString("transceiverType", this.channelConnectionType);
            tag.putString("channelId", String.valueOf(this.channelId));
        }
    }

    public void onChunkUnloaded() {
        block2: {
            super.onChunkUnloaded();
            this.getMainNode().destroy();
            if (!Intrinsics.areEqual((Object)Thread.currentThread().getThreadGroup(), (Object)SidedThreadGroups.SERVER)) {
                return;
            }
            Channel cachedChannel = this.currentChannel;
            this.destroyConnections(true, false);
            if (cachedChannel == null || Intrinsics.areEqual((Object)((Object)cachedChannel.getBroadcaster()), (Object)((Object)this))) break block2;
            MEWirelessTransceiverBlockEntity mEWirelessTransceiverBlockEntity = cachedChannel.getBroadcaster();
            if (mEWirelessTransceiverBlockEntity != null) {
                mEWirelessTransceiverBlockEntity.setupLinks();
            }
        }
    }

    public void setRemoved() {
        super.setRemoved();
        this.getMainNode().destroy();
        this.requestModelDataUpdate();
    }

    public final void blockPlaced() {
        this.getGridNode(null);
    }

    @Nullable
    public IGridNode getGridNode(@Nullable Direction dir) {
        block5: {
            block4: {
                if (this.level == null) break block4;
                Level level = this.level;
                Intrinsics.checkNotNull((Object)level);
                if (!level.isClientSide) break block5;
            }
            return null;
        }
        if (!this._mainGridNode.isReady()) {
            this._mainGridNode.create(this.level, this.getBlockPos());
        }
        return this._mainGridNode.getNode();
    }

    public void onLoad() {
        super.onLoad();
        if (this.channelId != null && Intrinsics.areEqual((Object)Thread.currentThread().getThreadGroup(), (Object)SidedThreadGroups.SERVER)) {
            ChannelHolder channelHolder = this.getChannelHolder();
            UUID uUID = this.channelId;
            Intrinsics.checkNotNull((Object)uUID);
            ChannelInfo channelInfo = channelHolder.getChannelInfoById(uUID);
            if (channelInfo == null) {
                return;
            }
            ChannelInfo channelInfo2 = channelInfo;
            if (Intrinsics.areEqual((Object)this.channelConnectionType, (Object)"broadcast")) {
                this.broadcastToChannel(channelInfo2, true);
            } else {
                this.subscribeToChannel(channelInfo2, true);
            }
        }
    }

    @NotNull
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inventory, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return new MEWirelessTransceiverMenu(id, inventory, this);
    }

    @NotNull
    public Component getDisplayName() {
        MutableComponent mutableComponent = Component.literal((String)"ME Wireless Transceiver");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
        return (Component)mutableComponent;
    }

    @NotNull
    public final ChannelHolder getChannelHolder() {
        ChannelHolder channelHolder = Utils.INSTANCE.getChannelHolderForLevel(this.level);
        Intrinsics.checkNotNull((Object)channelHolder);
        return channelHolder;
    }
}

