/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.core.network;

import com.the9grounds.aeadditions.core.network.packet.client.ChannelsPacket;
import com.the9grounds.aeadditions.core.network.packet.client.ClientPacket;
import com.the9grounds.aeadditions.core.network.packet.client.TransceiverInfoPacket;
import com.the9grounds.aeadditions.core.network.packet.server.ChangeTransceiverDataPacket;
import com.the9grounds.aeadditions.core.network.packet.server.CreateChannelPacket;
import com.the9grounds.aeadditions.core.network.packet.server.DeleteChannelPacket;
import com.the9grounds.aeadditions.core.network.packet.server.RequestChannelsPacket;
import com.the9grounds.aeadditions.core.network.packet.server.ServerPacket;
import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J:\u0010\b\u001a\u00020\u0005\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\t0\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u0002H\t0\u0010J:\u0010\u0012\u001a\u00020\u0005\"\b\b\u0000\u0010\t*\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\t0\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u0002H\t0\u0010J\u0016\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0013J\u000e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\n\u00a8\u0006\u001a"}, d2={"Lcom/the9grounds/aeadditions/core/network/NetworkManager;", "", "<init>", "()V", "registerPayloadHandlers", "", "event", "Lnet/neoforged/neoforge/network/event/RegisterPayloadHandlersEvent;", "clientBound", "T", "Lcom/the9grounds/aeadditions/core/network/packet/client/ClientPacket;", "registrar", "Lnet/neoforged/neoforge/network/registration/PayloadRegistrar;", "type", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "codec", "Lnet/minecraft/network/codec/StreamCodec;", "Lio/netty/buffer/ByteBuf;", "serverBound", "Lcom/the9grounds/aeadditions/core/network/packet/server/ServerPacket;", "sendTo", "message", "player", "Lnet/minecraft/server/level/ServerPlayer;", "sendToServer", "sendToAllPlayers", "AEAdditions-1.21.1-6.0.2"})
public final class NetworkManager {
    @NotNull
    public static final NetworkManager INSTANCE = new NetworkManager();

    private NetworkManager() {
    }

    @SubscribeEvent
    public final void registerPayloadHandlers(@NotNull RegisterPayloadHandlersEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        PayloadRegistrar registrar = event.registrar("1");
        Intrinsics.checkNotNull((Object)registrar);
        CustomPacketPayload.Type<ChannelsPacket> type = ChannelsPacket.Companion.getTYPE();
        StreamCodec<ByteBuf, ChannelsPacket> streamCodec = ChannelsPacket.Companion.getSTREAM_CODEC();
        Intrinsics.checkNotNullExpressionValue(streamCodec, (String)"<get-STREAM_CODEC>(...)");
        this.clientBound(registrar, type, streamCodec);
        CustomPacketPayload.Type<TransceiverInfoPacket> type2 = TransceiverInfoPacket.Companion.getTYPE();
        StreamCodec<ByteBuf, TransceiverInfoPacket> streamCodec2 = TransceiverInfoPacket.Companion.getSTREAM_CODEC();
        Intrinsics.checkNotNullExpressionValue(streamCodec2, (String)"<get-STREAM_CODEC>(...)");
        this.clientBound(registrar, type2, streamCodec2);
        CustomPacketPayload.Type<ChangeTransceiverDataPacket> type3 = ChangeTransceiverDataPacket.Companion.getTYPE();
        StreamCodec<ByteBuf, ChangeTransceiverDataPacket> streamCodec3 = ChangeTransceiverDataPacket.Companion.getSTREAM_CODEC();
        Intrinsics.checkNotNullExpressionValue(streamCodec3, (String)"<get-STREAM_CODEC>(...)");
        this.serverBound(registrar, type3, streamCodec3);
        CustomPacketPayload.Type<CreateChannelPacket> type4 = CreateChannelPacket.Companion.getTYPE();
        StreamCodec<ByteBuf, CreateChannelPacket> streamCodec4 = CreateChannelPacket.Companion.getSTREAM_CODEC();
        Intrinsics.checkNotNullExpressionValue(streamCodec4, (String)"<get-STREAM_CODEC>(...)");
        this.serverBound(registrar, type4, streamCodec4);
        CustomPacketPayload.Type<DeleteChannelPacket> type5 = DeleteChannelPacket.Companion.getTYPE();
        StreamCodec<ByteBuf, DeleteChannelPacket> streamCodec5 = DeleteChannelPacket.Companion.getSTREAM_CODEC();
        Intrinsics.checkNotNullExpressionValue(streamCodec5, (String)"<get-STREAM_CODEC>(...)");
        this.serverBound(registrar, type5, streamCodec5);
        CustomPacketPayload.Type<RequestChannelsPacket> type6 = RequestChannelsPacket.Companion.getTYPE();
        StreamCodec<ByteBuf, RequestChannelsPacket> streamCodec6 = RequestChannelsPacket.Companion.getSTREAM_CODEC();
        Intrinsics.checkNotNullExpressionValue(streamCodec6, (String)"<get-STREAM_CODEC>(...)");
        this.serverBound(registrar, type6, streamCodec6);
    }

    public final <T extends ClientPacket> void clientBound(@NotNull PayloadRegistrar registrar, @NotNull CustomPacketPayload.Type<T> type, @NotNull StreamCodec<ByteBuf, T> codec) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        registrar.playToClient(type, codec, ClientPacket::handle);
    }

    public final <T extends ServerPacket> void serverBound(@NotNull PayloadRegistrar registrar, @NotNull CustomPacketPayload.Type<T> type, @NotNull StreamCodec<ByteBuf, T> codec) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        registrar.playToServer(type, codec, ServerPacket::handle);
    }

    public final void sendTo(@NotNull ClientPacket message, @NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public final void sendToServer(@NotNull ServerPacket message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        PacketDistributor.sendToServer((CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public final void sendToAllPlayers(@NotNull ClientPacket message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

