/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.core.network.packet.server;

import com.the9grounds.aeadditions.LoggerKt;
import com.the9grounds.aeadditions.blockentity.MEWirelessTransceiverBlockEntity;
import com.the9grounds.aeadditions.core.network.NetworkManager;
import com.the9grounds.aeadditions.core.network.packet.Packet;
import com.the9grounds.aeadditions.core.network.packet.client.ClientPacket;
import com.the9grounds.aeadditions.core.network.packet.client.TransceiverInfoPacket;
import com.the9grounds.aeadditions.core.network.packet.server.CreateChannelPacket;
import com.the9grounds.aeadditions.core.network.packet.server.ServerPacket;
import com.the9grounds.aeadditions.menu.MEWirelessTransceiverMenu;
import com.the9grounds.aeadditions.util.Channel;
import com.the9grounds.aeadditions.util.ChannelHolder;
import com.the9grounds.aeadditions.util.ChannelInfo;
import com.the9grounds.aeadditions.util.Utils;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/the9grounds/aeadditions/core/network/packet/server/CreateChannelPacket;", "Lcom/the9grounds/aeadditions/core/network/packet/server/ServerPacket;", "isPrivate", "", "channelName", "", "subscribe", "<init>", "(ZLjava/lang/String;Z)V", "()Z", "getChannelName", "()Ljava/lang/String;", "getSubscribe", "type", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload;", "handle", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "Companion", "AEAdditions-1.21.1-6.0.2"})
@SourceDebugExtension(value={"SMAP\nCreateChannelPacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateChannelPacket.kt\ncom/the9grounds/aeadditions/core/network/packet/server/CreateChannelPacket\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n1#2:89\n1869#3,2:90\n*S KotlinDebug\n*F\n+ 1 CreateChannelPacket.kt\ncom/the9grounds/aeadditions/core/network/packet/server/CreateChannelPacket\n*L\n75#1:90,2\n*E\n"})
public final class CreateChannelPacket
implements ServerPacket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isPrivate;
    @NotNull
    private final String channelName;
    private final boolean subscribe;
    @NotNull
    private static final CustomPacketPayload.Type<CreateChannelPacket> TYPE = Packet.Companion.createType("create_channel");
    private static final StreamCodec<ByteBuf, CreateChannelPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, arg_0 -> CreateChannelPacket.STREAM_CODEC$lambda$2((KProperty1)Companion.STREAM_CODEC.1.INSTANCE, arg_0), (StreamCodec)ByteBufCodecs.STRING_UTF8, arg_0 -> CreateChannelPacket.STREAM_CODEC$lambda$3((KProperty1)Companion.STREAM_CODEC.2.INSTANCE, arg_0), (StreamCodec)ByteBufCodecs.BOOL, arg_0 -> CreateChannelPacket.STREAM_CODEC$lambda$4((KProperty1)Companion.STREAM_CODEC.3.INSTANCE, arg_0), CreateChannelPacket::new);

    public CreateChannelPacket(boolean isPrivate, @NotNull String channelName, boolean subscribe) {
        Intrinsics.checkNotNullParameter((Object)channelName, (String)"channelName");
        this.isPrivate = isPrivate;
        this.channelName = channelName;
        this.subscribe = subscribe;
    }

    public final boolean isPrivate() {
        return this.isPrivate;
    }

    @NotNull
    public final String getChannelName() {
        return this.channelName;
    }

    public final boolean getSubscribe() {
        return this.subscribe;
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void handle(@NotNull ServerPlayer player) {
        block9: {
            boolean alreadyExists;
            Object v1;
            ChannelHolder channelHolder;
            AbstractContainerMenu containerMenu;
            block8: {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                containerMenu = player.containerMenu;
                if (!(containerMenu instanceof MEWirelessTransceiverMenu)) {
                    return;
                }
                Level level = player.level();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ServerLevel level2 = (ServerLevel)level;
                channelHolder = Utils.INSTANCE.getChannelHolderForLevel((Level)level2);
                if (channelHolder == null) {
                    LoggerKt.getLogger().warn("Channel Holder was null in CreateChannelPacket");
                    return;
                }
                Iterable iterable = channelHolder.getChannelInfos();
                for (Object t : iterable) {
                    ChannelInfo it = (ChannelInfo)t;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)this.channelName) && (it.isPrivate() && it.hasAccessTo(player) || !it.isPrivate()))) continue;
                    v1 = t;
                    break block8;
                }
                v1 = null;
            }
            boolean bl = alreadyExists = v1 != null;
            if (alreadyExists) {
                return;
            }
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
            ChannelInfo channelInfo = new ChannelInfo(uUID, this.channelName, this.isPrivate, player.getUUID(), player.getName().toString());
            channelHolder.getChannelInfos().add(channelInfo);
            if (this.subscribe) {
                MEWirelessTransceiverBlockEntity mEWirelessTransceiverBlockEntity = ((MEWirelessTransceiverMenu)containerMenu).getBlockEntity();
                Intrinsics.checkNotNull((Object)((Object)mEWirelessTransceiverBlockEntity));
                MEWirelessTransceiverBlockEntity.subscribeToChannel$default(mEWirelessTransceiverBlockEntity, channelInfo, false, 2, null);
            } else {
                MEWirelessTransceiverBlockEntity mEWirelessTransceiverBlockEntity = ((MEWirelessTransceiverMenu)containerMenu).getBlockEntity();
                Intrinsics.checkNotNull((Object)((Object)mEWirelessTransceiverBlockEntity));
                MEWirelessTransceiverBlockEntity.broadcastToChannel$default(mEWirelessTransceiverBlockEntity, channelInfo, false, 2, null);
            }
            Channel channel = channelHolder.getOrCreateChannel(channelInfo);
            Optional<ChannelInfo> optional = Optional.of(channelInfo);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
            TransceiverInfoPacket transceiverDataChange = new TransceiverInfoPacket(optional, this.subscribe, channel.getUsedChannels(), channel.getMaxChannels());
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            Object object = server;
            if (object == null || (object = object.getPlayerList()) == null || (object = object.getPlayers()) == null) break block9;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ServerPlayer it = (ServerPlayer)element$iv;
                boolean bl2 = false;
                AbstractContainerMenu innerContainerMenu = it.containerMenu;
                if (!(innerContainerMenu instanceof MEWirelessTransceiverMenu)) continue;
                if (Intrinsics.areEqual((Object)((Object)((MEWirelessTransceiverMenu)innerContainerMenu).getBlockEntity()), (Object)((Object)((MEWirelessTransceiverMenu)containerMenu).getBlockEntity()))) {
                    ClientPacket clientPacket = transceiverDataChange;
                    Intrinsics.checkNotNull((Object)it);
                    NetworkManager.INSTANCE.sendTo(clientPacket, it);
                }
                if (!Intrinsics.areEqual((Object)it.level(), (Object)player.level())) continue;
                ((MEWirelessTransceiverMenu)innerContainerMenu).sendChannelsToClient();
            }
        }
    }

    @Override
    public void handle(@NotNull IPayloadContext context) {
        ServerPacket.DefaultImpls.handle(this, context);
    }

    private static final Boolean STREAM_CODEC$lambda$2(KProperty1 $tmp0, CreateChannelPacket p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final String STREAM_CODEC$lambda$3(KProperty1 $tmp0, CreateChannelPacket p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Boolean STREAM_CODEC$lambda$4(KProperty1 $tmp0, CreateChannelPacket p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)((Function1)$tmp0).invoke((Object)p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bRS\u0010\t\u001aB\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00060\u0006 \f* \u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\n0\n\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/the9grounds/aeadditions/core/network/packet/server/CreateChannelPacket$Companion;", "", "<init>", "()V", "TYPE", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "Lcom/the9grounds/aeadditions/core/network/packet/server/CreateChannelPacket;", "getTYPE", "()Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lio/netty/buffer/ByteBuf;", "kotlin.jvm.PlatformType", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/codec/StreamCodec;", "AEAdditions-1.21.1-6.0.2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CustomPacketPayload.Type<CreateChannelPacket> getTYPE() {
            return TYPE;
        }

        public final StreamCodec<ByteBuf, CreateChannelPacket> getSTREAM_CODEC() {
            return STREAM_CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

