/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.item.storage;

import appeng.api.config.FuzzyMode;
import appeng.api.ids.AEComponents;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.hooks.AEToolItem;
import appeng.items.contents.CellConfig;
import appeng.util.ConfigInventory;
import appeng.util.InteractionUtil;
import com.the9grounds.aeadditions.api.IAEAdditionsDiskCell;
import com.the9grounds.aeadditions.item.storage.DiskCellWithoutMod;
import io.github.projectet.ae2things.item.AETItems;
import io.github.projectet.ae2things.storage.DISKCellHandler;
import io.github.projectet.ae2things.storage.DISKCellInventory;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B9\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010\u0018\u001a\u00020\u0007H\u0016J\u001a\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010\u001f\u001a\u00020\f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010 \u001a\u00020\u000eH\u0016J\u0012\u0010!\u001a\u00020\u001a2\b\u0010\"\u001a\u0004\u0018\u00010\u001cH\u0016J\u0012\u0010#\u001a\u00020$2\b\u0010\"\u001a\u0004\u0018\u00010\u001cH\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\"\u001a\u00020\u001cH\u0016J\u0018\u0010'\u001a\u00020(2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020&H\u0016J*\u0010*\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u000101H\u0016J\u0012\u00102\u001a\u0002032\b\u0010\"\u001a\u0004\u0018\u00010\u001cH\u0016J\"\u00104\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/H\u0002J\u0018\u00106\u001a\u0002072\u0006\u00105\u001a\u00020\u001c2\u0006\u00108\u001a\u000209H\u0016J.\u0010:\u001a\u00020(2\u0006\u00105\u001a\u00020\u001c2\u0006\u00108\u001a\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=2\u0006\u0010?\u001a\u00020@H\u0017J\u0018\u0010A\u001a\u00020\f2\b\u00105\u001a\u0004\u0018\u00010\u001c2\u0006\u0010B\u001a\u00020\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006C"}, d2={"Lcom/the9grounds/aeadditions/item/storage/DiskCell;", "Lcom/the9grounds/aeadditions/item/storage/DiskCellWithoutMod;", "Lcom/the9grounds/aeadditions/api/IAEAdditionsDiskCell;", "Lappeng/hooks/AEToolItem;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "keyType", "Lappeng/api/stacks/AEKeyType;", "component", "Lnet/minecraft/world/level/ItemLike;", "housing", "kilobytes", "", "_idleDrain", "", "<init>", "(Lnet/minecraft/world/item/Item$Properties;Lappeng/api/stacks/AEKeyType;Lnet/minecraft/world/level/ItemLike;Lnet/minecraft/world/level/ItemLike;ID)V", "getComponent", "()Lnet/minecraft/world/level/ItemLike;", "getHousing", "getKilobytes", "()I", "get_idleDrain", "()D", "getKeyType", "isBlackListed", "", "cellItem", "Lnet/minecraft/world/item/ItemStack;", "requestedAddition", "Lappeng/api/stacks/AEKey;", "getBytes", "getIdleDrain", "isEditable", "is", "getConfigInventory", "Lappeng/util/ConfigInventory;", "getFuzzyMode", "Lappeng/api/config/FuzzyMode;", "setFuzzyMode", "", "fzMode", "use", "Lnet/minecraft/world/InteractionResultHolder;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "getUpgrades", "Lappeng/api/upgrades/IUpgradeInventory;", "disassembleDrive", "stack", "onItemUseFirst", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "appendHoverText", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "getColor", "tintIndex", "AEAdditions-1.21.1-6.0.2"})
public final class DiskCell
extends DiskCellWithoutMod
implements IAEAdditionsDiskCell,
AEToolItem {
    @NotNull
    private final AEKeyType keyType;
    @NotNull
    private final ItemLike component;
    @Nullable
    private final ItemLike housing;
    private final int kilobytes;
    private final double _idleDrain;

    public DiskCell(@NotNull Item.Properties properties, @NotNull AEKeyType keyType, @NotNull ItemLike component, @Nullable ItemLike housing, int kilobytes, double _idleDrain) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        super(properties);
        this.keyType = keyType;
        this.component = component;
        this.housing = housing;
        this.kilobytes = kilobytes;
        this._idleDrain = _idleDrain;
    }

    @NotNull
    public final ItemLike getComponent() {
        return this.component;
    }

    @Nullable
    public final ItemLike getHousing() {
        return this.housing;
    }

    public final int getKilobytes() {
        return this.kilobytes;
    }

    public final double get_idleDrain() {
        return this._idleDrain;
    }

    @Override
    @NotNull
    public AEKeyType getKeyType() {
        return this.keyType;
    }

    @Override
    public boolean isBlackListed(@Nullable ItemStack cellItem, @NotNull AEKey requestedAddition) {
        Intrinsics.checkNotNullParameter((Object)requestedAddition, (String)"requestedAddition");
        if (requestedAddition instanceof AEItemKey) {
            return IAEAdditionsDiskCell.DefaultImpls.isBlackListed(this, cellItem, requestedAddition);
        }
        return false;
    }

    @Override
    public int getBytes(@Nullable ItemStack cellItem) {
        return this.kilobytes * 1024;
    }

    @Override
    public double getIdleDrain() {
        return this._idleDrain;
    }

    public boolean isEditable(@Nullable ItemStack is) {
        return true;
    }

    @Override
    @NotNull
    public ConfigInventory getConfigInventory(@Nullable ItemStack is) {
        Object[] objectArray = new AEKeyType[]{this.keyType};
        ConfigInventory configInventory = CellConfig.create((Set)SetsKt.mutableSetOf((Object[])objectArray), (ItemStack)is);
        Intrinsics.checkNotNullExpressionValue((Object)configInventory, (String)"create(...)");
        return configInventory;
    }

    @Nullable
    public FuzzyMode getFuzzyMode(@NotNull ItemStack is) {
        Intrinsics.checkNotNullParameter((Object)is, (String)"is");
        return (FuzzyMode)is.getOrDefault(AEComponents.STORAGE_CELL_FUZZY_MODE, (Object)FuzzyMode.IGNORE_ALL);
    }

    public void setFuzzyMode(@NotNull ItemStack is, @NotNull FuzzyMode fzMode) {
        Intrinsics.checkNotNullParameter((Object)is, (String)"is");
        Intrinsics.checkNotNullParameter((Object)fzMode, (String)"fzMode");
        is.set(AEComponents.STORAGE_CELL_FUZZY_MODE, (Object)fzMode);
    }

    @Nullable
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @Nullable InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack itemStack = player.getItemInHand(hand);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInHand(...)");
        this.disassembleDrive(itemStack, level, player);
        return new InteractionResultHolder(InteractionResult.sidedSuccess((boolean)level.isClientSide()), (Object)player.getItemInHand(hand));
    }

    @NotNull
    public IUpgradeInventory getUpgrades(@Nullable ItemStack is) {
        IUpgradeInventory iUpgradeInventory = UpgradeInventories.forItem((ItemStack)is, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)iUpgradeInventory, (String)"forItem(...)");
        return iUpgradeInventory;
    }

    private final boolean disassembleDrive(ItemStack stack, Level level, Player player) {
        if (InteractionUtil.isInAlternateUseMode((Player)player)) {
            KeyCounter list;
            if (level.isClientSide()) {
                return false;
            }
            Player player2 = player;
            Intrinsics.checkNotNull((Object)player2);
            Inventory playerInventory = player2.getInventory();
            StorageCell inv = StorageCells.getCellInventory((ItemStack)stack, null);
            if (inv != null && Intrinsics.areEqual((Object)playerInventory.getSelected(), (Object)stack) && (list = inv.getAvailableStacks()).isEmpty()) {
                playerInventory.setItem(playerInventory.selected, ItemStack.EMPTY);
                playerInventory.placeItemBackInInventory(new ItemStack(this.component));
                Iterator iterator = this.getUpgrades(stack).iterator();
                Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    ItemStack upgrade = (ItemStack)iterator2.next();
                    playerInventory.placeItemBackInInventory(upgrade);
                }
                ItemLike itemLike = this.housing;
                if (itemLike == null) {
                    itemLike = (ItemLike)AETItems.DISK_HOUSING.get();
                }
                playerInventory.placeItemBackInInventory(new ItemStack(itemLike));
                return true;
            }
        }
        return false;
    }

    @NotNull
    public InteractionResult onItemUseFirst(@NotNull ItemStack stack, @NotNull UseOnContext context) {
        InteractionResult interactionResult;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Level level = context.getLevel();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
        if (this.disassembleDrive(stack, level, context.getPlayer())) {
            InteractionResult interactionResult2 = InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide());
            interactionResult = interactionResult2;
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult2, (String)"sidedSuccess(...)");
        } else {
            interactionResult = InteractionResult.PASS;
        }
        return interactionResult;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        ChatFormatting[] chatFormattingArray = new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC};
        MutableComponent mutableComponent = Component.literal((String)"Deep Item Storage disK - Storage for dummies").withStyle(chatFormattingArray);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
        tooltipComponents.add((Component)mutableComponent);
        this.addCellInformationToTooltip(stack, tooltipComponents);
    }

    public final int getColor(@Nullable ItemStack stack, int tintIndex) {
        int n;
        if (tintIndex == 1) {
            DISKCellInventory cellInv;
            DISKCellInventory dISKCellInventory = cellInv = DISKCellHandler.INSTANCE.getCellInventory(stack, null);
            CellState cellStatus = dISKCellInventory != null ? dISKCellInventory.getClientStatus() : CellState.EMPTY;
            n = cellStatus.getStateColor();
        } else {
            n = 0xFFFFFF;
        }
        return n;
    }

    @Override
    public boolean storableInStorageCell() {
        return IAEAdditionsDiskCell.DefaultImpls.storableInStorageCell(this);
    }

    @Override
    public boolean isStorageCell(@Nullable ItemStack i) {
        return IAEAdditionsDiskCell.DefaultImpls.isStorageCell(this, i);
    }

    @Override
    public void addCellInformationToTooltip(@NotNull ItemStack is, @NotNull List<Component> lines) {
        IAEAdditionsDiskCell.DefaultImpls.addCellInformationToTooltip(this, is, lines);
    }
}

