/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.item.storage;

import appeng.api.config.FuzzyMode;
import appeng.api.ids.AEComponents;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.IBasicCellItem;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.items.contents.CellConfig;
import appeng.util.ConfigInventory;
import com.the9grounds.aeadditions.LoggerKt;
import com.the9grounds.aeadditions.api.IAEAdditionsStorageCell;
import com.the9grounds.aeadditions.me.storage.AEAdditionsCellHandler;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003BG\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010#\u001a\u00020\nH\u0016J\u0012\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010 H\u0016J\b\u0010'\u001a\u00020\u0010H\u0016J\u0012\u0010(\u001a\u00020)2\b\u0010&\u001a\u0004\u0018\u00010 H\u0016J\u0012\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010 H\u0016J\u0012\u0010-\u001a\u00020.2\b\u0010&\u001a\u0004\u0018\u00010 H\u0016J\u001c\u0010/\u001a\u0002002\b\u0010&\u001a\u0004\u0018\u00010 2\b\u00101\u001a\u0004\u0018\u00010.H\u0016J&\u00102\u001a\b\u0012\u0004\u0012\u00020 032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0016J\"\u0010:\u001a\u00020%2\b\u0010,\u001a\u0004\u0018\u00010 2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002J\u001c\u0010;\u001a\u00020<2\b\u0010,\u001a\u0004\u0018\u00010 2\b\u0010=\u001a\u0004\u0018\u00010>H\u0016J.\u0010?\u001a\u0002002\u0006\u0010,\u001a\u00020 2\u0006\u0010=\u001a\u00020@2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020C0B2\u0006\u0010D\u001a\u00020EH\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u000e\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006F"}, d2={"Lcom/the9grounds/aeadditions/item/storage/StorageCell;", "Lnet/minecraft/world/item/Item;", "Lappeng/api/storage/cells/IBasicCellItem;", "Lcom/the9grounds/aeadditions/api/IAEAdditionsStorageCell;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "component", "Lnet/minecraft/world/level/ItemLike;", "housingItem", "_idleDrain", "", "_bytesPerType", "", "kiloBytes", "numberOfTypes", "_keyType", "Lappeng/api/stacks/AEKeyType;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;Lnet/minecraft/world/level/ItemLike;Lnet/minecraft/world/level/ItemLike;DIIILappeng/api/stacks/AEKeyType;)V", "getComponent", "()Lnet/minecraft/world/level/ItemLike;", "getHousingItem", "get_idleDrain", "()D", "get_bytesPerType", "()I", "getKiloBytes", "getNumberOfTypes", "get_keyType", "()Lappeng/api/stacks/AEKeyType;", "getBytes", "cellItem", "Lnet/minecraft/world/item/ItemStack;", "getBytesPerType", "getTotalTypes", "getIdleDrain", "isEditable", "", "is", "getKeyType", "getConfigInventory", "Lappeng/util/ConfigInventory;", "getUpgrades", "Lappeng/api/upgrades/IUpgradeInventory;", "stack", "getFuzzyMode", "Lappeng/api/config/FuzzyMode;", "setFuzzyMode", "", "fzMode", "use", "Lnet/minecraft/world/InteractionResultHolder;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "disassembleDrive", "onItemUseFirst", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "appendHoverText", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "AEAdditions-1.21.1-6.0.2"})
@SourceDebugExtension(value={"SMAP\nStorageCell.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageCell.kt\ncom/the9grounds/aeadditions/item/storage/StorageCell\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1869#2,2:111\n*S KotlinDebug\n*F\n+ 1 StorageCell.kt\ncom/the9grounds/aeadditions/item/storage/StorageCell\n*L\n81#1:111,2\n*E\n"})
public final class StorageCell
extends Item
implements IBasicCellItem,
IAEAdditionsStorageCell {
    @NotNull
    private final ItemLike component;
    @NotNull
    private final ItemLike housingItem;
    private final double _idleDrain;
    private final int _bytesPerType;
    private final int kiloBytes;
    private final int numberOfTypes;
    @NotNull
    private final AEKeyType _keyType;

    public StorageCell(@NotNull Item.Properties properties, @NotNull ItemLike component, @NotNull ItemLike housingItem, double _idleDrain, int _bytesPerType, int kiloBytes, int numberOfTypes, @NotNull AEKeyType _keyType) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)housingItem, (String)"housingItem");
        Intrinsics.checkNotNullParameter((Object)_keyType, (String)"_keyType");
        super(properties);
        this.component = component;
        this.housingItem = housingItem;
        this._idleDrain = _idleDrain;
        this._bytesPerType = _bytesPerType;
        this.kiloBytes = kiloBytes;
        this.numberOfTypes = numberOfTypes;
        this._keyType = _keyType;
    }

    @NotNull
    public final ItemLike getComponent() {
        return this.component;
    }

    @NotNull
    public final ItemLike getHousingItem() {
        return this.housingItem;
    }

    public final double get_idleDrain() {
        return this._idleDrain;
    }

    public final int get_bytesPerType() {
        return this._bytesPerType;
    }

    public final int getKiloBytes() {
        return this.kiloBytes;
    }

    public final int getNumberOfTypes() {
        return this.numberOfTypes;
    }

    @NotNull
    public final AEKeyType get_keyType() {
        return this._keyType;
    }

    public int getBytes(@NotNull ItemStack cellItem) {
        Intrinsics.checkNotNullParameter((Object)cellItem, (String)"cellItem");
        return this.kiloBytes * 1024;
    }

    public int getBytesPerType(@NotNull ItemStack cellItem) {
        Intrinsics.checkNotNullParameter((Object)cellItem, (String)"cellItem");
        return this._bytesPerType;
    }

    public int getTotalTypes(@NotNull ItemStack cellItem) {
        Intrinsics.checkNotNullParameter((Object)cellItem, (String)"cellItem");
        return this.numberOfTypes;
    }

    public double getIdleDrain() {
        return this._idleDrain;
    }

    public boolean isEditable(@Nullable ItemStack is) {
        return true;
    }

    @NotNull
    public AEKeyType getKeyType() {
        return this._keyType;
    }

    @NotNull
    public ConfigInventory getConfigInventory(@Nullable ItemStack is) {
        Object[] objectArray = new AEKeyType[]{this._keyType};
        ConfigInventory configInventory = CellConfig.create((Set)SetsKt.mutableSetOf((Object[])objectArray), (ItemStack)is);
        Intrinsics.checkNotNullExpressionValue((Object)configInventory, (String)"create(...)");
        return configInventory;
    }

    @NotNull
    public IUpgradeInventory getUpgrades(@Nullable ItemStack stack) {
        IUpgradeInventory iUpgradeInventory = UpgradeInventories.forItem((ItemStack)stack, (int)4);
        Intrinsics.checkNotNullExpressionValue((Object)iUpgradeInventory, (String)"forItem(...)");
        return iUpgradeInventory;
    }

    @NotNull
    public FuzzyMode getFuzzyMode(@Nullable ItemStack is) {
        ItemStack itemStack = is;
        if (itemStack == null || (itemStack = (FuzzyMode)itemStack.getOrDefault(AEComponents.STORAGE_CELL_FUZZY_MODE, (Object)FuzzyMode.IGNORE_ALL)) == null) {
            itemStack = FuzzyMode.IGNORE_ALL;
        }
        return itemStack;
    }

    public void setFuzzyMode(@Nullable ItemStack is, @Nullable FuzzyMode fzMode) {
        if (is == null) {
            LoggerKt.getLogger().error("itemStack is null?");
            return;
        }
        FuzzyMode fuzzyMode = fzMode;
        if (fuzzyMode == null) {
            fuzzyMode = FuzzyMode.IGNORE_ALL;
        }
        is.set(AEComponents.STORAGE_CELL_FUZZY_MODE, (Object)fuzzyMode);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        this.disassembleDrive(player.getItemInHand(hand), level, player);
        return new InteractionResultHolder(InteractionResult.sidedSuccess((boolean)level.isClientSide), (Object)player.getItemInHand(hand));
    }

    private final boolean disassembleDrive(ItemStack stack, Level level, Player player) {
        if (player.isCrouching()) {
            KeyCounter list;
            if (level.isClientSide) {
                return false;
            }
            Inventory inventory = player.getInventory();
            appeng.api.storage.cells.StorageCell inv = StorageCells.getCellInventory((ItemStack)stack, null);
            if (inv != null && Intrinsics.areEqual((Object)inventory.getSelected(), (Object)stack) && (list = inv.getAvailableStacks()).isEmpty()) {
                inventory.setItem(inventory.selected, ItemStack.EMPTY);
                inventory.placeItemBackInInventory(new ItemStack(this.component));
                Iterable $this$forEach$iv = (Iterable)this.getUpgrades(stack);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ItemStack it = (ItemStack)element$iv;
                    boolean bl = false;
                    inventory.placeItemBackInInventory(it);
                }
                inventory.placeItemBackInInventory(new ItemStack(this.housingItem));
                return true;
            }
        }
        return false;
    }

    @NotNull
    public InteractionResult onItemUseFirst(@Nullable ItemStack stack, @Nullable UseOnContext context) {
        InteractionResult interactionResult;
        UseOnContext useOnContext = context;
        Intrinsics.checkNotNull((Object)useOnContext);
        Level level = useOnContext.getLevel();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
        Player player = context.getPlayer();
        Intrinsics.checkNotNull((Object)player);
        if (this.disassembleDrive(stack, level, player)) {
            InteractionResult interactionResult2 = InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide);
            Intrinsics.checkNotNull((Object)interactionResult2);
            interactionResult = interactionResult2;
        } else {
            interactionResult = InteractionResult.PASS;
        }
        return interactionResult;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        AEAdditionsCellHandler.INSTANCE.addCellInformationToTooltip(stack, tooltipComponents);
    }
}

