/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.item.storage;

import appeng.api.stacks.KeyCounter;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.StorageCell;
import com.the9grounds.aeadditions.me.storage.SuperCellHandler;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001d\u001a\u00020\bJ&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020\u001aJ\"\u0010*\u001a\u00020'2\b\u0010+\u001a\u0004\u0018\u00010\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010,\u001a\u00020-2\u0006\u0010+\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020/H\u0016J.\u00100\u001a\u0002012\u0006\u0010+\u001a\u00020\u001a2\u0006\u0010.\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u000205042\u0006\u00106\u001a\u000207H\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015\u00a8\u00068"}, d2={"Lcom/the9grounds/aeadditions/item/storage/SuperStorageCell;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "component", "Lnet/minecraft/world/level/ItemLike;", "housingItem", "_idleDrain", "", "_bytesPerType", "", "kiloBytes", "numberOfTypes", "<init>", "(Lnet/minecraft/world/item/Item$Properties;Lnet/minecraft/world/level/ItemLike;Lnet/minecraft/world/level/ItemLike;DIII)V", "getComponent", "()Lnet/minecraft/world/level/ItemLike;", "getHousingItem", "get_idleDrain", "()D", "get_bytesPerType", "()I", "getKiloBytes", "getNumberOfTypes", "getBytes", "cellItem", "Lnet/minecraft/world/item/ItemStack;", "getBytesPerType", "getTotalTypes", "getIdleDrain", "use", "Lnet/minecraft/world/InteractionResultHolder;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "storableInStorageCell", "", "isStorageCell", "itemStack", "disassembleDrive", "stack", "onItemUseFirst", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "appendHoverText", "", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "AEAdditions-1.21.1-6.0.2"})
public final class SuperStorageCell
extends Item {
    @NotNull
    private final ItemLike component;
    @NotNull
    private final ItemLike housingItem;
    private final double _idleDrain;
    private final int _bytesPerType;
    private final int kiloBytes;
    private final int numberOfTypes;

    public SuperStorageCell(@NotNull Item.Properties properties, @NotNull ItemLike component, @NotNull ItemLike housingItem, double _idleDrain, int _bytesPerType, int kiloBytes, int numberOfTypes) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)housingItem, (String)"housingItem");
        super(properties);
        this.component = component;
        this.housingItem = housingItem;
        this._idleDrain = _idleDrain;
        this._bytesPerType = _bytesPerType;
        this.kiloBytes = kiloBytes;
        this.numberOfTypes = numberOfTypes;
    }

    @NotNull
    public final ItemLike getComponent() {
        return this.component;
    }

    @NotNull
    public final ItemLike getHousingItem() {
        return this.housingItem;
    }

    public final double get_idleDrain() {
        return this._idleDrain;
    }

    public final int get_bytesPerType() {
        return this._bytesPerType;
    }

    public final int getKiloBytes() {
        return this.kiloBytes;
    }

    public final int getNumberOfTypes() {
        return this.numberOfTypes;
    }

    public final int getBytes(@NotNull ItemStack cellItem) {
        Intrinsics.checkNotNullParameter((Object)cellItem, (String)"cellItem");
        return this.kiloBytes * 1024;
    }

    public final int getBytesPerType(@NotNull ItemStack cellItem) {
        Intrinsics.checkNotNullParameter((Object)cellItem, (String)"cellItem");
        return this._bytesPerType;
    }

    public final int getTotalTypes(@NotNull ItemStack cellItem) {
        Intrinsics.checkNotNullParameter((Object)cellItem, (String)"cellItem");
        return this.numberOfTypes;
    }

    public final double getIdleDrain() {
        return this._idleDrain;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        this.disassembleDrive(player.getItemInHand(hand), level, player);
        return new InteractionResultHolder(InteractionResult.sidedSuccess((boolean)level.isClientSide), (Object)player.getItemInHand(hand));
    }

    public final boolean storableInStorageCell() {
        return false;
    }

    public final boolean isStorageCell(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        return true;
    }

    private final boolean disassembleDrive(ItemStack stack, Level level, Player player) {
        if (player.isCrouching()) {
            KeyCounter list;
            if (level.isClientSide) {
                return false;
            }
            Inventory inventory = player.getInventory();
            StorageCell inv = StorageCells.getCellInventory((ItemStack)stack, null);
            if (inv != null && Intrinsics.areEqual((Object)inventory.getSelected(), (Object)stack) && (list = inv.getAvailableStacks()).isEmpty()) {
                inventory.setItem(inventory.selected, ItemStack.EMPTY);
                inventory.placeItemBackInInventory(new ItemStack(this.component));
                inventory.placeItemBackInInventory(new ItemStack(this.housingItem));
                return true;
            }
        }
        return false;
    }

    @NotNull
    public InteractionResult onItemUseFirst(@NotNull ItemStack stack, @NotNull UseOnContext context) {
        InteractionResult interactionResult;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Level level = context.getLevel();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
        Player player = context.getPlayer();
        Intrinsics.checkNotNull((Object)player);
        if (this.disassembleDrive(stack, level, player)) {
            InteractionResult interactionResult2 = InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide);
            Intrinsics.checkNotNull((Object)interactionResult2);
            interactionResult = interactionResult2;
        } else {
            interactionResult = InteractionResult.PASS;
        }
        return interactionResult;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        SuperCellHandler.INSTANCE.addCellInformationToTooltip(stack, tooltipComponents);
    }
}

