/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.me.storage;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.ids.AEComponents;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.core.definitions.AEItems;
import appeng.util.ConfigInventory;
import appeng.util.prioritylist.FuzzyPriorityList;
import appeng.util.prioritylist.IPartitionList;
import com.the9grounds.aeadditions.api.IAEAdditionsStorageCell;
import com.the9grounds.aeadditions.item.storage.StorageCell;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 d2\u00020\u0001:\u0001dB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u000208H\u0014J\b\u0010:\u001a\u000208H\u0002J\u0010\u0010;\u001a\u0002082\u0006\u0010<\u001a\u00020=H\u0016J\b\u0010>\u001a\u00020?H\u0016J\n\u0010@\u001a\u0004\u0018\u00010AH\u0016J\n\u0010B\u001a\u0004\u0018\u00010CH\u0016J\n\u0010D\u001a\u0004\u0018\u00010EH\u0016J\b\u0010F\u001a\u00020\u0011H\u0016J\b\u0010G\u001a\u00020 H\u0016J\u0006\u0010J\u001a\u00020\u0014J\b\u0010K\u001a\u00020\u0014H\u0016J\b\u0010L\u001a\u00020\u0014H\u0016J\b\u0010M\u001a\u00020\u0014H\u0016J\b\u0010N\u001a\u00020\u0014H\u0016J\u0006\u0010O\u001a\u00020\u0014J\u0006\u0010P\u001a\u00020\u0014J\u0006\u0010Q\u001a\u00020\u0014J\u0006\u0010R\u001a\u00020\u0011J\n\u0010S\u001a\u0004\u0018\u00010TH\u0016J\u0010\u0010U\u001a\u00020 2\u0006\u0010V\u001a\u00020WH\u0002J.\u0010X\u001a\u00020\u00142\b\u0010Y\u001a\u0004\u0018\u00010'2\u0006\u0010Z\u001a\u00020\u00142\b\u0010[\u001a\u0004\u0018\u00010\\2\b\u0010]\u001a\u0004\u0018\u00010^H\u0016J(\u0010_\u001a\u00020\u00142\u0006\u0010Y\u001a\u00020'2\u0006\u0010Z\u001a\u00020\u00142\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020^H\u0002J,\u0010`\u001a\u00020\u00142\b\u0010Y\u001a\u0004\u0018\u00010'2\u0006\u0010Z\u001a\u00020\u00142\u0006\u0010[\u001a\u00020\\2\b\u0010]\u001a\u0004\u0018\u00010^H\u0016J\b\u0010a\u001a\u00020bH\u0016J\u0006\u0010c\u001a\u00020 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\"\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R*\u0010%\u001a\u0010\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u0014\u0018\u00010&8DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u000e\u00101\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00102\u001a\b\u0012\u0004\u0012\u000204038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0011\u0010H\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\bH\u0010I\u00a8\u0006e"}, d2={"Lcom/the9grounds/aeadditions/me/storage/AEAdditionsCellInventory;", "Lappeng/api/storage/cells/StorageCell;", "cellType", "Lcom/the9grounds/aeadditions/item/storage/StorageCell;", "itemStackLocal", "Lnet/minecraft/world/item/ItemStack;", "container", "Lappeng/api/storage/cells/ISaveProvider;", "<init>", "(Lcom/the9grounds/aeadditions/item/storage/StorageCell;Lnet/minecraft/world/item/ItemStack;Lappeng/api/storage/cells/ISaveProvider;)V", "getCellType", "()Lcom/the9grounds/aeadditions/item/storage/StorageCell;", "getItemStackLocal", "()Lnet/minecraft/world/item/ItemStack;", "getContainer", "()Lappeng/api/storage/cells/ISaveProvider;", "maxItemTypes", "", "storedItems", "storedItemCount", "", "value", "Lappeng/util/prioritylist/IPartitionList;", "partitionList", "getPartitionList", "()Lappeng/util/prioritylist/IPartitionList;", "Lappeng/api/config/IncludeExclude;", "partitionListMode", "getPartitionListMode", "()Lappeng/api/config/IncludeExclude;", "maxItemsPerType", "hasVoidUpgrade", "", "keyType", "Lappeng/api/stacks/AEKeyType;", "getKeyType", "()Lappeng/api/stacks/AEKeyType;", "cellItems", "", "Lappeng/api/stacks/AEKey;", "getCellItems", "()Ljava/util/Map;", "setCellItems", "(Ljava/util/Map;)V", "itemsPerByte", "getItemsPerByte", "()I", "setItemsPerByte", "(I)V", "isPersisted", "storedStacks", "", "Lappeng/api/stacks/GenericStack;", "getStoredStacks", "()Ljava/util/List;", "persist", "", "saveChanges", "loadCellItems", "getAvailableStacks", "out", "Lappeng/api/stacks/KeyCounter;", "getIdleDrain", "", "getFuzzyMode", "Lappeng/api/config/FuzzyMode;", "getConfigInventory", "Lappeng/util/ConfigInventory;", "getUpgradesInventory", "Lappeng/api/upgrades/IUpgradeInventory;", "getBytesPerType", "canHoldNewItem", "isPreformatted", "()Z", "getTotalBytes", "getFreeBytes", "getTotalItemTypes", "getStoredItemCount", "getStoredItemTypes", "getRemainingItemTypes", "getUsedBytes", "getRemainingItemCount", "getUnusedItemCount", "getStatus", "Lappeng/api/storage/cells/CellState;", "isStorageCell", "key", "Lappeng/api/stacks/AEItemKey;", "insert", "what", "amount", "mode", "Lappeng/api/config/Actionable;", "source", "Lappeng/api/networking/security/IActionSource;", "innerInsert", "extract", "getDescription", "Lnet/minecraft/network/chat/Component;", "isFuzzy", "Companion", "AEAdditions-1.21.1-6.0.2"})
public final class AEAdditionsCellInventory
implements appeng.api.storage.cells.StorageCell {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StorageCell cellType;
    @NotNull
    private final ItemStack itemStackLocal;
    @Nullable
    private final ISaveProvider container;
    private int maxItemTypes;
    private int storedItems;
    private long storedItemCount;
    @Nullable
    private IPartitionList partitionList;
    @Nullable
    private IncludeExclude partitionListMode;
    private long maxItemsPerType;
    private boolean hasVoidUpgrade;
    @NotNull
    private final AEKeyType keyType;
    @Nullable
    private Map<AEKey, Long> cellItems;
    private int itemsPerByte;
    private boolean isPersisted;
    private static final int MAX_ITEM_TYPES = 300;

    public AEAdditionsCellInventory(@NotNull StorageCell cellType, @NotNull ItemStack itemStackLocal, @Nullable ISaveProvider container) {
        Intrinsics.checkNotNullParameter((Object)cellType, (String)"cellType");
        Intrinsics.checkNotNullParameter((Object)itemStackLocal, (String)"itemStackLocal");
        this.cellType = cellType;
        this.itemStackLocal = itemStackLocal;
        this.container = container;
        this.maxItemTypes = MAX_ITEM_TYPES;
        StorageCell storageCell = this.cellType;
        Intrinsics.checkNotNull((Object)storageCell);
        this.keyType = storageCell.getKeyType();
        this.isPersisted = true;
        AEKeyType aEKeyType = this.keyType;
        Intrinsics.checkNotNull((Object)aEKeyType);
        this.itemsPerByte = aEKeyType.getAmountPerByte();
        StorageCell storageCell2 = this.cellType;
        Intrinsics.checkNotNull((Object)storageCell2);
        this.maxItemTypes = storageCell2.getTotalTypes(this.itemStackLocal);
        if (this.maxItemTypes > MAX_ITEM_TYPES) {
            this.maxItemTypes = MAX_ITEM_TYPES;
        }
        if (this.maxItemTypes < 1) {
            this.maxItemTypes = 1;
        }
        List<GenericStack> storedStacks = this.getStoredStacks();
        this.storedItems = storedStacks.size();
        this.storedItemCount = storedStacks.stream().mapToLong(arg_0 -> AEAdditionsCellInventory._init_$lambda$0(1.INSTANCE, arg_0)).sum();
        this.cellItems = null;
        IPartitionList.Builder builder = IPartitionList.builder();
        IUpgradeInventory upgrades = this.getUpgradesInventory();
        ConfigInventory config = this.getConfigInventory();
        IUpgradeInventory iUpgradeInventory = upgrades;
        Intrinsics.checkNotNull((Object)iUpgradeInventory);
        boolean hasInverter = iUpgradeInventory.isInstalled((ItemLike)AEItems.INVERTER_CARD);
        boolean isFuzzy = upgrades.isInstalled((ItemLike)AEItems.FUZZY_CARD);
        if (isFuzzy) {
            builder.fuzzyMode(this.getFuzzyMode());
        }
        ConfigInventory configInventory = config;
        Intrinsics.checkNotNull((Object)configInventory);
        builder.addAll((Iterable)configInventory.keySet());
        this.partitionListMode = hasInverter ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST;
        this.partitionList = builder.build();
        if (upgrades.isInstalled((ItemLike)AEItems.EQUAL_DISTRIBUTION_CARD)) {
            long maxTypes = Integer.MAX_VALUE;
            if (!isFuzzy && this.partitionListMode == IncludeExclude.WHITELIST && !config.keySet().isEmpty()) {
                maxTypes = config.keySet().size();
            }
            maxTypes = Math.min(maxTypes, (long)this.maxItemTypes);
            long totalStorage = (this.getTotalBytes() - (long)this.getBytesPerType() * maxTypes) * (long)this.keyType.getAmountPerByte();
            this.maxItemsPerType = Math.max(0L, (totalStorage + maxTypes - 1L) / maxTypes);
        } else {
            this.maxItemsPerType = Long.MAX_VALUE;
        }
        this.hasVoidUpgrade = upgrades.isInstalled((ItemLike)AEItems.VOID_CARD);
    }

    @NotNull
    public final StorageCell getCellType() {
        return this.cellType;
    }

    @NotNull
    public final ItemStack getItemStackLocal() {
        return this.itemStackLocal;
    }

    @Nullable
    public final ISaveProvider getContainer() {
        return this.container;
    }

    @Nullable
    public final IPartitionList getPartitionList() {
        return this.partitionList;
    }

    @Nullable
    public final IncludeExclude getPartitionListMode() {
        return this.partitionListMode;
    }

    @NotNull
    public final AEKeyType getKeyType() {
        return this.keyType;
    }

    @Nullable
    protected final Map<AEKey, Long> getCellItems() {
        if (this.cellItems == null) {
            this.cellItems = (Map)new Object2LongOpenHashMap();
            this.loadCellItems();
        }
        return this.cellItems;
    }

    protected final void setCellItems(@Nullable Map<AEKey, Long> map) {
        this.cellItems = map;
    }

    protected final int getItemsPerByte() {
        return this.itemsPerByte;
    }

    protected final void setItemsPerByte(int n) {
        this.itemsPerByte = n;
    }

    private final List<GenericStack> getStoredStacks() {
        Object object = this.itemStackLocal.getOrDefault(AEComponents.STORAGE_CELL_INV, (Object)CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrDefault(...)");
        return (List)object;
    }

    public void persist() {
        if (this.isPersisted) {
            return;
        }
        long itemCount = 0L;
        List stacks = new ArrayList();
        Map<AEKey, Long> map = this.getCellItems();
        Intrinsics.checkNotNull(map);
        for (Map.Entry<AEKey, Long> entry : map.entrySet()) {
            long amount = ((Number)entry.getValue()).longValue();
            if (amount <= 0L) continue;
            itemCount += amount;
            stacks.add(new GenericStack(entry.getKey(), amount));
        }
        List list = stacks.isEmpty() ? (List)this.itemStackLocal.remove(AEComponents.STORAGE_CELL_INV) : (List)this.itemStackLocal.set(AEComponents.STORAGE_CELL_INV, (Object)stacks);
        Map<AEKey, Long> map2 = this.getCellItems();
        Intrinsics.checkNotNull(map2);
        this.storedItems = map2.size();
        this.storedItemCount = itemCount;
        this.isPersisted = true;
    }

    protected void saveChanges() {
        Map<AEKey, Long> map = this.getCellItems();
        Intrinsics.checkNotNull(map);
        this.storedItems = map.size();
        this.storedItemCount = 0L;
        Map<AEKey, Long> map2 = this.getCellItems();
        Intrinsics.checkNotNull(map2);
        Iterator<Long> iterator = map2.values().iterator();
        while (iterator.hasNext()) {
            long storedAmount = ((Number)iterator.next()).longValue();
            this.storedItemCount += storedAmount;
        }
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    private final void loadCellItems() {
        List<GenericStack> storedStacks = this.getStoredStacks();
        for (GenericStack storedStack : storedStacks) {
            Map<AEKey, Long> map = this.getCellItems();
            Intrinsics.checkNotNull(map);
            map.put(storedStack.what(), storedStack.amount());
        }
    }

    public void getAvailableStacks(@NotNull KeyCounter out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Map<AEKey, Long> map = this.getCellItems();
        Intrinsics.checkNotNull(map);
        for (Map.Entry<AEKey, Long> entry : map.entrySet()) {
            out.add(entry.getKey(), ((Number)entry.getValue()).longValue());
        }
    }

    public double getIdleDrain() {
        StorageCell storageCell = this.cellType;
        Intrinsics.checkNotNull((Object)storageCell);
        return storageCell.getIdleDrain();
    }

    @Nullable
    public FuzzyMode getFuzzyMode() {
        StorageCell storageCell = this.cellType;
        Intrinsics.checkNotNull((Object)storageCell);
        return storageCell.getFuzzyMode(this.itemStackLocal);
    }

    @Nullable
    public ConfigInventory getConfigInventory() {
        StorageCell storageCell = this.cellType;
        Intrinsics.checkNotNull((Object)storageCell);
        return storageCell.getConfigInventory(this.itemStackLocal);
    }

    @Nullable
    public IUpgradeInventory getUpgradesInventory() {
        StorageCell storageCell = this.cellType;
        Intrinsics.checkNotNull((Object)storageCell);
        return storageCell.getUpgrades(this.itemStackLocal);
    }

    public int getBytesPerType() {
        StorageCell storageCell = this.cellType;
        Intrinsics.checkNotNull((Object)storageCell);
        return storageCell.getBytesPerType(this.itemStackLocal);
    }

    public boolean canHoldNewItem() {
        long bytesFree = this.getFreeBytes();
        return (bytesFree > (long)this.getBytesPerType() || bytesFree == (long)this.getBytesPerType() && this.getUnusedItemCount() > 0) && this.getRemainingItemTypes() > 0L;
    }

    public final boolean isPreformatted() {
        IPartitionList iPartitionList = this.partitionList;
        Intrinsics.checkNotNull((Object)iPartitionList);
        return !iPartitionList.isEmpty();
    }

    public final long getTotalBytes() {
        StorageCell storageCell = this.cellType;
        Intrinsics.checkNotNull((Object)storageCell);
        return storageCell.getBytes(this.itemStackLocal);
    }

    public long getFreeBytes() {
        return this.getTotalBytes() - this.getUsedBytes();
    }

    public long getTotalItemTypes() {
        return this.maxItemTypes;
    }

    public long getStoredItemCount() {
        return this.storedItemCount;
    }

    public long getStoredItemTypes() {
        return this.storedItems;
    }

    public final long getRemainingItemTypes() {
        long baseOnTotal;
        long basedOnStorage = this.getFreeBytes() / (long)this.getBytesPerType();
        return basedOnStorage > (baseOnTotal = this.getTotalItemTypes() - this.getStoredItemTypes()) ? baseOnTotal : basedOnStorage;
    }

    public final long getUsedBytes() {
        long bytesForItemCount = (this.getStoredItemCount() + (long)this.getUnusedItemCount()) / (long)this.itemsPerByte;
        return this.getStoredItemTypes() * (long)this.getBytesPerType() + bytesForItemCount;
    }

    public final long getRemainingItemCount() {
        long remaining = this.getFreeBytes() * (long)this.itemsPerByte + (long)this.getUnusedItemCount();
        return remaining > 0L ? remaining : 0L;
    }

    public final int getUnusedItemCount() {
        int div = (int)(this.getStoredItemCount() % (long)8);
        return div == 0 ? 0 : this.itemsPerByte - div;
    }

    @Nullable
    public CellState getStatus() {
        if (this.getStoredItemTypes() == 0L) {
            return CellState.EMPTY;
        }
        if (this.canHoldNewItem()) {
            return CellState.NOT_EMPTY;
        }
        return this.getRemainingItemCount() > 0L ? CellState.TYPES_FULL : CellState.FULL;
    }

    private final boolean isStorageCell(AEItemKey key) {
        IAEAdditionsStorageCell type = AEAdditionsCellInventory.Companion.getStorageCell(key);
        return type != null && !type.storableInStorageCell();
    }

    public long insert(@Nullable AEKey what, long amount, @Nullable Actionable mode, @Nullable IActionSource source) {
        block6: {
            block5: {
                if (amount == 0L) break block5;
                AEKeyType aEKeyType = this.keyType;
                Intrinsics.checkNotNull((Object)aEKeyType);
                if (aEKeyType.contains(what)) break block6;
            }
            return 0L;
        }
        IPartitionList iPartitionList = this.partitionList;
        Intrinsics.checkNotNull((Object)iPartitionList);
        if (!iPartitionList.matchesFilter(what, this.partitionListMode)) {
            return 0L;
        }
        StorageCell storageCell = this.cellType;
        Intrinsics.checkNotNull((Object)storageCell);
        if (storageCell.isBlackListed(this.itemStackLocal, what)) {
            return 0L;
        }
        AEKey aEKey = what;
        Intrinsics.checkNotNull((Object)aEKey);
        Actionable actionable = mode;
        Intrinsics.checkNotNull((Object)actionable);
        IActionSource iActionSource = source;
        Intrinsics.checkNotNull((Object)iActionSource);
        long inserted = this.innerInsert(aEKey, amount, actionable, iActionSource);
        return this.hasVoidUpgrade ? amount : inserted;
    }

    private final long innerInsert(AEKey what, long amount, Actionable mode, IActionSource source) {
        long _amount;
        if (what instanceof AEItemKey && this.isStorageCell((AEItemKey)what)) {
            ItemStack itemStack = ((AEItemKey)what).toStack();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"toStack(...)");
            AEAdditionsCellInventory meInventory = Companion.createInventory(itemStack, null);
            if (!AEAdditionsCellInventory.Companion.isCellEmpty(meInventory)) {
                return 0L;
            }
        }
        Map<AEKey, Long> map = this.getCellItems();
        Intrinsics.checkNotNull(map);
        Long l = map.get(what);
        long currentAmount = l != null ? l : 0L;
        long remainingItemCount = this.getRemainingItemCount();
        if (currentAmount <= 0L) {
            if (!this.canHoldNewItem()) {
                return 0L;
            }
            long l2 = this.getBytesPerType();
            AEKeyType aEKeyType = this.keyType;
            Intrinsics.checkNotNull((Object)aEKeyType);
            if ((remainingItemCount -= l2 * (long)aEKeyType.getAmountPerByte()) <= 0L) {
                return 0L;
            }
        }
        if ((_amount = amount) > (remainingItemCount = Math.max(0L, Math.min(this.maxItemsPerType - currentAmount, remainingItemCount)))) {
            _amount = remainingItemCount;
        }
        if (mode == Actionable.MODULATE) {
            Map<AEKey, Long> map2 = this.getCellItems();
            Intrinsics.checkNotNull(map2);
            map2.put(what, currentAmount + _amount);
            this.saveChanges();
        }
        return _amount;
    }

    public long extract(@Nullable AEKey what, long amount, @NotNull Actionable mode, @Nullable IActionSource source) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        long extractAmount = Math.min(Integer.MAX_VALUE, amount);
        Map<AEKey, Long> map = this.getCellItems();
        Intrinsics.checkNotNull(map);
        Long currentAmount = map.get(what);
        if (currentAmount != null && currentAmount > 0L) {
            if (extractAmount > currentAmount) {
                if (mode == Actionable.MODULATE) {
                    Map<AEKey, Long> map2 = this.getCellItems();
                    Intrinsics.checkNotNull(map2);
                    TypeIntrinsics.asMutableMap(map2).remove(what, currentAmount);
                    this.saveChanges();
                }
                return currentAmount;
            }
            if (mode == Actionable.MODULATE) {
                Map<AEKey, Long> map3 = this.getCellItems();
                Intrinsics.checkNotNull(map3);
                AEKey aEKey = what;
                Intrinsics.checkNotNull((Object)aEKey);
                map3.put(aEKey, currentAmount - extractAmount);
                this.saveChanges();
            }
            return extractAmount;
        }
        return 0L;
    }

    @NotNull
    public Component getDescription() {
        Component component = this.itemStackLocal.getHoverName();
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getHoverName(...)");
        return component;
    }

    public final boolean isFuzzy() {
        return this.partitionList instanceof FuzzyPriorityList;
    }

    private static final long _init_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).longValue();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\tJ\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/the9grounds/aeadditions/me/storage/AEAdditionsCellInventory$Companion;", "", "<init>", "()V", "MAX_ITEM_TYPES", "", "getStorageCell", "Lcom/the9grounds/aeadditions/api/IAEAdditionsStorageCell;", "input", "Lnet/minecraft/world/item/ItemStack;", "itemKey", "Lappeng/api/stacks/AEItemKey;", "isCellEmpty", "", "cellInventory", "Lcom/the9grounds/aeadditions/me/storage/AEAdditionsCellInventory;", "isCell", "itemStack", "createInventory", "container", "Lappeng/api/storage/cells/ISaveProvider;", "AEAdditions-1.21.1-6.0.2"})
    public static final class Companion {
        private Companion() {
        }

        private final IAEAdditionsStorageCell getStorageCell(ItemStack input) {
            if (input != null && input.getItem() instanceof StorageCell) {
                Item item = input.getItem();
                Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type com.the9grounds.aeadditions.item.storage.StorageCell");
                return (StorageCell)item;
            }
            return null;
        }

        private final IAEAdditionsStorageCell getStorageCell(AEItemKey itemKey) {
            if (itemKey.getItem() instanceof StorageCell) {
                Item item = itemKey.getItem();
                Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type com.the9grounds.aeadditions.item.storage.StorageCell");
                return (StorageCell)item;
            }
            return null;
        }

        private final boolean isCellEmpty(AEAdditionsCellInventory cellInventory) {
            if (cellInventory == null) {
                return true;
            }
            return cellInventory.getAvailableStacks().isEmpty();
        }

        public final boolean isCell(@Nullable ItemStack itemStack) {
            return this.getStorageCell(itemStack) != null;
        }

        @Nullable
        public final AEAdditionsCellInventory createInventory(@NotNull ItemStack itemStack, @Nullable ISaveProvider container) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            Item item = itemStack.getItem();
            if (!(item instanceof StorageCell)) {
                return null;
            }
            if (!((StorageCell)item).isStorageCell(itemStack)) {
                return null;
            }
            return new AEAdditionsCellInventory((StorageCell)item, itemStack, container);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

