/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.me.storage;

import appeng.api.config.IncludeExclude;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.ISaveProvider;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import com.the9grounds.aeadditions.item.storage.DiskCell;
import com.the9grounds.aeadditions.me.storage.ExtendedDiskCellInventory;
import io.github.projectet.ae2things.AE2Things;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u001e\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a8\u0006\u0012"}, d2={"Lcom/the9grounds/aeadditions/me/storage/ExtendedDiskCellHandler;", "Lappeng/api/storage/cells/ICellHandler;", "<init>", "()V", "isCell", "", "is", "Lnet/minecraft/world/item/ItemStack;", "getCellInventory", "Lcom/the9grounds/aeadditions/me/storage/ExtendedDiskCellInventory;", "container", "Lappeng/api/storage/cells/ISaveProvider;", "addCellInformationToTooltip", "", "stack", "lines", "", "Lnet/minecraft/network/chat/Component;", "AEAdditions-1.21.1-6.0.2"})
public final class ExtendedDiskCellHandler
implements ICellHandler {
    @NotNull
    public static final ExtendedDiskCellHandler INSTANCE = new ExtendedDiskCellHandler();

    private ExtendedDiskCellHandler() {
    }

    public boolean isCell(@Nullable ItemStack is) {
        ItemStack itemStack = is;
        Intrinsics.checkNotNull((Object)itemStack);
        return itemStack.getItem() instanceof DiskCell;
    }

    @Nullable
    public ExtendedDiskCellInventory getCellInventory(@Nullable ItemStack is, @Nullable ISaveProvider container) {
        if (is == null) {
            return null;
        }
        return ExtendedDiskCellInventory.Companion.createInventory(is, container, AE2Things.currentStorageManager());
    }

    public final void addCellInformationToTooltip(@NotNull ItemStack stack, @NotNull List<Component> lines) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        ExtendedDiskCellInventory handler = this.getCellInventory(stack, null);
        if (handler != null) {
            if (handler.hasDiskUUID()) {
                MutableComponent mutableComponent = Component.literal((String)"Disk UUID: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(handler.getDiskUUID())).withStyle(ChatFormatting.AQUA));
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"append(...)");
                lines.add((Component)mutableComponent);
                Component component = Tooltips.bytesUsed((long)handler.getNbtItemCount(), (long)handler.getTotalBytes());
                Intrinsics.checkNotNullExpressionValue((Object)component, (String)"bytesUsed(...)");
                lines.add(component);
            }
            if (handler.isPreformatted()) {
                MutableComponent list = (handler.getPartitionListMode() == IncludeExclude.WHITELIST ? GuiText.Included : GuiText.Excluded).text();
                if (handler.isFuzzy()) {
                    MutableComponent mutableComponent = GuiText.Partitioned.withSuffix(" - ").append((Component)list).append(" ").append((Component)GuiText.Fuzzy.text());
                    Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"append(...)");
                    v3 = lines.add((Component)mutableComponent);
                } else {
                    MutableComponent mutableComponent = GuiText.Partitioned.withSuffix(" - ").append((Component)list).append(" ").append((Component)GuiText.Precise.text());
                    Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"append(...)");
                    v3 = lines.add((Component)mutableComponent);
                }
            }
        }
    }
}

