/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.me.storage;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.core.AELog;
import appeng.core.definitions.AEItems;
import appeng.util.ConfigInventory;
import appeng.util.prioritylist.FuzzyPriorityList;
import appeng.util.prioritylist.IPartitionList;
import com.the9grounds.aeadditions.api.IAEAdditionsDiskCell;
import io.github.projectet.ae2things.AE2Things;
import io.github.projectet.ae2things.util.DataStorage;
import io.github.projectet.ae2things.util.StorageManager;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Objects;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ramidzkh.mekae2.ae2.MekanismKeyType;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 h2\u00020\u0001:\u0001hB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010 \u001a\u00020!H\u0002J\b\u0010&\u001a\u00020!H\u0002J\b\u00106\u001a\u000207H\u0016J\b\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020!H\u0016J\n\u0010>\u001a\u0004\u0018\u00010?H\u0016J\u0006\u0010@\u001a\u00020\u001fJ\u0010\u0010E\u001a\u00020\u001f2\u0006\u0010F\u001a\u00020GH\u0002J\u0010\u0010K\u001a\u00020!2\u0006\u0010L\u001a\u00020MH\u0016J\b\u0010N\u001a\u00020!H\u0002J\b\u0010O\u001a\u00020!H\u0004J(\u0010R\u001a\u00020\u00172\u0006\u0010S\u001a\u00020\u001d2\u0006\u0010T\u001a\u00020\u00172\u0006\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020XH\u0016J(\u0010Y\u001a\u00020\u00172\u0006\u0010S\u001a\u00020\u001d2\u0006\u0010T\u001a\u00020\u00172\u0006\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020XH\u0016J\u0006\u0010g\u001a\u00020\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0011\u0010'\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010(R\u0011\u0010*\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0011\u0010.\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0011\u00102\u001a\u0002038F\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0011\u00108\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u0013\u0010A\u001a\u0004\u0018\u00010B8F\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u001c\u0010H\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001c8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u0010JR\u0011\u0010P\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\bQ\u0010\u001aR\u0011\u0010Z\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b[\u0010\u001aR\u0011\u0010\\\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b]\u0010^R\u0011\u0010_\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b`\u0010\u001aR\u0011\u0010a\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\bb\u0010\u001aR\u0011\u0010c\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\bd\u0010\u001aR\u0011\u0010e\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\bf\u0010\u001a\u00a8\u0006i"}, d2={"Lcom/the9grounds/aeadditions/me/storage/ExtendedDiskCellInventory;", "Lappeng/api/storage/cells/StorageCell;", "cellType", "Lcom/the9grounds/aeadditions/api/IAEAdditionsDiskCell;", "i", "Lnet/minecraft/world/item/ItemStack;", "container", "Lappeng/api/storage/cells/ISaveProvider;", "storageManager", "Lio/github/projectet/ae2things/util/StorageManager;", "<init>", "(Lcom/the9grounds/aeadditions/api/IAEAdditionsDiskCell;Lnet/minecraft/world/item/ItemStack;Lappeng/api/storage/cells/ISaveProvider;Lio/github/projectet/ae2things/util/StorageManager;)V", "keyType", "Lappeng/api/stacks/AEKeyType;", "partitionList", "Lappeng/util/prioritylist/IPartitionList;", "value", "Lappeng/api/config/IncludeExclude;", "partitionListMode", "getPartitionListMode", "()Lappeng/api/config/IncludeExclude;", "storedItems", "", "", "storedItemCount", "getStoredItemCount", "()J", "storedAmounts", "Lit/unimi/dsi/fastutil/objects/Object2LongMap;", "Lappeng/api/stacks/AEKey;", "isPersisted", "", "updateFilter", "", "diskStorage", "Lio/github/projectet/ae2things/util/DataStorage;", "getDiskStorage", "()Lio/github/projectet/ae2things/util/DataStorage;", "initData", "isPreformatted", "()Z", "isFuzzy", "configInventory", "Lappeng/util/ConfigInventory;", "getConfigInventory", "()Lappeng/util/ConfigInventory;", "fuzzyMode", "Lappeng/api/config/FuzzyMode;", "getFuzzyMode", "()Lappeng/api/config/FuzzyMode;", "upgradesInventory", "Lappeng/api/upgrades/IUpgradeInventory;", "getUpgradesInventory", "()Lappeng/api/upgrades/IUpgradeInventory;", "getStatus", "Lappeng/api/storage/cells/CellState;", "clientStatus", "getClientStatus", "()Lappeng/api/storage/cells/CellState;", "getIdleDrain", "", "persist", "getDescription", "Lnet/minecraft/network/chat/Component;", "hasDiskUUID", "diskUUID", "Ljava/util/UUID;", "getDiskUUID", "()Ljava/util/UUID;", "isStorageCell", "key", "Lappeng/api/stacks/AEItemKey;", "cellItems", "getCellItems", "()Lit/unimi/dsi/fastutil/objects/Object2LongMap;", "getAvailableStacks", "out", "Lappeng/api/stacks/KeyCounter;", "loadCellItems", "saveChanges", "remainingItemCount", "getRemainingItemCount", "insert", "what", "amount", "mode", "Lappeng/api/config/Actionable;", "source", "Lappeng/api/networking/security/IActionSource;", "extract", "totalBytes", "getTotalBytes", "divisible", "getDivisible", "()I", "freeBytes", "getFreeBytes", "usedSpace", "getUsedSpace", "nbtItemCount", "getNbtItemCount", "storedItemTypes", "getStoredItemTypes", "canHoldNewItem", "Companion", "AEAdditions-1.21.1-6.0.2"})
public final class ExtendedDiskCellInventory
implements StorageCell {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IAEAdditionsDiskCell cellType;
    @NotNull
    private final ItemStack i;
    @Nullable
    private final ISaveProvider container;
    @Nullable
    private final StorageManager storageManager;
    @NotNull
    private final AEKeyType keyType;
    @Nullable
    private IPartitionList partitionList;
    @Nullable
    private IncludeExclude partitionListMode;
    private int storedItems;
    private long storedItemCount;
    @Nullable
    private Object2LongMap<AEKey> storedAmounts;
    private boolean isPersisted;

    public ExtendedDiskCellInventory(@NotNull IAEAdditionsDiskCell cellType, @NotNull ItemStack i, @Nullable ISaveProvider container, @Nullable StorageManager storageManager) {
        Intrinsics.checkNotNullParameter((Object)cellType, (String)"cellType");
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        this.cellType = cellType;
        this.i = i;
        this.container = container;
        this.storageManager = storageManager;
        this.keyType = this.cellType.getKeyType();
        this.isPersisted = true;
        this.initData();
        this.updateFilter();
    }

    @Nullable
    public final IncludeExclude getPartitionListMode() {
        return this.partitionListMode;
    }

    public final long getStoredItemCount() {
        return this.storedItemCount;
    }

    private final void updateFilter() {
        IPartitionList.Builder builder = IPartitionList.builder();
        IUpgradeInventory upgrades = this.getUpgradesInventory();
        ConfigInventory config = this.getConfigInventory();
        boolean hasInverter = upgrades.isInstalled((ItemLike)AEItems.INVERTER_CARD);
        if (upgrades.isInstalled((ItemLike)AEItems.FUZZY_CARD)) {
            builder.fuzzyMode(this.getFuzzyMode());
        }
        builder.addAll((Iterable)config.keySet());
        this.partitionListMode = hasInverter ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST;
        this.partitionList = builder.build();
    }

    private final DataStorage getDiskStorage() {
        DataStorage dataStorage;
        if (this.getDiskUUID() != null && this.storageManager != null) {
            DataStorage dataStorage2 = this.storageManager.getOrCreateDisk(this.getDiskUUID());
            Intrinsics.checkNotNull((Object)dataStorage2);
            dataStorage = dataStorage2;
        } else {
            DataStorage dataStorage3 = DataStorage.EMPTY;
            Intrinsics.checkNotNull((Object)dataStorage3);
            dataStorage = dataStorage3;
        }
        return dataStorage;
    }

    private final void initData() {
        if (this.hasDiskUUID()) {
            this.storedItems = this.getDiskStorage().stackAmounts.length;
            this.storedItemCount = this.getDiskStorage().itemCount;
        } else {
            this.storedItems = 0;
            this.storedItemCount = 0L;
            this.getCellItems();
        }
    }

    public final boolean isPreformatted() {
        IPartitionList iPartitionList = this.partitionList;
        Intrinsics.checkNotNull((Object)iPartitionList);
        return !iPartitionList.isEmpty();
    }

    public final boolean isFuzzy() {
        return this.partitionList instanceof FuzzyPriorityList;
    }

    @NotNull
    public final ConfigInventory getConfigInventory() {
        return this.cellType.getConfigInventory(this.i);
    }

    @NotNull
    public final FuzzyMode getFuzzyMode() {
        FuzzyMode fuzzyMode = this.cellType.getFuzzyMode(this.i);
        Intrinsics.checkNotNullExpressionValue((Object)fuzzyMode, (String)"getFuzzyMode(...)");
        return fuzzyMode;
    }

    @NotNull
    public final IUpgradeInventory getUpgradesInventory() {
        IUpgradeInventory iUpgradeInventory = this.cellType.getUpgrades(this.i);
        Intrinsics.checkNotNullExpressionValue((Object)iUpgradeInventory, (String)"getUpgrades(...)");
        return iUpgradeInventory;
    }

    @NotNull
    public CellState getStatus() {
        if (this.storedItemCount == 0L) {
            return CellState.EMPTY;
        }
        if (this.canHoldNewItem()) {
            return CellState.NOT_EMPTY;
        }
        return CellState.FULL;
    }

    @NotNull
    public final CellState getClientStatus() {
        if (this.getNbtItemCount() == 0L) {
            return CellState.EMPTY;
        }
        if (this.getNbtItemCount() > 0L && this.getNbtItemCount() != this.getTotalBytes()) {
            return CellState.NOT_EMPTY;
        }
        return CellState.FULL;
    }

    public double getIdleDrain() {
        return this.cellType.getIdleDrain();
    }

    public void persist() {
        if (this.isPersisted || this.storageManager == null) {
            return;
        }
        if (this.storedItemCount == 0L) {
            if (this.hasDiskUUID()) {
                this.storageManager.removeDisk(this.getDiskUUID());
                this.i.remove(AE2Things.DATA_DISK_ID);
                this.i.remove(AE2Things.DATA_DISK_ITEM_COUNT);
                this.initData();
            }
            return;
        }
        long itemCount = 0L;
        Object2LongMap<AEKey> object2LongMap = this.storedAmounts;
        Intrinsics.checkNotNull(object2LongMap);
        LongArrayList amounts = new LongArrayList(object2LongMap.size());
        ListTag keys = new ListTag();
        Object2LongMap<AEKey> object2LongMap2 = this.storedAmounts;
        Intrinsics.checkNotNull(object2LongMap2);
        ObjectIterator objectIterator = object2LongMap2.object2LongEntrySet().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
        ObjectIterator objectIterator2 = objectIterator;
        while (objectIterator2.hasNext()) {
            Object2LongMap.Entry entry = (Object2LongMap.Entry)objectIterator2.next();
            long amount = entry.getLongValue();
            if (amount <= 0L) continue;
            itemCount += amount;
            keys.add((Object)((AEKey)entry.getKey()).toTagGeneric(this.storageManager.getRegistries()));
            amounts.add(amount);
        }
        if (keys.isEmpty()) {
            this.storageManager.updateDisk(this.getDiskUUID(), new DataStorage());
        } else {
            this.storageManager.modifyDisk(this.getDiskUUID(), keys, amounts.toArray(new long[0]), itemCount);
        }
        Object2LongMap<AEKey> object2LongMap3 = this.storedAmounts;
        Intrinsics.checkNotNull(object2LongMap3);
        this.storedItems = object2LongMap3.size();
        this.storedItemCount = itemCount;
        this.i.set(AE2Things.DATA_DISK_ITEM_COUNT, (Object)itemCount);
        this.isPersisted = true;
    }

    @Nullable
    public Component getDescription() {
        return null;
    }

    public final boolean hasDiskUUID() {
        return this.i.has(AE2Things.DATA_DISK_ID);
    }

    @Nullable
    public final UUID getDiskUUID() {
        return (UUID)this.i.get(AE2Things.DATA_DISK_ID);
    }

    private final boolean isStorageCell(AEItemKey key) {
        IAEAdditionsDiskCell type = ExtendedDiskCellInventory.Companion.getStorageCell(key);
        return type != null && !type.storableInStorageCell();
    }

    @Nullable
    protected final Object2LongMap<AEKey> getCellItems() {
        if (this.storedAmounts == null) {
            this.storedAmounts = (Object2LongMap)new Object2LongOpenHashMap();
            this.loadCellItems();
        }
        return this.storedAmounts;
    }

    public void getAvailableStacks(@NotNull KeyCounter out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Object2LongMap<AEKey> object2LongMap = this.getCellItems();
        Intrinsics.checkNotNull(object2LongMap);
        ObjectIterator objectIterator = object2LongMap.object2LongEntrySet().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
        ObjectIterator objectIterator2 = objectIterator;
        while (objectIterator2.hasNext()) {
            Object2LongMap.Entry entry = (Object2LongMap.Entry)objectIterator2.next();
            out.add((AEKey)entry.getKey(), entry.getLongValue());
        }
    }

    private final void loadCellItems() {
        if (this.storageManager == null) {
            return;
        }
        DataStorage diskStorage = this.getDiskStorage();
        long[] amounts = diskStorage.stackAmounts;
        ListTag tags = diskStorage.stackKeys;
        if (amounts.length != tags.size()) {
            Object[] objectArray = new Object[]{amounts.length, tags.size()};
            AELog.warn((String)"Loading storage cell with mismatched amounts/tags: %d != %d", (Object[])objectArray);
        }
        boolean corruptedTag = false;
        HolderLookup.Provider registries = this.storageManager.getRegistries();
        int n = amounts.length;
        for (int i = 0; i < n; ++i) {
            long amount = amounts[i];
            AEKey key = AEKey.fromTagGeneric((HolderLookup.Provider)registries, (CompoundTag)tags.getCompound(i));
            if (amount <= 0L || key == null) {
                corruptedTag = true;
                continue;
            }
            Object2LongMap<AEKey> object2LongMap = this.storedAmounts;
            Intrinsics.checkNotNull(object2LongMap);
            object2LongMap.put((Object)key, amount);
        }
        if (corruptedTag) {
            this.saveChanges();
        }
    }

    protected final void saveChanges() {
        Object2LongMap<AEKey> object2LongMap = this.storedAmounts;
        Intrinsics.checkNotNull(object2LongMap);
        this.storedItems = object2LongMap.size();
        this.storedItemCount = 0L;
        Object2LongMap<AEKey> object2LongMap2 = this.storedAmounts;
        Intrinsics.checkNotNull(object2LongMap2);
        LongIterator longIterator = ((LongCollection)object2LongMap2.values()).iterator();
        Intrinsics.checkNotNullExpressionValue((Object)longIterator, (String)"iterator(...)");
        LongIterator longIterator2 = longIterator;
        while (longIterator2.hasNext()) {
            Long storedAmount = longIterator2.next();
            Intrinsics.checkNotNull((Object)storedAmount);
            this.storedItemCount += storedAmount.longValue();
        }
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    public final long getRemainingItemCount() {
        return this.getFreeBytes() > 0L ? this.getFreeBytes() : 0L;
    }

    public long insert(@NotNull AEKey what, long amount, @NotNull Actionable mode, @NotNull IActionSource source) {
        Intrinsics.checkNotNullParameter((Object)what, (String)"what");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        long amount2 = amount;
        if (amount2 == 0L || !this.keyType.contains(what)) {
            return 0L;
        }
        IPartitionList iPartitionList = this.partitionList;
        Intrinsics.checkNotNull((Object)iPartitionList);
        if (!iPartitionList.matchesFilter(what, this.partitionListMode)) {
            return 0L;
        }
        if (this.cellType.isBlackListed(this.i, what)) {
            return 0L;
        }
        if (what instanceof AEItemKey && this.isStorageCell((AEItemKey)what)) {
            ItemStack itemStack = ((AEItemKey)what).toStack();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"toStack(...)");
            ExtendedDiskCellInventory meInventory = Companion.createInventory(itemStack, null, this.storageManager);
            if (!ExtendedDiskCellInventory.Companion.isCellEmpty(meInventory)) {
                return 0L;
            }
        }
        if (this.storageManager != null && !this.hasDiskUUID()) {
            this.i.set(AE2Things.DATA_DISK_ID, (Object)UUID.randomUUID());
            this.storageManager.getOrCreateDisk(this.getDiskUUID());
            this.loadCellItems();
        }
        Object2LongMap<AEKey> object2LongMap = this.getCellItems();
        Intrinsics.checkNotNull(object2LongMap);
        long currentAmount = object2LongMap.getLong((Object)what);
        long remainingItemCount = this.getRemainingItemCount();
        if (amount2 > remainingItemCount) {
            amount2 = remainingItemCount;
        }
        if (mode == Actionable.MODULATE) {
            Object2LongMap<AEKey> object2LongMap2 = this.getCellItems();
            Intrinsics.checkNotNull(object2LongMap2);
            object2LongMap2.put((Object)what, currentAmount + amount2);
            this.saveChanges();
        }
        return amount2;
    }

    public long extract(@NotNull AEKey what, long amount, @NotNull Actionable mode, @NotNull IActionSource source) {
        Intrinsics.checkNotNullParameter((Object)what, (String)"what");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        long extractAmount = (long)Math.min(2.147483647E9, (double)amount);
        Object2LongMap<AEKey> object2LongMap = this.getCellItems();
        Intrinsics.checkNotNull(object2LongMap);
        long currentAmount = object2LongMap.getLong((Object)what);
        if (currentAmount > 0L) {
            if (extractAmount >= currentAmount) {
                if (mode == Actionable.MODULATE) {
                    Object2LongMap<AEKey> object2LongMap2 = this.getCellItems();
                    Intrinsics.checkNotNull(object2LongMap2);
                    object2LongMap2.removeLong((Object)what);
                    this.saveChanges();
                }
                return currentAmount;
            }
            if (mode == Actionable.MODULATE) {
                Object2LongMap<AEKey> object2LongMap3 = this.getCellItems();
                Intrinsics.checkNotNull(object2LongMap3);
                object2LongMap3.put((Object)what, currentAmount - extractAmount);
                this.saveChanges();
            }
            return extractAmount;
        }
        return 0L;
    }

    public final long getTotalBytes() {
        return this.cellType.getBytes(this.i);
    }

    public final int getDivisible() {
        AEKeyType aEKeyType = this.keyType;
        return Intrinsics.areEqual((Object)aEKeyType, (Object)AEKeyType.fluids()) ? 1000 : (Intrinsics.areEqual((Object)aEKeyType, (Object)AEKeyType.items()) ? 1 : (Intrinsics.areEqual((Object)aEKeyType, (Object)MekanismKeyType.TYPE) ? 1000 : 1));
    }

    public final long getFreeBytes() {
        return this.getTotalBytes() - this.storedItemCount / (long)this.getDivisible();
    }

    public final long getUsedSpace() {
        return this.getTotalBytes() - this.getFreeBytes();
    }

    public final long getNbtItemCount() {
        if (this.hasDiskUUID()) {
            Object object = this.i.getOrDefault(AE2Things.DATA_DISK_ITEM_COUNT, (Object)0L);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrDefault(...)");
            return ((Number)object).longValue();
        }
        return 0L;
    }

    public final long getStoredItemTypes() {
        return this.storedItems;
    }

    public final boolean canHoldNewItem() {
        return this.getFreeBytes() > 0L && this.getFreeBytes() != this.getTotalBytes();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/the9grounds/aeadditions/me/storage/ExtendedDiskCellInventory$Companion;", "", "<init>", "()V", "createInventory", "Lcom/the9grounds/aeadditions/me/storage/ExtendedDiskCellInventory;", "stack", "Lnet/minecraft/world/item/ItemStack;", "saveProvider", "Lappeng/api/storage/cells/ISaveProvider;", "storageManager", "Lio/github/projectet/ae2things/util/StorageManager;", "hasDiskUUID", "", "disk", "getStorageCell", "Lcom/the9grounds/aeadditions/api/IAEAdditionsDiskCell;", "itemKey", "Lappeng/api/stacks/AEItemKey;", "isCellEmpty", "inv", "AEAdditions-1.21.1-6.0.2"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ExtendedDiskCellInventory createInventory(@NotNull ItemStack stack, @Nullable ISaveProvider saveProvider, @Nullable StorageManager storageManager) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Objects.requireNonNull(stack, "Cannot create cell inventory for null itemstack");
            if (!(stack.getItem() instanceof IAEAdditionsDiskCell)) {
                return null;
            }
            Item item = stack.getItem();
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type com.the9grounds.aeadditions.api.IAEAdditionsDiskCell");
            IAEAdditionsDiskCell cellType = (IAEAdditionsDiskCell)item;
            if (!cellType.isStorageCell(stack)) {
                return null;
            }
            return new ExtendedDiskCellInventory(cellType, stack, saveProvider, storageManager);
        }

        public final boolean hasDiskUUID(@NotNull ItemStack disk) {
            Intrinsics.checkNotNullParameter((Object)disk, (String)"disk");
            if (disk.getItem() instanceof IAEAdditionsDiskCell) {
                return disk.has(AE2Things.DATA_DISK_ID);
            }
            return false;
        }

        private final IAEAdditionsDiskCell getStorageCell(AEItemKey itemKey) {
            if (itemKey.getItem() instanceof IAEAdditionsDiskCell) {
                Item item = itemKey.getItem();
                Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type com.the9grounds.aeadditions.api.IAEAdditionsDiskCell");
                return (IAEAdditionsDiskCell)item;
            }
            return null;
        }

        private final boolean isCellEmpty(ExtendedDiskCellInventory inv) {
            if (inv != null) {
                return inv.getAvailableStacks().isEmpty();
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

