/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.me.storage;

import appeng.api.config.Actionable;
import appeng.api.config.IncludeExclude;
import appeng.api.ids.AEComponents;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.AEKeyTypes;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import appeng.util.prioritylist.FuzzyPriorityList;
import appeng.util.prioritylist.IPartitionList;
import com.the9grounds.aeadditions.core.data.SuperStorageCellExtraInfo;
import com.the9grounds.aeadditions.item.storage.SuperStorageCell;
import com.the9grounds.aeadditions.registries.DataComponents;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 s2\u00020\u0001:\u0001sB#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010H\u001a\u00020IH\u0016J\b\u0010J\u001a\u00020IH\u0014J\b\u0010K\u001a\u00020IH\u0002J\b\u0010L\u001a\u00020IH\u0002J\u0010\u0010M\u001a\u00020I2\u0006\u0010N\u001a\u00020OH\u0016J\b\u0010P\u001a\u00020QH\u0016J\b\u0010R\u001a\u00020\u0013H\u0016J\u0006\u0010S\u001a\u00020\"J\u0006\u0010T\u001a\u00020\u0016J\u0006\u0010U\u001a\u00020\u0016J\b\u0010V\u001a\u00020\u0016H\u0016J\b\u0010W\u001a\u00020\u0016H\u0016J\u000e\u0010X\u001a\u00020\u00162\u0006\u0010Y\u001a\u000202J\b\u0010Z\u001a\u00020\u0016H\u0016J\u0006\u0010[\u001a\u00020\u0016J\u000e\u0010\\\u001a\u00020\u00162\u0006\u0010Y\u001a\u000202J\u0006\u0010]\u001a\u00020\u0016J\u0006\u0010^\u001a\u00020\u0016J\u000e\u0010_\u001a\u00020\u00162\u0006\u0010Y\u001a\u000202J\u0006\u0010`\u001a\u00020\u0013J\u000e\u0010a\u001a\u00020\u00132\u0006\u0010Y\u001a\u000202J\n\u0010b\u001a\u0004\u0018\u00010cH\u0016J\u0010\u0010d\u001a\u00020\"2\u0006\u0010e\u001a\u00020fH\u0002J.\u0010g\u001a\u00020\u00162\b\u0010h\u001a\u0004\u0018\u00010%2\u0006\u0010i\u001a\u00020\u00162\b\u0010j\u001a\u0004\u0018\u00010k2\b\u0010l\u001a\u0004\u0018\u00010mH\u0016J(\u0010n\u001a\u00020\u00162\u0006\u0010h\u001a\u00020%2\u0006\u0010i\u001a\u00020\u00162\u0006\u0010j\u001a\u00020k2\u0006\u0010l\u001a\u00020mH\u0002J,\u0010o\u001a\u00020\u00162\b\u0010h\u001a\u0004\u0018\u00010%2\u0006\u0010i\u001a\u00020\u00162\u0006\u0010j\u001a\u00020k2\b\u0010l\u001a\u0004\u0018\u00010mH\u0016J\b\u0010p\u001a\u00020qH\u0016J\u0006\u0010r\u001a\u00020\"R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\"\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u0017\u001a\u0004\u0018\u00010\u001c@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010#\u001a\u0010\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u0016\u0018\u00010$8DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u000e\u0010/\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u00101\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020\u00130$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010'\"\u0004\b4\u0010)R&\u00105\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020\u00160$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010'\"\u0004\b7\u0010)R7\u00108\u001a&\u0012\f\u0012\n :*\u0004\u0018\u00010202 :*\u0012\u0012\f\u0012\n :*\u0004\u0018\u00010202\u0018\u00010;09\u00a2\u0006\n\n\u0002\u0010>\u001a\u0004\b<\u0010=R\u001a\u0010?\u001a\b\u0012\u0004\u0012\u00020A0@8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR\u0014\u0010D\u001a\u00020E8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010G\u00a8\u0006t"}, d2={"Lcom/the9grounds/aeadditions/me/storage/SuperCellInventory;", "Lappeng/api/storage/cells/StorageCell;", "cell", "Lcom/the9grounds/aeadditions/item/storage/SuperStorageCell;", "itemStackLocal", "Lnet/minecraft/world/item/ItemStack;", "container", "Lappeng/api/storage/cells/ISaveProvider;", "<init>", "(Lcom/the9grounds/aeadditions/item/storage/SuperStorageCell;Lnet/minecraft/world/item/ItemStack;Lappeng/api/storage/cells/ISaveProvider;)V", "getCell", "()Lcom/the9grounds/aeadditions/item/storage/SuperStorageCell;", "getItemStackLocal", "()Lnet/minecraft/world/item/ItemStack;", "getContainer", "()Lappeng/api/storage/cells/ISaveProvider;", "tagCompound", "Lnet/minecraft/nbt/CompoundTag;", "maxItemTypes", "", "storedItems", "storedItemCount", "", "value", "Lappeng/util/prioritylist/IPartitionList;", "partitionList", "getPartitionList", "()Lappeng/util/prioritylist/IPartitionList;", "Lappeng/api/config/IncludeExclude;", "partitionListMode", "getPartitionListMode", "()Lappeng/api/config/IncludeExclude;", "maxItemsPerType", "hasVoidUpgrade", "", "cellItems", "", "Lappeng/api/stacks/AEKey;", "getCellItems", "()Ljava/util/Map;", "setCellItems", "(Ljava/util/Map;)V", "itemsPerByte", "getItemsPerByte", "()I", "setItemsPerByte", "(I)V", "isPersisted", "computedUsedBytes", "numberOfTypesByKeyType", "Lappeng/api/stacks/AEKeyType;", "getNumberOfTypesByKeyType", "setNumberOfTypesByKeyType", "storedItemCountByKeyType", "getStoredItemCountByKeyType", "setStoredItemCountByKeyType", "cellTypes", "", "kotlin.jvm.PlatformType", "", "getCellTypes", "()Ljava/util/Set;", "Ljava/util/Set;", "storedStacks", "", "Lappeng/api/stacks/GenericStack;", "getStoredStacks", "()Ljava/util/List;", "storedExtraInfo", "Lcom/the9grounds/aeadditions/core/data/SuperStorageCellExtraInfo;", "getStoredExtraInfo", "()Lcom/the9grounds/aeadditions/core/data/SuperStorageCellExtraInfo;", "persist", "", "saveChanges", "recalculateValues", "loadCellItems", "getAvailableStacks", "out", "Lappeng/api/stacks/KeyCounter;", "getIdleDrain", "", "getBytesPerType", "canHoldNewItem", "getTotalBytes", "getFreeBytes", "getTotalItemTypes", "getStoredItemCount", "getStoredItemCountForKeyType", "keyType", "getStoredItemTypes", "getRemainingItemTypes", "getUsedBytesForType", "getUsedBytes", "getRemainingItemCount", "getRemainingItemCountForKeyType", "getUnusedItemCount", "getUnusedItemCountForKeyType", "getStatus", "Lappeng/api/storage/cells/CellState;", "isStorageCell", "key", "Lappeng/api/stacks/AEItemKey;", "insert", "what", "amount", "mode", "Lappeng/api/config/Actionable;", "source", "Lappeng/api/networking/security/IActionSource;", "innerInsert", "extract", "getDescription", "Lnet/minecraft/network/chat/Component;", "isFuzzy", "Companion", "AEAdditions-1.21.1-6.0.2"})
public final class SuperCellInventory
implements StorageCell {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final SuperStorageCell cell;
    @NotNull
    private final ItemStack itemStackLocal;
    @Nullable
    private final ISaveProvider container;
    @Nullable
    private CompoundTag tagCompound;
    private int maxItemTypes;
    private int storedItems;
    private long storedItemCount;
    @Nullable
    private IPartitionList partitionList;
    @Nullable
    private IncludeExclude partitionListMode;
    private long maxItemsPerType;
    private boolean hasVoidUpgrade;
    @Nullable
    private Map<AEKey, Long> cellItems;
    private int itemsPerByte;
    private boolean isPersisted;
    private long computedUsedBytes;
    @NotNull
    private Map<AEKeyType, Integer> numberOfTypesByKeyType;
    @NotNull
    private Map<AEKeyType, Long> storedItemCountByKeyType;
    private final Set<AEKeyType> cellTypes;
    private static final int MAX_ITEM_TYPES = 1000;
    @NotNull
    private static final String ITEM_TYPE_TAG = "it";
    @NotNull
    private static final String ITEM_COUNT_TAG = "ic";
    @NotNull
    private static final String ITEM_SLOT = "#";
    @NotNull
    private static final String ITEM_SLOT_COUNT = "@";
    @NotNull
    private static final String STACK_KEYS = "keys";
    @NotNull
    private static final String STACK_AMOUNTS = "amts";
    @NotNull
    private static final String[] ITEM_SLOT_KEYS = new String[MAX_ITEM_TYPES];
    @NotNull
    private static final String[] ITEM_SLOT_COUNT_KEYS = new String[MAX_ITEM_TYPES];

    public SuperCellInventory(@Nullable SuperStorageCell cell, @NotNull ItemStack itemStackLocal, @Nullable ISaveProvider container) {
        Intrinsics.checkNotNullParameter((Object)itemStackLocal, (String)"itemStackLocal");
        this.cell = cell;
        this.itemStackLocal = itemStackLocal;
        this.container = container;
        this.maxItemTypes = MAX_ITEM_TYPES;
        this.maxItemsPerType = Long.MAX_VALUE;
        this.isPersisted = true;
        this.numberOfTypesByKeyType = new LinkedHashMap();
        this.storedItemCountByKeyType = new LinkedHashMap();
        this.cellTypes = AEKeyTypes.getAll();
        for (AEKeyType keyType : this.cellTypes) {
            this.numberOfTypesByKeyType.put(keyType, 0);
        }
        SuperStorageCell superStorageCell = this.cell;
        Intrinsics.checkNotNull((Object)((Object)superStorageCell));
        this.maxItemTypes = superStorageCell.getTotalTypes(this.itemStackLocal);
        if (this.maxItemTypes > MAX_ITEM_TYPES) {
            this.maxItemTypes = MAX_ITEM_TYPES;
        }
        if (this.maxItemTypes < 1) {
            this.maxItemTypes = 1;
        }
        List<GenericStack> storedStacks = this.getStoredStacks();
        this.storedItems = storedStacks.size();
        this.storedItemCount = storedStacks.stream().mapToLong(arg_0 -> SuperCellInventory._init_$lambda$0(1.INSTANCE, arg_0)).sum();
        this.computedUsedBytes = this.getStoredExtraInfo().getUsedBytes();
        this.cellItems = null;
        this.recalculateValues();
    }

    @Nullable
    public final SuperStorageCell getCell() {
        return this.cell;
    }

    @NotNull
    public final ItemStack getItemStackLocal() {
        return this.itemStackLocal;
    }

    @Nullable
    public final ISaveProvider getContainer() {
        return this.container;
    }

    @Nullable
    public final IPartitionList getPartitionList() {
        return this.partitionList;
    }

    @Nullable
    public final IncludeExclude getPartitionListMode() {
        return this.partitionListMode;
    }

    @Nullable
    protected final Map<AEKey, Long> getCellItems() {
        if (this.cellItems == null) {
            this.cellItems = (Map)new Object2LongOpenHashMap();
            this.loadCellItems();
        }
        return this.cellItems;
    }

    protected final void setCellItems(@Nullable Map<AEKey, Long> map) {
        this.cellItems = map;
    }

    protected final int getItemsPerByte() {
        return this.itemsPerByte;
    }

    protected final void setItemsPerByte(int n) {
        this.itemsPerByte = n;
    }

    @NotNull
    public final Map<AEKeyType, Integer> getNumberOfTypesByKeyType() {
        return this.numberOfTypesByKeyType;
    }

    public final void setNumberOfTypesByKeyType(@NotNull Map<AEKeyType, Integer> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.numberOfTypesByKeyType = map;
    }

    @NotNull
    public final Map<AEKeyType, Long> getStoredItemCountByKeyType() {
        return this.storedItemCountByKeyType;
    }

    public final void setStoredItemCountByKeyType(@NotNull Map<AEKeyType, Long> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.storedItemCountByKeyType = map;
    }

    public final Set<AEKeyType> getCellTypes() {
        return this.cellTypes;
    }

    private final List<GenericStack> getStoredStacks() {
        Object object = this.itemStackLocal.getOrDefault(AEComponents.STORAGE_CELL_INV, (Object)CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrDefault(...)");
        return (List)object;
    }

    private final SuperStorageCellExtraInfo getStoredExtraInfo() {
        Object object = this.itemStackLocal.getOrDefault(DataComponents.INSTANCE.getSUPER_STORAGE_CELL_EXTRA_INFO(), (Object)new SuperStorageCellExtraInfo(0L, 1, null));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrDefault(...)");
        return (SuperStorageCellExtraInfo)object;
    }

    public void persist() {
        if (this.isPersisted) {
            return;
        }
        long itemCount = 0L;
        Map localItemCountByKeyType = new LinkedHashMap();
        Map localNumberOfTypesByKeyType = new LinkedHashMap();
        Map<AEKey, Long> map = this.getCellItems();
        Intrinsics.checkNotNull(map);
        LongArrayList amounts = new LongArrayList(map.size());
        List stacks = new ArrayList();
        Map<AEKey, Long> map2 = this.getCellItems();
        Intrinsics.checkNotNull(map2);
        for (Map.Entry<AEKey, Long> entry : map2.entrySet()) {
            long amount = ((Number)entry.getValue()).longValue();
            if (amount <= 0L) continue;
            Long l = (Long)localItemCountByKeyType.get(entry.getKey().getType());
            long currentAmount = l != null ? l : 0L;
            localItemCountByKeyType.put(entry.getKey().getType(), currentAmount + amount);
            stacks.add(new GenericStack(entry.getKey(), amount));
            amounts.add(amount);
            Integer n = (Integer)localNumberOfTypesByKeyType.get(entry.getKey().getType());
            int currentNumber = n != null ? n : 0;
            localNumberOfTypesByKeyType.put(entry.getKey().getType(), currentNumber + 1);
        }
        List list = stacks.isEmpty() ? (List)this.itemStackLocal.remove(AEComponents.STORAGE_CELL_INV) : (List)this.itemStackLocal.set(AEComponents.STORAGE_CELL_INV, (Object)stacks);
        Map<AEKey, Long> map3 = this.getCellItems();
        Intrinsics.checkNotNull(map3);
        this.storedItems = map3.size();
        this.storedItemCount = itemCount;
        this.storedItemCountByKeyType = localItemCountByKeyType;
        this.numberOfTypesByKeyType = localNumberOfTypesByKeyType;
        long localComputedUsedBytes = 0L;
        for (AEKeyType keyType : this.cellTypes) {
            Intrinsics.checkNotNull((Object)keyType);
            localComputedUsedBytes += this.getUsedBytesForType(keyType);
        }
        this.computedUsedBytes = localComputedUsedBytes;
        SuperStorageCellExtraInfo extraInfo = new SuperStorageCellExtraInfo(this.computedUsedBytes);
        SuperStorageCellExtraInfo superStorageCellExtraInfo = extraInfo.hasDefaultValues() ? (SuperStorageCellExtraInfo)this.itemStackLocal.remove(DataComponents.INSTANCE.getSUPER_STORAGE_CELL_EXTRA_INFO()) : (SuperStorageCellExtraInfo)this.itemStackLocal.set(DataComponents.INSTANCE.getSUPER_STORAGE_CELL_EXTRA_INFO(), (Object)extraInfo);
        this.isPersisted = true;
    }

    protected void saveChanges() {
        this.recalculateValues();
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    private final void recalculateValues() {
        Map<AEKey, Long> map = this.getCellItems();
        Intrinsics.checkNotNull(map);
        this.storedItems = map.size();
        this.storedItemCount = 0L;
        Map localItemCountByKeyType = new LinkedHashMap();
        Map localNumberOfTypesByKeyType = new LinkedHashMap();
        Map<AEKey, Long> map2 = this.getCellItems();
        Intrinsics.checkNotNull(map2);
        for (Map.Entry<AEKey, Long> entry : map2.entrySet()) {
            Long l = (Long)localItemCountByKeyType.get(entry.getKey().getType());
            long currentAmount = l != null ? l : 0L;
            localItemCountByKeyType.put(entry.getKey().getType(), currentAmount + ((Number)entry.getValue()).longValue());
            Long l2 = entry.getValue();
            Intrinsics.checkNotNull((Object)l2);
            this.storedItemCount += ((Number)l2).longValue();
            Integer n = (Integer)localNumberOfTypesByKeyType.get(entry.getKey().getType());
            int currentNumber = n != null ? n : 0;
            localNumberOfTypesByKeyType.put(entry.getKey().getType(), currentNumber + 1);
        }
        this.storedItemCountByKeyType = localItemCountByKeyType;
        this.numberOfTypesByKeyType = localNumberOfTypesByKeyType;
        long localComputedUsedBytes = 0L;
        for (AEKeyType keyType : this.cellTypes) {
            Intrinsics.checkNotNull((Object)keyType);
            localComputedUsedBytes += this.getUsedBytesForType(keyType);
        }
        this.computedUsedBytes = localComputedUsedBytes;
    }

    private final void loadCellItems() {
        List<GenericStack> storedStacks = this.getStoredStacks();
        for (GenericStack storedStack : storedStacks) {
            Map<AEKey, Long> map = this.getCellItems();
            Intrinsics.checkNotNull(map);
            map.put(storedStack.what(), storedStack.amount());
        }
        SuperStorageCellExtraInfo extraInfo = this.getStoredExtraInfo();
        this.computedUsedBytes = extraInfo.getUsedBytes();
        this.recalculateValues();
    }

    public void getAvailableStacks(@NotNull KeyCounter out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Map<AEKey, Long> map = this.getCellItems();
        Intrinsics.checkNotNull(map);
        for (Map.Entry<AEKey, Long> entry : map.entrySet()) {
            out.add(entry.getKey(), ((Number)entry.getValue()).longValue());
        }
    }

    public double getIdleDrain() {
        SuperStorageCell superStorageCell = this.cell;
        Intrinsics.checkNotNull((Object)((Object)superStorageCell));
        return superStorageCell.getIdleDrain();
    }

    public int getBytesPerType() {
        SuperStorageCell superStorageCell = this.cell;
        Intrinsics.checkNotNull((Object)((Object)superStorageCell));
        return superStorageCell.getBytesPerType(this.itemStackLocal);
    }

    public final boolean canHoldNewItem() {
        return this.getTotalBytes() > this.getUsedBytes() && this.getRemainingItemTypes() > 0L;
    }

    public final long getTotalBytes() {
        SuperStorageCell superStorageCell = this.cell;
        Intrinsics.checkNotNull((Object)((Object)superStorageCell));
        return superStorageCell.getBytes(this.itemStackLocal);
    }

    public final long getFreeBytes() {
        return this.getTotalBytes() - this.getUsedBytes();
    }

    public long getTotalItemTypes() {
        return this.maxItemTypes;
    }

    public long getStoredItemCount() {
        long storedItemCount = 0L;
        for (Map.Entry<AEKeyType, Long> keyType : this.storedItemCountByKeyType.entrySet()) {
            storedItemCount += ((Number)keyType.getValue()).longValue();
        }
        return storedItemCount;
    }

    public final long getStoredItemCountForKeyType(@NotNull AEKeyType keyType) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        Long l = this.storedItemCountByKeyType.get(keyType);
        return l != null ? l : 0L;
    }

    public long getStoredItemTypes() {
        return this.storedItems;
    }

    public final long getRemainingItemTypes() {
        long baseOnTotal;
        long basedOnStorage = this.getFreeBytes() / (long)this.getBytesPerType();
        return basedOnStorage > (baseOnTotal = this.getTotalItemTypes() - this.getStoredItemTypes()) ? baseOnTotal : basedOnStorage;
    }

    public final long getUsedBytesForType(@NotNull AEKeyType keyType) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        long bytesForItemCount = (this.getStoredItemCountForKeyType(keyType) + (long)this.getUnusedItemCountForKeyType(keyType)) / (long)keyType.getAmountPerByte();
        Integer n = this.numberOfTypesByKeyType.get(keyType);
        return (long)((n != null ? n : 0) * this.getBytesPerType()) + bytesForItemCount;
    }

    public final long getUsedBytes() {
        return this.computedUsedBytes;
    }

    public final long getRemainingItemCount() {
        long remaining = this.getFreeBytes() * (long)this.itemsPerByte + (long)this.getUnusedItemCount();
        return remaining > 0L ? remaining : 0L;
    }

    public final long getRemainingItemCountForKeyType(@NotNull AEKeyType keyType) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        return this.getFreeBytes() * (long)keyType.getAmountPerByte() + (long)this.getUnusedItemCountForKeyType(keyType);
    }

    public final int getUnusedItemCount() {
        int div = (int)(this.getStoredItemCount() % (long)8);
        return div == 0 ? 0 : this.itemsPerByte - div;
    }

    public final int getUnusedItemCountForKeyType(@NotNull AEKeyType keyType) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        int div = (int)(this.getStoredItemCountForKeyType(keyType) % (long)8);
        return div == 0 ? 0 : keyType.getAmountPerByte() - div;
    }

    @Nullable
    public CellState getStatus() {
        if (this.getStoredItemTypes() == 0L) {
            return CellState.EMPTY;
        }
        if (this.canHoldNewItem()) {
            return CellState.NOT_EMPTY;
        }
        return CellState.FULL;
    }

    private final boolean isStorageCell(AEItemKey key) {
        SuperStorageCell type = SuperCellInventory.Companion.getStorageCell(key);
        return type != null && !type.storableInStorageCell();
    }

    public long insert(@Nullable AEKey what, long amount, @Nullable Actionable mode, @Nullable IActionSource source) {
        AEKey aEKey = what;
        Intrinsics.checkNotNull((Object)aEKey);
        Actionable actionable = mode;
        Intrinsics.checkNotNull((Object)actionable);
        IActionSource iActionSource = source;
        Intrinsics.checkNotNull((Object)iActionSource);
        long inserted = this.innerInsert(aEKey, amount, actionable, iActionSource);
        return this.hasVoidUpgrade ? amount : inserted;
    }

    private final long innerInsert(AEKey what, long amount, Actionable mode, IActionSource source) {
        long _amount;
        if (what instanceof AEItemKey && this.isStorageCell((AEItemKey)what)) {
            ItemStack itemStack = ((AEItemKey)what).toStack();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"toStack(...)");
            SuperCellInventory meInventory = Companion.createInventory(itemStack, null);
            if (!SuperCellInventory.Companion.isCellEmpty(meInventory)) {
                return 0L;
            }
        }
        Map<AEKey, Long> map = this.getCellItems();
        Intrinsics.checkNotNull(map);
        Long l = map.get(what);
        long currentAmount = l != null ? l : 0L;
        AEKeyType aEKeyType = what.getType();
        Intrinsics.checkNotNullExpressionValue((Object)aEKeyType, (String)"getType(...)");
        long remainingItemCount = this.getRemainingItemCountForKeyType(aEKeyType);
        if (currentAmount <= 0L) {
            if (!this.canHoldNewItem()) {
                return 0L;
            }
            long l2 = this.getBytesPerType();
            AEKeyType aEKeyType2 = what.getType();
            Intrinsics.checkNotNull((Object)aEKeyType2);
            if ((remainingItemCount -= l2 * (long)aEKeyType2.getAmountPerByte()) <= 0L) {
                return 0L;
            }
        }
        if ((_amount = amount) > (remainingItemCount = Math.max(0L, Math.min(this.maxItemsPerType - currentAmount, remainingItemCount)))) {
            _amount = remainingItemCount;
        }
        if (mode == Actionable.MODULATE) {
            Map<AEKey, Long> map2 = this.getCellItems();
            Intrinsics.checkNotNull(map2);
            map2.put(what, currentAmount + _amount);
            this.saveChanges();
        }
        return _amount;
    }

    public long extract(@Nullable AEKey what, long amount, @NotNull Actionable mode, @Nullable IActionSource source) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        long extractAmount = Math.min(Integer.MAX_VALUE, amount);
        Map<AEKey, Long> map = this.getCellItems();
        Intrinsics.checkNotNull(map);
        Long currentAmount = map.get(what);
        if (currentAmount != null && currentAmount > 0L) {
            if (extractAmount > currentAmount) {
                if (mode == Actionable.MODULATE) {
                    Map<AEKey, Long> map2 = this.getCellItems();
                    Intrinsics.checkNotNull(map2);
                    TypeIntrinsics.asMutableMap(map2).remove(what, currentAmount);
                    this.saveChanges();
                }
                return currentAmount;
            }
            if (mode == Actionable.MODULATE) {
                Map<AEKey, Long> map3 = this.getCellItems();
                Intrinsics.checkNotNull(map3);
                AEKey aEKey = what;
                Intrinsics.checkNotNull((Object)aEKey);
                map3.put(aEKey, currentAmount - extractAmount);
                this.saveChanges();
            }
            return extractAmount;
        }
        return 0L;
    }

    @NotNull
    public Component getDescription() {
        Component component = this.itemStackLocal.getHoverName();
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getHoverName(...)");
        return component;
    }

    public final boolean isFuzzy() {
        return this.partitionList instanceof FuzzyPriorityList;
    }

    private static final long _init_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).longValue();
    }

    static {
        int n = MAX_ITEM_TYPES;
        for (int x = 0; x < n; ++x) {
            SuperCellInventory.ITEM_SLOT_KEYS[x] = ITEM_SLOT + x;
            SuperCellInventory.ITEM_SLOT_COUNT_KEYS[x] = ITEM_SLOT_COUNT + x;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u0014J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\u00142\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0018\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006 "}, d2={"Lcom/the9grounds/aeadditions/me/storage/SuperCellInventory$Companion;", "", "<init>", "()V", "MAX_ITEM_TYPES", "", "ITEM_TYPE_TAG", "", "ITEM_COUNT_TAG", "ITEM_SLOT", "ITEM_SLOT_COUNT", "STACK_KEYS", "STACK_AMOUNTS", "ITEM_SLOT_KEYS", "", "[Ljava/lang/String;", "ITEM_SLOT_COUNT_KEYS", "getStorageCell", "Lcom/the9grounds/aeadditions/item/storage/SuperStorageCell;", "input", "Lnet/minecraft/world/item/ItemStack;", "itemKey", "Lappeng/api/stacks/AEItemKey;", "isCellEmpty", "", "cellInventory", "Lcom/the9grounds/aeadditions/me/storage/SuperCellInventory;", "isCell", "itemStack", "createInventory", "container", "Lappeng/api/storage/cells/ISaveProvider;", "AEAdditions-1.21.1-6.0.2"})
    public static final class Companion {
        private Companion() {
        }

        private final SuperStorageCell getStorageCell(ItemStack input) {
            if (input != null && input.getItem() instanceof SuperStorageCell) {
                Item item = input.getItem();
                Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type com.the9grounds.aeadditions.item.storage.SuperStorageCell");
                return (SuperStorageCell)item;
            }
            return null;
        }

        private final SuperStorageCell getStorageCell(AEItemKey itemKey) {
            if (itemKey.getItem() instanceof SuperStorageCell) {
                Item item = itemKey.getItem();
                Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type com.the9grounds.aeadditions.item.storage.SuperStorageCell");
                return (SuperStorageCell)item;
            }
            return null;
        }

        private final boolean isCellEmpty(SuperCellInventory cellInventory) {
            if (cellInventory == null) {
                return true;
            }
            return cellInventory.getAvailableStacks().isEmpty();
        }

        public final boolean isCell(@Nullable ItemStack itemStack) {
            return this.getStorageCell(itemStack) != null;
        }

        @Nullable
        public final SuperCellInventory createInventory(@NotNull ItemStack itemStack, @Nullable ISaveProvider container) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            Item item = itemStack.getItem();
            if (!(item instanceof SuperStorageCell)) {
                return null;
            }
            if (!((SuperStorageCell)item).isStorageCell(itemStack)) {
                return null;
            }
            return new SuperCellInventory((SuperStorageCell)item, itemStack, container);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

